// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/glue/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves partition metadata from the Data Catalog that contains unfiltered
// metadata.
//
// For IAM authorization, the public IAM action associated with this API is
// glue:GetPartitions .
func (c *Client) GetUnfilteredPartitionsMetadata(ctx context.Context, params *GetUnfilteredPartitionsMetadataInput, optFns ...func(*Options)) (*GetUnfilteredPartitionsMetadataOutput, error) {
	if params == nil {
		params = &GetUnfilteredPartitionsMetadataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetUnfilteredPartitionsMetadata", params, optFns, c.addOperationGetUnfilteredPartitionsMetadataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetUnfilteredPartitionsMetadataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetUnfilteredPartitionsMetadataInput struct {

	// The ID of the Data Catalog where the partitions in question reside. If none is
	// provided, the AWS account ID is used by default.
	//
	// This member is required.
	CatalogId *string

	// The name of the catalog database where the partitions reside.
	//
	// This member is required.
	DatabaseName *string

	// A list of supported permission types.
	//
	// This member is required.
	SupportedPermissionTypes []types.PermissionType

	// The name of the table that contains the partition.
	//
	// This member is required.
	TableName *string

	// A structure containing Lake Formation audit context information.
	AuditContext *types.AuditContext

	// An expression that filters the partitions to be returned.
	//
	// The expression uses SQL syntax similar to the SQL WHERE filter clause. The SQL
	// statement parser [JSQLParser]parses the expression.
	//
	// Operators: The following are the operators that you can use in the Expression
	// API call:
	//
	// = Checks whether the values of the two operands are equal; if yes, then the
	// condition becomes true.
	//
	// Example: Assume 'variable a' holds 10 and 'variable b' holds 20.
	//
	// (a = b) is not true.
	//
	// < > Checks whether the values of two operands are equal; if the values are not
	// equal, then the condition becomes true.
	//
	// Example: (a < > b) is true.
	//
	// > Checks whether the value of the left operand is greater than the value of the
	// right operand; if yes, then the condition becomes true.
	//
	// Example: (a > b) is not true.
	//
	// < Checks whether the value of the left operand is less than the value of the
	// right operand; if yes, then the condition becomes true.
	//
	// Example: (a < b) is true.
	//
	// >= Checks whether the value of the left operand is greater than or equal to the
	// value of the right operand; if yes, then the condition becomes true.
	//
	// Example: (a >= b) is not true.
	//
	// <= Checks whether the value of the left operand is less than or equal to the
	// value of the right operand; if yes, then the condition becomes true.
	//
	// Example: (a <= b) is true.
	//
	// AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL Logical operators.
	//
	// Supported Partition Key Types: The following are the supported partition keys.
	//
	//   - string
	//
	//   - date
	//
	//   - timestamp
	//
	//   - int
	//
	//   - bigint
	//
	//   - long
	//
	//   - tinyint
	//
	//   - smallint
	//
	//   - decimal
	//
	// If an type is encountered that is not valid, an exception is thrown.
	//
	// [JSQLParser]: http://jsqlparser.sourceforge.net/home.php
	Expression *string

	// The maximum number of partitions to return in a single response.
	MaxResults *int32

	// A continuation token, if this is not the first call to retrieve these
	// partitions.
	NextToken *string

	// A structure used as a protocol between query engines and Lake Formation or
	// Glue. Contains both a Lake Formation generated authorization identifier and
	// information from the request's authorization context.
	QuerySessionContext *types.QuerySessionContext

	// Specified only if the base tables belong to a different Amazon Web Services
	// Region.
	Region *string

	// The segment of the table's partitions to scan in this request.
	Segment *types.Segment

	noSmithyDocumentSerde
}

type GetUnfilteredPartitionsMetadataOutput struct {

	// A continuation token, if the returned list of partitions does not include the
	// last one.
	NextToken *string

	// A list of requested partitions.
	UnfilteredPartitions []types.UnfilteredPartition

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetUnfilteredPartitionsMetadataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetUnfilteredPartitionsMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetUnfilteredPartitionsMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetUnfilteredPartitionsMetadata"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetUnfilteredPartitionsMetadataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetUnfilteredPartitionsMetadata(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// GetUnfilteredPartitionsMetadataPaginatorOptions is the paginator options for
// GetUnfilteredPartitionsMetadata
type GetUnfilteredPartitionsMetadataPaginatorOptions struct {
	// The maximum number of partitions to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetUnfilteredPartitionsMetadataPaginator is a paginator for
// GetUnfilteredPartitionsMetadata
type GetUnfilteredPartitionsMetadataPaginator struct {
	options   GetUnfilteredPartitionsMetadataPaginatorOptions
	client    GetUnfilteredPartitionsMetadataAPIClient
	params    *GetUnfilteredPartitionsMetadataInput
	nextToken *string
	firstPage bool
}

// NewGetUnfilteredPartitionsMetadataPaginator returns a new
// GetUnfilteredPartitionsMetadataPaginator
func NewGetUnfilteredPartitionsMetadataPaginator(client GetUnfilteredPartitionsMetadataAPIClient, params *GetUnfilteredPartitionsMetadataInput, optFns ...func(*GetUnfilteredPartitionsMetadataPaginatorOptions)) *GetUnfilteredPartitionsMetadataPaginator {
	if params == nil {
		params = &GetUnfilteredPartitionsMetadataInput{}
	}

	options := GetUnfilteredPartitionsMetadataPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetUnfilteredPartitionsMetadataPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetUnfilteredPartitionsMetadataPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetUnfilteredPartitionsMetadata page.
func (p *GetUnfilteredPartitionsMetadataPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetUnfilteredPartitionsMetadataOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetUnfilteredPartitionsMetadata(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetUnfilteredPartitionsMetadataAPIClient is a client that implements the
// GetUnfilteredPartitionsMetadata operation.
type GetUnfilteredPartitionsMetadataAPIClient interface {
	GetUnfilteredPartitionsMetadata(context.Context, *GetUnfilteredPartitionsMetadataInput, ...func(*Options)) (*GetUnfilteredPartitionsMetadataOutput, error)
}

var _ GetUnfilteredPartitionsMetadataAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetUnfilteredPartitionsMetadata(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetUnfilteredPartitionsMetadata",
	}
}
