// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/glue/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The ListConnectionTypes API provides a discovery mechanism to learn available
// connection types in Glue. The response contains a list of connection types with
// high-level details of what is supported for each connection type. The connection
// types listed are the set of supported options for the ConnectionType value in
// the CreateConnection API.
func (c *Client) ListConnectionTypes(ctx context.Context, params *ListConnectionTypesInput, optFns ...func(*Options)) (*ListConnectionTypesOutput, error) {
	if params == nil {
		params = &ListConnectionTypesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListConnectionTypes", params, optFns, c.addOperationListConnectionTypesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListConnectionTypesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListConnectionTypesInput struct {

	// The maximum number of results to return.
	MaxResults *int32

	// A continuation token, if this is a continuation call.
	NextToken *string

	noSmithyDocumentSerde
}

type ListConnectionTypesOutput struct {

	// A list of ConnectionTypeBrief objects containing brief information about the
	// supported connection types.
	ConnectionTypes []types.ConnectionTypeBrief

	// A continuation token, if the current list segment is not the last.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListConnectionTypesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListConnectionTypes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListConnectionTypes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListConnectionTypes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListConnectionTypes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListConnectionTypesPaginatorOptions is the paginator options for
// ListConnectionTypes
type ListConnectionTypesPaginatorOptions struct {
	// The maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListConnectionTypesPaginator is a paginator for ListConnectionTypes
type ListConnectionTypesPaginator struct {
	options   ListConnectionTypesPaginatorOptions
	client    ListConnectionTypesAPIClient
	params    *ListConnectionTypesInput
	nextToken *string
	firstPage bool
}

// NewListConnectionTypesPaginator returns a new ListConnectionTypesPaginator
func NewListConnectionTypesPaginator(client ListConnectionTypesAPIClient, params *ListConnectionTypesInput, optFns ...func(*ListConnectionTypesPaginatorOptions)) *ListConnectionTypesPaginator {
	if params == nil {
		params = &ListConnectionTypesInput{}
	}

	options := ListConnectionTypesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListConnectionTypesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListConnectionTypesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListConnectionTypes page.
func (p *ListConnectionTypesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListConnectionTypesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListConnectionTypes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListConnectionTypesAPIClient is a client that implements the
// ListConnectionTypes operation.
type ListConnectionTypesAPIClient interface {
	ListConnectionTypes(context.Context, *ListConnectionTypesInput, ...func(*Options)) (*ListConnectionTypesOutput, error)
}

var _ ListConnectionTypesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListConnectionTypes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListConnectionTypes",
	}
}
