// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/glue/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This API is used to provide optional override properties for the tables that
// need to be replicated. These properties can include properties for filtering and
// partitioning for the source and target tables. To set both source and target
// properties the same API need to be invoked with the Glue connection ARN as
// ResourceArn with SourceTableConfig , and the Glue database ARN as ResourceArn
// with TargetTableConfig respectively.
//
// The override will be reflected across all the integrations using same
// ResourceArn and source table.
func (c *Client) UpdateIntegrationTableProperties(ctx context.Context, params *UpdateIntegrationTablePropertiesInput, optFns ...func(*Options)) (*UpdateIntegrationTablePropertiesOutput, error) {
	if params == nil {
		params = &UpdateIntegrationTablePropertiesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateIntegrationTableProperties", params, optFns, c.addOperationUpdateIntegrationTablePropertiesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateIntegrationTablePropertiesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateIntegrationTablePropertiesInput struct {

	// The connection ARN of the source, or the database ARN of the target.
	//
	// This member is required.
	ResourceArn *string

	// The name of the table to be replicated.
	//
	// This member is required.
	TableName *string

	// A structure for the source table configuration.
	SourceTableConfig *types.SourceTableConfig

	// A structure for the target table configuration.
	TargetTableConfig *types.TargetTableConfig

	noSmithyDocumentSerde
}

type UpdateIntegrationTablePropertiesOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateIntegrationTablePropertiesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateIntegrationTableProperties{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateIntegrationTableProperties{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateIntegrationTableProperties"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateIntegrationTablePropertiesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateIntegrationTableProperties(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateIntegrationTableProperties(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateIntegrationTableProperties",
	}
}
