// Code generated by smithy-go-codegen DO NOT EDIT.

package greengrassv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/greengrassv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a paginated list of Greengrass core devices.
//
// IoT Greengrass relies on individual devices to send status updates to the
// Amazon Web Services Cloud. If the IoT Greengrass Core software isn't running on
// the device, or if device isn't connected to the Amazon Web Services Cloud, then
// the reported status of that device might not reflect its current status. The
// status timestamp indicates when the device status was last updated.
//
// Core devices send status updates at the following times:
//
//   - When the IoT Greengrass Core software starts
//
//   - When the core device receives a deployment from the Amazon Web Services
//     Cloud
//
//   - For Greengrass nucleus 2.12.2 and earlier, the core device sends status
//     updates when the status of any component on the core device becomes ERRORED or
//     BROKEN .
//
//   - For Greengrass nucleus 2.12.3 and later, the core device sends status
//     updates when the status of any component on the core device becomes ERRORED ,
//     BROKEN , RUNNING , or FINISHED .
//
//   - At a [regular interval that you can configure], which defaults to 24 hours
//
//   - For IoT Greengrass Core v2.7.0, the core device sends status updates upon
//     local deployment and cloud deployment
//
// [regular interval that you can configure]: https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss
func (c *Client) ListCoreDevices(ctx context.Context, params *ListCoreDevicesInput, optFns ...func(*Options)) (*ListCoreDevicesOutput, error) {
	if params == nil {
		params = &ListCoreDevicesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCoreDevices", params, optFns, c.addOperationListCoreDevicesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCoreDevicesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCoreDevicesInput struct {

	// The maximum number of results to be returned per paginated request.
	MaxResults *int32

	// The token to be used for the next set of paginated results.
	NextToken *string

	// The runtime to be used by the core device. The runtime can be:
	//
	//   - aws_nucleus_classic
	//
	//   - aws_nucleus_lite
	Runtime *string

	// The core device status by which to filter. If you specify this parameter, the
	// list includes only core devices that have this status. Choose one of the
	// following options:
	//
	//   - HEALTHY – The IoT Greengrass Core software and all components run on the
	//   core device without issue.
	//
	//   - UNHEALTHY – The IoT Greengrass Core software or a component is in a failed
	//   state on the core device.
	Status types.CoreDeviceStatus

	// The [ARN] of the IoT thing group by which to filter. If you specify this parameter,
	// the list includes only core devices that have successfully deployed a deployment
	// that targets the thing group. When you remove a core device from a thing group,
	// the list continues to include that core device.
	//
	// [ARN]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	ThingGroupArn *string

	noSmithyDocumentSerde
}

type ListCoreDevicesOutput struct {

	// A list that summarizes each core device.
	CoreDevices []types.CoreDevice

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCoreDevicesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCoreDevices{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCoreDevices{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCoreDevices"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCoreDevices(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCoreDevicesPaginatorOptions is the paginator options for ListCoreDevices
type ListCoreDevicesPaginatorOptions struct {
	// The maximum number of results to be returned per paginated request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCoreDevicesPaginator is a paginator for ListCoreDevices
type ListCoreDevicesPaginator struct {
	options   ListCoreDevicesPaginatorOptions
	client    ListCoreDevicesAPIClient
	params    *ListCoreDevicesInput
	nextToken *string
	firstPage bool
}

// NewListCoreDevicesPaginator returns a new ListCoreDevicesPaginator
func NewListCoreDevicesPaginator(client ListCoreDevicesAPIClient, params *ListCoreDevicesInput, optFns ...func(*ListCoreDevicesPaginatorOptions)) *ListCoreDevicesPaginator {
	if params == nil {
		params = &ListCoreDevicesInput{}
	}

	options := ListCoreDevicesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCoreDevicesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCoreDevicesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCoreDevices page.
func (p *ListCoreDevicesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCoreDevicesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCoreDevices(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCoreDevicesAPIClient is a client that implements the ListCoreDevices
// operation.
type ListCoreDevicesAPIClient interface {
	ListCoreDevices(context.Context, *ListCoreDevicesInput, ...func(*Options)) (*ListCoreDevicesOutput, error)
}

var _ ListCoreDevicesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCoreDevices(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCoreDevices",
	}
}
