// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Detailed information about the agent.
type AgentDetails struct {

	// Current agent version.
	//
	// This member is required.
	AgentVersion *string

	// List of versions being used by agent components.
	//
	// This member is required.
	ComponentVersions []ComponentVersion

	// ID of EC2 instance agent is running on.
	//
	// This member is required.
	InstanceId *string

	// Type of EC2 instance agent is running on.
	//
	// This member is required.
	InstanceType *string

	// List of CPU cores reserved for the agent.
	AgentCpuCores []int32

	// This field should not be used. Use agentCpuCores instead.
	//
	// List of CPU cores reserved for processes other than the agent running on the
	// EC2 instance.
	ReservedCpuCores []int32

	noSmithyDocumentSerde
}

// Aggregate status of Agent components.
type AggregateStatus struct {

	// Aggregate status.
	//
	// This member is required.
	Status AgentStatus

	// Sparse map of failure signatures.
	SignatureMap map[string]bool

	noSmithyDocumentSerde
}

// Details about an antenna demod decode Config used in a contact.
type AntennaDemodDecodeDetails struct {

	// Name of an antenna demod decode output node used in a contact.
	OutputNode *string

	noSmithyDocumentSerde
}

// Information about how AWS Ground Station should configure an antenna for
// downlink during a contact.
type AntennaDownlinkConfig struct {

	// Object that describes a spectral Config .
	//
	// This member is required.
	SpectrumConfig *SpectrumConfig

	noSmithyDocumentSerde
}

// Information about how AWS Ground Station should conﬁgure an antenna for
// downlink demod decode during a contact.
type AntennaDownlinkDemodDecodeConfig struct {

	// Information about the decode Config .
	//
	// This member is required.
	DecodeConfig *DecodeConfig

	// Information about the demodulation Config .
	//
	// This member is required.
	DemodulationConfig *DemodulationConfig

	// Information about the spectral Config .
	//
	// This member is required.
	SpectrumConfig *SpectrumConfig

	noSmithyDocumentSerde
}

// Information about the uplink Config of an antenna.
type AntennaUplinkConfig struct {

	// Information about the uplink spectral Config .
	//
	// This member is required.
	SpectrumConfig *UplinkSpectrumConfig

	// EIRP of the target.
	//
	// This member is required.
	TargetEirp *Eirp

	// Whether or not uplink transmit is disabled.
	TransmitDisabled *bool

	noSmithyDocumentSerde
}

// Information about AwsGroundStationAgentEndpoint.
type AwsGroundStationAgentEndpoint struct {

	// The egress address of AgentEndpoint.
	//
	// This member is required.
	EgressAddress *ConnectionDetails

	// The ingress address of AgentEndpoint.
	//
	// This member is required.
	IngressAddress *RangedConnectionDetails

	// Name string associated with AgentEndpoint. Used as a human-readable identifier
	// for AgentEndpoint.
	//
	// This member is required.
	Name *string

	// The status of AgentEndpoint.
	AgentStatus AgentStatus

	// The results of the audit.
	AuditResults AuditResults

	noSmithyDocumentSerde
}

// Azimuth elevation ephemeris data.
//
// Use this ephemeris type to provide pointing angles directly, rather than
// satellite orbital elements. Use this when you need precise antenna pointing but
// have imprecise or unknown satellite trajectory information.
//
// The azimuth elevation data specifies the antenna pointing direction at specific
// times relative to a ground station location. AWS Ground Station uses 4th order
// Lagrange interpolation to compute pointing angles between the provided data
// points.
//
// AWS Ground Station automatically filters interpolated pointing angles,
// including only those that are above the site mask elevation of the specified
// ground station.
//
// For more detail about providing azimuth elevation ephemerides to AWS Ground
// Station, see the [azimuth elevation ephemeris section]of the AWS Ground Station User Guide.
//
// [azimuth elevation ephemeris section]: https://docs.aws.amazon.com/ground-station/latest/ug/providing-azimuth-elevation-ephemeris-data.html
type AzElEphemeris struct {

	// Azimuth elevation segment data.
	//
	// You can provide data inline in the request or through an Amazon S3 object
	// reference.
	//
	// This member is required.
	Data AzElSegmentsData

	// The ground station name for which you're providing azimuth elevation data.
	//
	// This ephemeris is specific to this ground station and can't be used at other
	// locations.
	//
	// This member is required.
	GroundStation *string

	noSmithyDocumentSerde
}

// Filter for selecting contacts that use a specific AzElEphemeris.
type AzElEphemerisFilter struct {

	// Unique identifier of the azimuth elevation ephemeris.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Program track settings for AzElEphemeris.
type AzElProgramTrackSettings struct {

	// Unique identifier of the azimuth elevation ephemeris.
	//
	// This member is required.
	EphemerisId *string

	noSmithyDocumentSerde
}

// A time segment containing azimuth elevation pointing data.
//
// Each segment defines a continuous time period with pointing angle data points.
// AWS Ground Station uses 4th order Lagrange interpolation between the provided
// points, so each segment must contain at least five data points.
type AzElSegment struct {

	// List of time-tagged azimuth elevation data points.
	//
	// Must contain at least five points to support 4th order Lagrange interpolation.
	// Points must be in chronological order with no duplicates.
	//
	// This member is required.
	AzElList []TimeAzEl

	// The reference time for this segment in ISO 8601 format in Coordinated Universal
	// Time (UTC).
	//
	// All time values within the segment's AzElSegment$azElList are specified as offsets in atomic
	// seconds from this reference epoch.
	//
	// Example: 2024-01-15T12:00:00.000Z
	//
	// This member is required.
	ReferenceEpoch *time.Time

	// The valid time range for this segment.
	//
	// Specifies the start and end timestamps in ISO 8601 format in Coordinated
	// Universal Time (UTC). The segment's pointing data must cover this entire time
	// range.
	//
	// This member is required.
	ValidTimeRange *ISO8601TimeRange

	noSmithyDocumentSerde
}

// Azimuth elevation segment collection.
//
// Contains five or more time-ordered segments that define antenna pointing angles
// over the ephemeris validity period.
type AzElSegments struct {

	// The unit of measure for azimuth and elevation angles. All angles in all
	// segments must use the same unit.
	//
	// This member is required.
	AngleUnit AngleUnits

	// List of azimuth elevation segments.
	//
	// Must contain between 1 and 100 segments. Segments must be in chronological
	// order with no overlaps.
	//
	// This member is required.
	AzElSegmentList []AzElSegment

	noSmithyDocumentSerde
}

// Container for azimuth elevation segment data.
//
// Specify either AzElSegmentsData$s3Object to reference data in Amazon S3, or AzElSegmentsData$azElData to provide data inline.
//
// The following types satisfy this interface:
//
//	AzElSegmentsDataMemberAzElData
//	AzElSegmentsDataMemberS3Object
type AzElSegmentsData interface {
	isAzElSegmentsData()
}

// Azimuth elevation segment data provided directly in the request.
//
// Use this option for smaller datasets or when Amazon S3 access is not available.
type AzElSegmentsDataMemberAzElData struct {
	Value AzElSegments

	noSmithyDocumentSerde
}

func (*AzElSegmentsDataMemberAzElData) isAzElSegmentsData() {}

// The Amazon S3 object containing azimuth elevation segment data.
//
// The Amazon S3 object must contain JSON-formatted azimuth elevation data
// matching the AzElSegmentsstructure.
type AzElSegmentsDataMemberS3Object struct {
	Value S3Object

	noSmithyDocumentSerde
}

func (*AzElSegmentsDataMemberS3Object) isAzElSegmentsData() {}

// Data on the status of agent components.
type ComponentStatusData struct {

	// Capability ARN of the component.
	//
	// This member is required.
	CapabilityArn *string

	// The Component type.
	//
	// This member is required.
	ComponentType *string

	// Dataflow UUID associated with the component.
	//
	// This member is required.
	DataflowId *string

	// Component status.
	//
	// This member is required.
	Status AgentStatus

	// Bytes received by the component.
	BytesReceived *int64

	// Bytes sent by the component.
	BytesSent *int64

	// Packets dropped by component.
	PacketsDropped *int64

	noSmithyDocumentSerde
}

// Version information for agent components.
type ComponentVersion struct {

	// Component type.
	//
	// This member is required.
	ComponentType *string

	// List of versions.
	//
	// This member is required.
	Versions []string

	noSmithyDocumentSerde
}

// Details for certain Config object types in a contact.
//
// The following types satisfy this interface:
//
//	ConfigDetailsMemberAntennaDemodDecodeDetails
//	ConfigDetailsMemberEndpointDetails
//	ConfigDetailsMemberS3RecordingDetails
type ConfigDetails interface {
	isConfigDetails()
}

// Details for antenna demod decode Config in a contact.
type ConfigDetailsMemberAntennaDemodDecodeDetails struct {
	Value AntennaDemodDecodeDetails

	noSmithyDocumentSerde
}

func (*ConfigDetailsMemberAntennaDemodDecodeDetails) isConfigDetails() {}

// Information about the endpoint details.
type ConfigDetailsMemberEndpointDetails struct {
	Value EndpointDetails

	noSmithyDocumentSerde
}

func (*ConfigDetailsMemberEndpointDetails) isConfigDetails() {}

// Details for an S3 recording Config in a contact.
type ConfigDetailsMemberS3RecordingDetails struct {
	Value S3RecordingDetails

	noSmithyDocumentSerde
}

func (*ConfigDetailsMemberS3RecordingDetails) isConfigDetails() {}

// An item in a list of Config objects.
type ConfigListItem struct {

	// ARN of a Config .
	ConfigArn *string

	// UUID of a Config .
	ConfigId *string

	// Type of a Config .
	ConfigType ConfigCapabilityType

	// Name of a Config .
	Name *string

	noSmithyDocumentSerde
}

// Object containing the parameters of a Config .
//
// See the subtype definitions for what each type of Config contains.
//
// The following types satisfy this interface:
//
//	ConfigTypeDataMemberAntennaDownlinkConfig
//	ConfigTypeDataMemberAntennaDownlinkDemodDecodeConfig
//	ConfigTypeDataMemberAntennaUplinkConfig
//	ConfigTypeDataMemberDataflowEndpointConfig
//	ConfigTypeDataMemberS3RecordingConfig
//	ConfigTypeDataMemberTrackingConfig
//	ConfigTypeDataMemberUplinkEchoConfig
type ConfigTypeData interface {
	isConfigTypeData()
}

// Information about how AWS Ground Station should configure an antenna for
// downlink during a contact.
type ConfigTypeDataMemberAntennaDownlinkConfig struct {
	Value AntennaDownlinkConfig

	noSmithyDocumentSerde
}

func (*ConfigTypeDataMemberAntennaDownlinkConfig) isConfigTypeData() {}

// Information about how AWS Ground Station should conﬁgure an antenna for
// downlink demod decode during a contact.
type ConfigTypeDataMemberAntennaDownlinkDemodDecodeConfig struct {
	Value AntennaDownlinkDemodDecodeConfig

	noSmithyDocumentSerde
}

func (*ConfigTypeDataMemberAntennaDownlinkDemodDecodeConfig) isConfigTypeData() {}

// Information about how AWS Ground Station should conﬁgure an antenna for uplink
// during a contact.
type ConfigTypeDataMemberAntennaUplinkConfig struct {
	Value AntennaUplinkConfig

	noSmithyDocumentSerde
}

func (*ConfigTypeDataMemberAntennaUplinkConfig) isConfigTypeData() {}

// Information about the dataflow endpoint Config .
type ConfigTypeDataMemberDataflowEndpointConfig struct {
	Value DataflowEndpointConfig

	noSmithyDocumentSerde
}

func (*ConfigTypeDataMemberDataflowEndpointConfig) isConfigTypeData() {}

// Information about an S3 recording Config .
type ConfigTypeDataMemberS3RecordingConfig struct {
	Value S3RecordingConfig

	noSmithyDocumentSerde
}

func (*ConfigTypeDataMemberS3RecordingConfig) isConfigTypeData() {}

// Object that determines whether tracking should be used during a contact
// executed with this Config in the mission profile.
type ConfigTypeDataMemberTrackingConfig struct {
	Value TrackingConfig

	noSmithyDocumentSerde
}

func (*ConfigTypeDataMemberTrackingConfig) isConfigTypeData() {}

// Information about an uplink echo Config .
//
// Parameters from the AntennaUplinkConfig , corresponding to the specified
// AntennaUplinkConfigArn , are used when this UplinkEchoConfig is used in a
// contact.
type ConfigTypeDataMemberUplinkEchoConfig struct {
	Value UplinkEchoConfig

	noSmithyDocumentSerde
}

func (*ConfigTypeDataMemberUplinkEchoConfig) isConfigTypeData() {}

// Egress address of AgentEndpoint with an optional mtu.
type ConnectionDetails struct {

	// A socket address.
	//
	// This member is required.
	SocketAddress *SocketAddress

	// Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
	Mtu *int32

	noSmithyDocumentSerde
}

// Data describing a contact.
type ContactData struct {

	// UUID of a contact.
	ContactId *string

	// Status of a contact.
	ContactStatus ContactStatus

	// End time of a contact in UTC.
	EndTime *time.Time

	// The ephemeris that determines antenna pointing for the contact.
	Ephemeris *EphemerisResponseData

	// Error message of a contact.
	ErrorMessage *string

	// Name of a ground station.
	GroundStation *string

	// Maximum elevation angle of a contact.
	MaximumElevation *Elevation

	// ARN of a mission profile.
	MissionProfileArn *string

	// Amount of time after a contact ends that you’d like to receive a CloudWatch
	// event indicating the pass has finished.
	PostPassEndTime *time.Time

	// Amount of time prior to contact start you’d like to receive a CloudWatch event
	// indicating an upcoming pass.
	PrePassStartTime *time.Time

	// Region of a contact.
	Region *string

	// ARN of a satellite.
	SatelliteArn *string

	// Start time of a contact in UTC.
	StartTime *time.Time

	// Tags assigned to a contact.
	Tags map[string]string

	//  Projected time in UTC your satellite will set below the [receive mask]. This time is based
	// on the satellite's current active ephemeris for future contacts and the
	// ephemeris that was active during contact execution for completed contacts. This
	// field is not present for contacts with a SCHEDULING or SCHEDULED status.
	//
	// [receive mask]: https://docs.aws.amazon.com/ground-station/latest/ug/site-masks.html
	VisibilityEndTime *time.Time

	//  Projected time in UTC your satellite will rise above the [receive mask]. This time is based
	// on the satellite's current active ephemeris for future contacts and the
	// ephemeris that was active during contact execution for completed contacts. This
	// field is not present for contacts with a SCHEDULING or SCHEDULED status.
	//
	// [receive mask]: https://docs.aws.amazon.com/ground-station/latest/ug/site-masks.html
	VisibilityStartTime *time.Time

	noSmithyDocumentSerde
}

// Endpoint definition used for creating a dataflow endpoint
//
// The following types satisfy this interface:
//
//	CreateEndpointDetailsMemberDownlinkAwsGroundStationAgentEndpoint
//	CreateEndpointDetailsMemberUplinkAwsGroundStationAgentEndpoint
type CreateEndpointDetails interface {
	isCreateEndpointDetails()
}

// Definition for a downlink agent endpoint
type CreateEndpointDetailsMemberDownlinkAwsGroundStationAgentEndpoint struct {
	Value DownlinkAwsGroundStationAgentEndpoint

	noSmithyDocumentSerde
}

func (*CreateEndpointDetailsMemberDownlinkAwsGroundStationAgentEndpoint) isCreateEndpointDetails() {}

// Definition for an uplink agent endpoint
type CreateEndpointDetailsMemberUplinkAwsGroundStationAgentEndpoint struct {
	Value UplinkAwsGroundStationAgentEndpoint

	noSmithyDocumentSerde
}

func (*CreateEndpointDetailsMemberUplinkAwsGroundStationAgentEndpoint) isCreateEndpointDetails() {}

// Information about a dataflow edge used in a contact.
type DataflowDetail struct {

	// Dataflow details for the destination side.
	Destination *Destination

	// Error message for a dataflow.
	ErrorMessage *string

	// Dataflow details for the source side.
	Source *Source

	noSmithyDocumentSerde
}

// Information about a dataflow endpoint.
type DataflowEndpoint struct {

	// Socket address of a dataflow endpoint.
	Address *SocketAddress

	// Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
	Mtu *int32

	// Name of a dataflow endpoint.
	Name *string

	// Status of a dataflow endpoint.
	Status EndpointStatus

	noSmithyDocumentSerde
}

// Information about the dataflow endpoint Config .
type DataflowEndpointConfig struct {

	// Name of a dataflow endpoint.
	//
	// This member is required.
	DataflowEndpointName *string

	// Region of a dataflow endpoint.
	DataflowEndpointRegion *string

	noSmithyDocumentSerde
}

// Item in a list of DataflowEndpoint groups.
type DataflowEndpointListItem struct {

	// ARN of a dataflow endpoint group.
	DataflowEndpointGroupArn *string

	// UUID of a dataflow endpoint group.
	DataflowEndpointGroupId *string

	noSmithyDocumentSerde
}

// Information about the decode Config .
type DecodeConfig struct {

	// Unvalidated JSON of a decode Config .
	//
	// This member is required.
	UnvalidatedJSON *string

	noSmithyDocumentSerde
}

// Information about the demodulation Config .
type DemodulationConfig struct {

	// Unvalidated JSON of a demodulation Config .
	//
	// This member is required.
	UnvalidatedJSON *string

	noSmithyDocumentSerde
}

// Dataflow details for the destination side.
type Destination struct {

	// Additional details for a Config , if type is dataflow endpoint or antenna demod
	// decode.
	ConfigDetails ConfigDetails

	// UUID of a Config .
	ConfigId *string

	// Type of a Config .
	ConfigType ConfigCapabilityType

	// Region of a dataflow destination.
	DataflowDestinationRegion *string

	noSmithyDocumentSerde
}

// Data for agent discovery.
type DiscoveryData struct {

	// List of capabilities to associate with agent.
	//
	// This member is required.
	CapabilityArns []string

	// List of private IP addresses to associate with agent.
	//
	// This member is required.
	PrivateIpAddresses []string

	// List of public IP addresses to associate with agent.
	//
	// This member is required.
	PublicIpAddresses []string

	noSmithyDocumentSerde
}

// Definition for a downlink agent endpoint
type DownlinkAwsGroundStationAgentEndpoint struct {

	// Dataflow details for the downlink endpoint
	//
	// This member is required.
	DataflowDetails DownlinkDataflowDetails

	// Downlink dataflow endpoint name
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Details for a downlink agent endpoint
type DownlinkAwsGroundStationAgentEndpointDetails struct {

	// Dataflow details for the downlink endpoint
	//
	// This member is required.
	DataflowDetails DownlinkDataflowDetails

	// Downlink dataflow endpoint name
	//
	// This member is required.
	Name *string

	// Status of the agent associated with the downlink dataflow endpoint
	AgentStatus AgentStatus

	// Health audit results for the downlink dataflow endpoint
	AuditResults AuditResults

	noSmithyDocumentSerde
}

// Connection details for Ground Station to Agent and Agent to customer
type DownlinkConnectionDetails struct {

	// Ingress address of AgentEndpoint with a port range and an optional mtu.
	//
	// This member is required.
	AgentIpAndPortAddress *RangedConnectionDetails

	// Egress address of AgentEndpoint with an optional mtu.
	//
	// This member is required.
	EgressAddressAndPort *ConnectionDetails

	noSmithyDocumentSerde
}

// Dataflow details for a downlink endpoint
//
// The following types satisfy this interface:
//
//	DownlinkDataflowDetailsMemberAgentConnectionDetails
type DownlinkDataflowDetails interface {
	isDownlinkDataflowDetails()
}

// Downlink connection details for customer to Agent and Agent to Ground Station
type DownlinkDataflowDetailsMemberAgentConnectionDetails struct {
	Value DownlinkConnectionDetails

	noSmithyDocumentSerde
}

func (*DownlinkDataflowDetailsMemberAgentConnectionDetails) isDownlinkDataflowDetails() {}

// Object that represents EIRP.
type Eirp struct {

	// Units of an EIRP.
	//
	// This member is required.
	Units EirpUnits

	// Value of an EIRP. Valid values are between 20.0 to 50.0 dBW.
	//
	// This member is required.
	Value *float64

	noSmithyDocumentSerde
}

// Elevation angle of the satellite in the sky during a contact.
type Elevation struct {

	// Elevation angle units.
	//
	// This member is required.
	Unit AngleUnits

	// Elevation angle value.
	//
	// This member is required.
	Value *float64

	noSmithyDocumentSerde
}

// Information about the endpoint details.
type EndpointDetails struct {

	// An agent endpoint.
	AwsGroundStationAgentEndpoint *AwsGroundStationAgentEndpoint

	// Definition for a downlink agent endpoint
	DownlinkAwsGroundStationAgentEndpoint *DownlinkAwsGroundStationAgentEndpointDetails

	// A dataflow endpoint.
	Endpoint *DataflowEndpoint

	// Health reasons for a dataflow endpoint. This field is ignored when calling
	// CreateDataflowEndpointGroup .
	HealthReasons []CapabilityHealthReason

	// A dataflow endpoint health status. This field is ignored when calling
	// CreateDataflowEndpointGroup .
	HealthStatus CapabilityHealth

	// Endpoint security details including a list of subnets, a list of security
	// groups and a role to connect streams to instances.
	SecurityDetails *SecurityDetails

	// Definition for an uplink agent endpoint
	UplinkAwsGroundStationAgentEndpoint *UplinkAwsGroundStationAgentEndpointDetails

	noSmithyDocumentSerde
}

// Ephemeris data.
//
// The following types satisfy this interface:
//
//	EphemerisDataMemberAzEl
//	EphemerisDataMemberOem
//	EphemerisDataMemberTle
type EphemerisData interface {
	isEphemerisData()
}

// Azimuth elevation ephemeris data.
//
// Use this ephemeris type to provide pointing angles directly, rather than
// satellite orbital elements. Use this when you need precise antenna pointing but
// have imprecise or unknown satellite trajectory information.
//
// The azimuth elevation data specifies the antenna pointing direction at specific
// times relative to a ground station location. AWS Ground Station uses 4th order
// Lagrange interpolation to compute pointing angles between the provided data
// points.
//
// AWS Ground Station automatically filters interpolated pointing angles,
// including only those that are above the site mask elevation of the specified
// ground station.
//
// For more detail about providing azimuth elevation ephemerides to AWS Ground
// Station, see the [azimuth elevation ephemeris section]of the AWS Ground Station User Guide.
//
// [azimuth elevation ephemeris section]: https://docs.aws.amazon.com/ground-station/latest/ug/providing-azimuth-elevation-ephemeris-data.html
type EphemerisDataMemberAzEl struct {
	Value AzElEphemeris

	noSmithyDocumentSerde
}

func (*EphemerisDataMemberAzEl) isEphemerisData() {}

// Ephemeris data in Orbit Ephemeris Message (OEM) format.
//
// AWS Ground Station processes OEM ephemerides according to the [CCSDS standard] with some extra
// restrictions. OEM files should be in KVN format. For more detail about the OEM
// format that AWS Ground Station supports, see [OEM ephemeris format]in the AWS Ground Station user
// guide.
//
// [CCSDS standard]: https://ccsds.org/wp-content/uploads/gravity_forms/5-448e85c647331d9cbaf66c096458bdd5/2025/01//502x0b3e1.pdf
// [OEM ephemeris format]: https://docs.aws.amazon.com/ground-station/latest/ug/providing-oem-ephemeris-data.html#oem-ephemeris-format
type EphemerisDataMemberOem struct {
	Value OEMEphemeris

	noSmithyDocumentSerde
}

func (*EphemerisDataMemberOem) isEphemerisData() {}

// Two-line element set (TLE) ephemeris.
//
// For more detail about providing Two-line element sets to AWS Ground Station,
// see the [TLE section]of the AWS Ground Station user guide.
//
// [TLE section]: https://docs.aws.amazon.com/ground-station/latest/ug/providing-tle-ephemeris-data.html
type EphemerisDataMemberTle struct {
	Value TLEEphemeris

	noSmithyDocumentSerde
}

func (*EphemerisDataMemberTle) isEphemerisData() {}

// Description of ephemeris.
type EphemerisDescription struct {

	// Supplied ephemeris data.
	EphemerisData *string

	// Source Amazon S3 object used for the ephemeris.
	SourceS3Object *S3Object

	noSmithyDocumentSerde
}

// Detailed error information for ephemeris validation failures.
//
// Provides an error code and descriptive message to help diagnose and resolve
// validation issues.
type EphemerisErrorReason struct {

	// The error code identifying the type of validation failure.
	//
	// See the [Troubleshooting Invalid Ephemerides guide] for error code details.
	//
	// [Troubleshooting Invalid Ephemerides guide]: https://docs.aws.amazon.com/ground-station/latest/ug/troubleshooting-invalid-ephemerides.html
	//
	// This member is required.
	ErrorCode EphemerisErrorCode

	// A human-readable message describing the validation failure.
	//
	// Provides specific details about what failed and may include suggestions for
	// remediation.
	//
	// This member is required.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Filter for selecting contacts that use a specific ephemeris".
//
// The following types satisfy this interface:
//
//	EphemerisFilterMemberAzEl
type EphemerisFilter interface {
	isEphemerisFilter()
}

// Filter for AzElEphemeris.
type EphemerisFilterMemberAzEl struct {
	Value AzElEphemerisFilter

	noSmithyDocumentSerde
}

func (*EphemerisFilterMemberAzEl) isEphemerisFilter() {}

// Ephemeris item.
type EphemerisItem struct {

	// The time the ephemeris was uploaded in UTC.
	CreationTime *time.Time

	// Whether or not the ephemeris is enabled.
	Enabled *bool

	// The AWS Ground Station ephemeris ID.
	EphemerisId *string

	// The type of ephemeris.
	EphemerisType EphemerisType

	// A name that you can use to identify the ephemeris.
	Name *string

	// A priority score that determines which ephemeris to use when multiple
	// ephemerides overlap.
	//
	// Higher numbers take precedence. The default is 1. Must be 1 or greater.
	Priority *int32

	// Source Amazon S3 object used for the ephemeris.
	SourceS3Object *S3Object

	// The status of the ephemeris.
	Status EphemerisStatus

	noSmithyDocumentSerde
}

// Metadata describing a particular ephemeris.
type EphemerisMetaData struct {

	// The EphemerisSource that generated a given ephemeris.
	//
	// This member is required.
	Source EphemerisSource

	// UUID of a customer-provided ephemeris.
	//
	// This field is not populated for default ephemerides from Space Track.
	EphemerisId *string

	// The epoch of a default, ephemeris from Space Track in UTC.
	//
	// This field is not populated for customer-provided ephemerides.
	Epoch *time.Time

	// A name string associated with the ephemeris. Used as a human-readable
	// identifier for the ephemeris.
	//
	// A name is only returned for customer-provider ephemerides that have a name
	// associated.
	Name *string

	noSmithyDocumentSerde
}

// Ephemeris data for a contact.
type EphemerisResponseData struct {

	// Type of ephemeris.
	//
	// This member is required.
	EphemerisType EphemerisType

	// Unique identifier of the ephemeris. Appears only for custom ephemerides.
	EphemerisId *string

	noSmithyDocumentSerde
}

// The following types satisfy this interface:
//
//	EphemerisTypeDescriptionMemberAzEl
//	EphemerisTypeDescriptionMemberOem
//	EphemerisTypeDescriptionMemberTle
type EphemerisTypeDescription interface {
	isEphemerisTypeDescription()
}

// Description of ephemeris.
type EphemerisTypeDescriptionMemberAzEl struct {
	Value EphemerisDescription

	noSmithyDocumentSerde
}

func (*EphemerisTypeDescriptionMemberAzEl) isEphemerisTypeDescription() {}

// Description of ephemeris.
type EphemerisTypeDescriptionMemberOem struct {
	Value EphemerisDescription

	noSmithyDocumentSerde
}

func (*EphemerisTypeDescriptionMemberOem) isEphemerisTypeDescription() {}

// Description of ephemeris.
type EphemerisTypeDescriptionMemberTle struct {
	Value EphemerisDescription

	noSmithyDocumentSerde
}

func (*EphemerisTypeDescriptionMemberTle) isEphemerisTypeDescription() {}

// Object that describes the frequency.
type Frequency struct {

	// Frequency units.
	//
	// This member is required.
	Units FrequencyUnits

	// Frequency value. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz
	// for downlink and 2025 to 2120 MHz for uplink.
	//
	// This member is required.
	Value *float64

	noSmithyDocumentSerde
}

// Object that describes the frequency bandwidth.
type FrequencyBandwidth struct {

	// Frequency bandwidth units.
	//
	// This member is required.
	Units BandwidthUnits

	// Frequency bandwidth value. AWS Ground Station currently has the following
	// bandwidth limitations:
	//
	//   - For AntennaDownlinkDemodDecodeconfig , valid values are between 125 kHz to
	//   650 MHz.
	//
	//   - For AntennaDownlinkconfig , valid values are between 10 kHz to 54 MHz.
	//
	//   - For AntennaUplinkConfig , valid values are between 10 kHz to 54 MHz.
	//
	// This member is required.
	Value *float64

	noSmithyDocumentSerde
}

// Information about the ground station data.
type GroundStationData struct {

	// UUID of a ground station.
	GroundStationId *string

	// Name of a ground station.
	GroundStationName *string

	// Ground station Region.
	Region *string

	noSmithyDocumentSerde
}

// An integer range that has a minimum and maximum value.
type IntegerRange struct {

	// A maximum value.
	//
	// This member is required.
	Maximum *int32

	// A minimum value.
	//
	// This member is required.
	Minimum *int32

	noSmithyDocumentSerde
}

// Time range specified using ISO 8601 format timestamps.
type ISO8601TimeRange struct {

	// End time in ISO 8601 format in Coordinated Universal Time (UTC).
	//
	// Example: 2024-01-15T12:00:00.000Z
	//
	// This member is required.
	EndTime *time.Time

	// Start time in ISO 8601 format in Coordinated Universal Time (UTC).
	//
	// Example: 2026-11-15T10:28:48.000Z
	//
	// This member is required.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// KMS key info.
//
// The following types satisfy this interface:
//
//	KmsKeyMemberKmsAliasArn
//	KmsKeyMemberKmsAliasName
//	KmsKeyMemberKmsKeyArn
type KmsKey interface {
	isKmsKey()
}

// KMS Alias Arn.
type KmsKeyMemberKmsAliasArn struct {
	Value string

	noSmithyDocumentSerde
}

func (*KmsKeyMemberKmsAliasArn) isKmsKey() {}

// KMS Alias Name.
type KmsKeyMemberKmsAliasName struct {
	Value string

	noSmithyDocumentSerde
}

func (*KmsKeyMemberKmsAliasName) isKmsKey() {}

// KMS Key Arn.
type KmsKeyMemberKmsKeyArn struct {
	Value string

	noSmithyDocumentSerde
}

func (*KmsKeyMemberKmsKeyArn) isKmsKey() {}

// Item in a list of mission profiles.
type MissionProfileListItem struct {

	// ARN of a mission profile.
	MissionProfileArn *string

	// UUID of a mission profile.
	MissionProfileId *string

	// Name of a mission profile.
	Name *string

	// Region of a mission profile.
	Region *string

	noSmithyDocumentSerde
}

// Ephemeris data in Orbit Ephemeris Message (OEM) format.
//
// AWS Ground Station processes OEM ephemerides according to the [CCSDS standard] with some extra
// restrictions. OEM files should be in KVN format. For more detail about the OEM
// format that AWS Ground Station supports, see [OEM ephemeris format]in the AWS Ground Station user
// guide.
//
// [CCSDS standard]: https://ccsds.org/wp-content/uploads/gravity_forms/5-448e85c647331d9cbaf66c096458bdd5/2025/01//502x0b3e1.pdf
// [OEM ephemeris format]: https://docs.aws.amazon.com/ground-station/latest/ug/providing-oem-ephemeris-data.html#oem-ephemeris-format
type OEMEphemeris struct {

	// OEM data that you provide directly instead of using an Amazon S3 object.
	OemData *string

	// The Amazon S3 object that contains the ephemeris data.
	S3Object *S3Object

	noSmithyDocumentSerde
}

// Program track settings for an antenna during a contact.
//
// The following types satisfy this interface:
//
//	ProgramTrackSettingsMemberAzEl
type ProgramTrackSettings interface {
	isProgramTrackSettings()
}

// Program track settings for AzElEphemeris.
type ProgramTrackSettingsMemberAzEl struct {
	Value AzElProgramTrackSettings

	noSmithyDocumentSerde
}

func (*ProgramTrackSettingsMemberAzEl) isProgramTrackSettings() {}

// Ingress address of AgentEndpoint with a port range and an optional mtu.
type RangedConnectionDetails struct {

	// A ranged socket address.
	//
	// This member is required.
	SocketAddress *RangedSocketAddress

	// Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
	Mtu *int32

	noSmithyDocumentSerde
}

// A socket address with a port range.
type RangedSocketAddress struct {

	// IPv4 socket address.
	//
	// This member is required.
	Name *string

	// Port range of a socket address.
	//
	// This member is required.
	PortRange *IntegerRange

	noSmithyDocumentSerde
}

// Object stored in Amazon S3 containing ephemeris data.
type S3Object struct {

	// An Amazon S3 Bucket name.
	Bucket *string

	// An Amazon S3 key for the ephemeris.
	Key *string

	// For versioned Amazon S3 objects, the version to use for the ephemeris.
	Version *string

	noSmithyDocumentSerde
}

// Information about an S3 recording Config .
type S3RecordingConfig struct {

	// ARN of the bucket to record to.
	//
	// This member is required.
	BucketArn *string

	// ARN of the role Ground Station assumes to write data to the bucket.
	//
	// This member is required.
	RoleArn *string

	// S3 Key prefix to prefice data files.
	Prefix *string

	noSmithyDocumentSerde
}

// Details about an S3 recording Config used in a contact.
type S3RecordingDetails struct {

	// ARN of the bucket used.
	BucketArn *string

	// Key template used for the S3 Recording Configuration
	KeyTemplate *string

	noSmithyDocumentSerde
}

// Item in a list of satellites.
type SatelliteListItem struct {

	// The current ephemeris being used to compute the trajectory of the satellite.
	CurrentEphemeris *EphemerisMetaData

	// A list of ground stations to which the satellite is on-boarded.
	GroundStations []string

	// NORAD satellite ID number.
	NoradSatelliteID int32

	// ARN of a satellite.
	SatelliteArn *string

	// UUID of a satellite.
	SatelliteId *string

	noSmithyDocumentSerde
}

// Information about endpoints.
type SecurityDetails struct {

	// ARN to a role needed for connecting streams to your instances.
	//
	// This member is required.
	RoleArn *string

	// The security groups to attach to the elastic network interfaces.
	//
	// This member is required.
	SecurityGroupIds []string

	// A list of subnets where AWS Ground Station places elastic network interfaces to
	// send streams to your instances.
	//
	// This member is required.
	SubnetIds []string

	noSmithyDocumentSerde
}

// Information about the socket address.
type SocketAddress struct {

	// Name of a socket address.
	//
	// This member is required.
	Name *string

	// Port of a socket address.
	//
	// This member is required.
	Port *int32

	noSmithyDocumentSerde
}

// Dataflow details for the source side.
type Source struct {

	// Additional details for a Config , if type is dataflow-endpoint or
	// antenna-downlink-demod-decode
	ConfigDetails ConfigDetails

	// UUID of a Config .
	ConfigId *string

	// Type of a Config .
	ConfigType ConfigCapabilityType

	// Region of a dataflow source.
	DataflowSourceRegion *string

	noSmithyDocumentSerde
}

// Object that describes a spectral Config .
type SpectrumConfig struct {

	// Bandwidth of a spectral Config . AWS Ground Station currently has the following
	// bandwidth limitations:
	//
	//   - For AntennaDownlinkDemodDecodeconfig , valid values are between 125 kHz to
	//   650 MHz.
	//
	//   - For AntennaDownlinkconfig valid values are between 10 kHz to 54 MHz.
	//
	//   - For AntennaUplinkConfig , valid values are between 10 kHz to 54 MHz.
	//
	// This member is required.
	Bandwidth *FrequencyBandwidth

	// Center frequency of a spectral Config . Valid values are between 2200 to 2300
	// MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
	//
	// This member is required.
	CenterFrequency *Frequency

	// Polarization of a spectral Config . Capturing both "RIGHT_HAND" and "LEFT_HAND"
	// polarization requires two separate configs.
	Polarization Polarization

	noSmithyDocumentSerde
}

// Time-tagged azimuth elevation pointing data.
//
// Specifies the antenna pointing direction at a specific time offset from the
// segment's reference epoch.
type TimeAzEl struct {

	// Azimuth angle at the specified time.
	//
	// Valid ranges by unit:
	//
	//   - DEGREE_ANGLE : -180 to 360 degrees, measured clockwise from true north
	//
	//   - RADIAN : -π to 2π radians, measured clockwise from true north
	//
	// This member is required.
	Az *float64

	// Time offset in atomic seconds from the segment's reference epoch.
	//
	// All dt values within a segment must be in ascending order with no duplicates.
	//
	// dt values may be:
	//
	//   - negative
	//
	//   - expressed as fractions of a second
	//
	//   - expressed in scientific notation
	//
	// This member is required.
	Dt *float64

	// Elevation angle at the specified time.
	//
	// Valid ranges by unit:
	//
	//   - DEGREE_ANGLE : -90 to 90 degrees, where 0 is the horizon, 90 is zenith, and
	//   negative values are below the horizon
	//
	//   - RADIAN : -π/2 to π/2 radians, where 0 is the horizon, π/2 is zenith, and
	//   negative values are below the horizon
	//
	// This member is required.
	El *float64

	noSmithyDocumentSerde
}

// A time range with a start and end time.
type TimeRange struct {

	// Unix epoch timestamp in UTC at which the time range ends.
	//
	// This member is required.
	EndTime *time.Time

	// Unix epoch timestamp in UTC at which the time range starts.
	//
	// This member is required.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Two-line element set (TLE) data.
type TLEData struct {

	// First line of two-line element set (TLE) data.
	//
	// This member is required.
	TleLine1 *string

	// Second line of two-line element set (TLE) data.
	//
	// This member is required.
	TleLine2 *string

	// The valid time range for the TLE. Time ranges must be continuous without gaps
	// or overlaps.
	//
	// This member is required.
	ValidTimeRange *TimeRange

	noSmithyDocumentSerde
}

// Two-line element set (TLE) ephemeris.
//
// For more detail about providing Two-line element sets to AWS Ground Station,
// see the [TLE section]of the AWS Ground Station user guide.
//
// [TLE section]: https://docs.aws.amazon.com/ground-station/latest/ug/providing-tle-ephemeris-data.html
type TLEEphemeris struct {

	// The Amazon S3 object that contains the ephemeris data.
	S3Object *S3Object

	// TLE data that you provide directly instead of using an Amazon S3 object.
	TleData []TLEData

	noSmithyDocumentSerde
}

// Object that determines whether tracking should be used during a contact
// executed with this Config in the mission profile.
type TrackingConfig struct {

	// Current setting for autotrack.
	//
	// This member is required.
	Autotrack Criticality

	noSmithyDocumentSerde
}

// Overrides the default tracking configuration on an antenna during a contact.
type TrackingOverrides struct {

	// Program track settings to override for antenna tracking during the contact.
	//
	// This member is required.
	ProgramTrackSettings ProgramTrackSettings

	noSmithyDocumentSerde
}

// Definition for an uplink agent endpoint
type UplinkAwsGroundStationAgentEndpoint struct {

	// Dataflow details for the uplink endpoint
	//
	// This member is required.
	DataflowDetails UplinkDataflowDetails

	// Uplink dataflow endpoint name
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Details for an uplink agent endpoint
type UplinkAwsGroundStationAgentEndpointDetails struct {

	// Dataflow details for the uplink endpoint
	//
	// This member is required.
	DataflowDetails UplinkDataflowDetails

	// Uplink dataflow endpoint name
	//
	// This member is required.
	Name *string

	// Status of the agent associated with the uplink dataflow endpoint
	AgentStatus AgentStatus

	// Health audit results for the uplink dataflow endpoint
	AuditResults AuditResults

	noSmithyDocumentSerde
}

// Connection details for customer to Agent and Agent to Ground Station
type UplinkConnectionDetails struct {

	// Ingress address of AgentEndpoint with a port range and an optional mtu.
	//
	// This member is required.
	AgentIpAndPortAddress *RangedConnectionDetails

	// Egress address of AgentEndpoint with an optional mtu.
	//
	// This member is required.
	IngressAddressAndPort *ConnectionDetails

	noSmithyDocumentSerde
}

// Dataflow details for an uplink endpoint
//
// The following types satisfy this interface:
//
//	UplinkDataflowDetailsMemberAgentConnectionDetails
type UplinkDataflowDetails interface {
	isUplinkDataflowDetails()
}

// Uplink connection details for customer to Agent and Agent to Ground Station
type UplinkDataflowDetailsMemberAgentConnectionDetails struct {
	Value UplinkConnectionDetails

	noSmithyDocumentSerde
}

func (*UplinkDataflowDetailsMemberAgentConnectionDetails) isUplinkDataflowDetails() {}

// Information about an uplink echo Config .
//
// Parameters from the AntennaUplinkConfig , corresponding to the specified
// AntennaUplinkConfigArn , are used when this UplinkEchoConfig is used in a
// contact.
type UplinkEchoConfig struct {

	// ARN of an uplink Config .
	//
	// This member is required.
	AntennaUplinkConfigArn *string

	// Whether or not an uplink Config is enabled.
	//
	// This member is required.
	Enabled *bool

	noSmithyDocumentSerde
}

// Information about the uplink spectral Config .
type UplinkSpectrumConfig struct {

	// Center frequency of an uplink spectral Config . Valid values are between 2025 to
	// 2120 MHz.
	//
	// This member is required.
	CenterFrequency *Frequency

	// Polarization of an uplink spectral Config . Capturing both "RIGHT_HAND" and
	// "LEFT_HAND" polarization requires two separate configs.
	Polarization Polarization

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAzElSegmentsData()         {}
func (*UnknownUnionMember) isConfigDetails()            {}
func (*UnknownUnionMember) isConfigTypeData()           {}
func (*UnknownUnionMember) isCreateEndpointDetails()    {}
func (*UnknownUnionMember) isDownlinkDataflowDetails()  {}
func (*UnknownUnionMember) isEphemerisData()            {}
func (*UnknownUnionMember) isEphemerisFilter()          {}
func (*UnknownUnionMember) isEphemerisTypeDescription() {}
func (*UnknownUnionMember) isKmsKey()                   {}
func (*UnknownUnionMember) isProgramTrackSettings()     {}
func (*UnknownUnionMember) isUplinkDataflowDetails()    {}
