// Code generated by smithy-go-codegen DO NOT EDIT.

package guardduty

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/guardduty/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the threat entity set associated with the specified threatEntitySetId .
func (c *Client) GetThreatEntitySet(ctx context.Context, params *GetThreatEntitySetInput, optFns ...func(*Options)) (*GetThreatEntitySetOutput, error) {
	if params == nil {
		params = &GetThreatEntitySetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetThreatEntitySet", params, optFns, c.addOperationGetThreatEntitySetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetThreatEntitySetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetThreatEntitySetInput struct {

	// The unique ID of the detector associated with the threat entity set resource.
	//
	// To find the detectorId in the current Region, see the Settings page in the
	// GuardDuty console, or run the [ListDetectors]API.
	//
	// [ListDetectors]: https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html
	//
	// This member is required.
	DetectorId *string

	// The unique ID that helps GuardDuty identify the threat entity set.
	//
	// This member is required.
	ThreatEntitySetId *string

	noSmithyDocumentSerde
}

type GetThreatEntitySetOutput struct {

	// The format of the file that contains the threat entity set.
	//
	// This member is required.
	Format types.ThreatEntitySetFormat

	// The URI of the file that contains the threat entity set.
	//
	// This member is required.
	Location *string

	// The name of the threat entity set associated with the specified
	// threatEntitySetId .
	//
	// This member is required.
	Name *string

	// The status of the associated threat entity set.
	//
	// This member is required.
	Status types.ThreatEntitySetStatus

	// The timestamp when the associated threat entity set was created.
	CreatedAt *time.Time

	// The error details when the status is shown as ERROR .
	ErrorDetails *string

	// The Amazon Web Services account ID that owns the Amazon S3 bucket specified in
	// the location parameter.
	ExpectedBucketOwner *string

	// The tags associated with the threat entity set resource.
	Tags map[string]string

	// The timestamp when the associated threat entity set was updated.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetThreatEntitySetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetThreatEntitySet{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetThreatEntitySet{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetThreatEntitySet"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetThreatEntitySetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetThreatEntitySet(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetThreatEntitySet(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetThreatEntitySet",
	}
}
