// Code generated by smithy-go-codegen DO NOT EDIT.

package guardduty

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/guardduty/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of malware scans. Each member account can view the malware scans
// for their own accounts. An administrator can view the malware scans for all of
// its members' accounts.
func (c *Client) ListMalwareScans(ctx context.Context, params *ListMalwareScansInput, optFns ...func(*Options)) (*ListMalwareScansOutput, error) {
	if params == nil {
		params = &ListMalwareScansInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMalwareScans", params, optFns, c.addOperationListMalwareScansMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMalwareScansOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListMalwareScansInput struct {

	// Represents the criteria used to filter the malware scan entries.
	FilterCriteria *types.ListMalwareScansFilterCriteria

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response. The default value is 50. The maximum value is 50.
	MaxResults *int32

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the list action. For subsequent calls to
	// the action, fill nextToken in the request with the value of NextToken from the
	// previous response to continue listing results.
	NextToken *string

	// Represents the criteria used for sorting malware scan entries.
	SortCriteria *types.SortCriteria

	noSmithyDocumentSerde
}

type ListMalwareScansOutput struct {

	// The list of malware scans associated with the provided input parameters.
	//
	// This member is required.
	Scans []types.MalwareScan

	// The pagination parameter to be used on the next list operation to retrieve more
	// scans.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMalwareScansMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListMalwareScans{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListMalwareScans{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListMalwareScans"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMalwareScans(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListMalwareScansPaginatorOptions is the paginator options for ListMalwareScans
type ListMalwareScansPaginatorOptions struct {
	// You can use this parameter to indicate the maximum number of items that you
	// want in the response. The default value is 50. The maximum value is 50.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMalwareScansPaginator is a paginator for ListMalwareScans
type ListMalwareScansPaginator struct {
	options   ListMalwareScansPaginatorOptions
	client    ListMalwareScansAPIClient
	params    *ListMalwareScansInput
	nextToken *string
	firstPage bool
}

// NewListMalwareScansPaginator returns a new ListMalwareScansPaginator
func NewListMalwareScansPaginator(client ListMalwareScansAPIClient, params *ListMalwareScansInput, optFns ...func(*ListMalwareScansPaginatorOptions)) *ListMalwareScansPaginator {
	if params == nil {
		params = &ListMalwareScansInput{}
	}

	options := ListMalwareScansPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMalwareScansPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMalwareScansPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMalwareScans page.
func (p *ListMalwareScansPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMalwareScansOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListMalwareScans(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListMalwareScansAPIClient is a client that implements the ListMalwareScans
// operation.
type ListMalwareScansAPIClient interface {
	ListMalwareScans(context.Context, *ListMalwareScansInput, ...func(*Options)) (*ListMalwareScansOutput, error)
}

var _ ListMalwareScansAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListMalwareScans(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListMalwareScans",
	}
}
