// Code generated by smithy-go-codegen DO NOT EDIT.

package imagebuilder

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/imagebuilder/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an image pipeline. Image pipelines enable you to automate the creation
// and distribution of images. You must specify exactly one recipe for your image,
// using either a containerRecipeArn or an imageRecipeArn .
//
// UpdateImagePipeline does not support selective updates for the pipeline. You
// must specify all of the required properties in the update request, not just the
// properties that have changed.
func (c *Client) UpdateImagePipeline(ctx context.Context, params *UpdateImagePipelineInput, optFns ...func(*Options)) (*UpdateImagePipelineOutput, error) {
	if params == nil {
		params = &UpdateImagePipelineInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateImagePipeline", params, optFns, c.addOperationUpdateImagePipelineMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateImagePipelineOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateImagePipelineInput struct {

	// Unique, case-sensitive identifier you provide to ensure idempotency of the
	// request. For more information, see [Ensuring idempotency]in the Amazon EC2 API Reference.
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	//
	// This member is required.
	ClientToken *string

	// The Amazon Resource Name (ARN) of the image pipeline that you want to update.
	//
	// This member is required.
	ImagePipelineArn *string

	// The Amazon Resource Name (ARN) of the infrastructure configuration that Image
	// Builder uses to build images that this image pipeline has updated.
	//
	// This member is required.
	InfrastructureConfigurationArn *string

	// The Amazon Resource Name (ARN) of the container pipeline to update.
	ContainerRecipeArn *string

	// The description of the image pipeline.
	Description *string

	// The Amazon Resource Name (ARN) of the distribution configuration that Image
	// Builder uses to configure and distribute images that this image pipeline has
	// updated.
	DistributionConfigurationArn *string

	// Collects additional information about the image being created, including the
	// operating system (OS) version and package list. This information is used to
	// enhance the overall experience of using EC2 Image Builder. Enabled by default.
	EnhancedImageMetadataEnabled *bool

	// The name or Amazon Resource Name (ARN) for the IAM role you create that grants
	// Image Builder access to perform workflow actions.
	ExecutionRole *string

	// The Amazon Resource Name (ARN) of the image recipe that will be used to
	// configure images updated by this image pipeline.
	ImageRecipeArn *string

	// Contains settings for vulnerability scans.
	ImageScanningConfiguration *types.ImageScanningConfiguration

	// The image test configuration of the image pipeline.
	ImageTestsConfiguration *types.ImageTestsConfiguration

	// Update logging configuration for the output image that's created when the
	// pipeline runs.
	LoggingConfiguration *types.PipelineLoggingConfiguration

	// The schedule of the image pipeline.
	Schedule *types.Schedule

	// The status of the image pipeline.
	Status types.PipelineStatus

	// Contains the workflows to run for the pipeline.
	Workflows []types.WorkflowConfiguration

	noSmithyDocumentSerde
}

type UpdateImagePipelineOutput struct {

	// The client token that uniquely identifies the request.
	ClientToken *string

	// The Amazon Resource Name (ARN) of the image pipeline that was updated by this
	// request.
	ImagePipelineArn *string

	// The request ID that uniquely identifies this request.
	RequestId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateImagePipelineMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateImagePipeline{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateImagePipeline{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateImagePipeline"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opUpdateImagePipelineMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateImagePipelineValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateImagePipeline(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpUpdateImagePipeline struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpUpdateImagePipeline) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpUpdateImagePipeline) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*UpdateImagePipelineInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *UpdateImagePipelineInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opUpdateImagePipelineMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpUpdateImagePipeline{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opUpdateImagePipeline(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateImagePipeline",
	}
}
