// Code generated by smithy-go-codegen DO NOT EDIT.

package invoicing

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/invoicing/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of procurement portal preferences associated with the Amazon
// Web Services account.
func (c *Client) ListProcurementPortalPreferences(ctx context.Context, params *ListProcurementPortalPreferencesInput, optFns ...func(*Options)) (*ListProcurementPortalPreferencesOutput, error) {
	if params == nil {
		params = &ListProcurementPortalPreferencesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListProcurementPortalPreferences", params, optFns, c.addOperationListProcurementPortalPreferencesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListProcurementPortalPreferencesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListProcurementPortalPreferencesInput struct {

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	MaxResults *int32

	// The token for the next set of results. (You received this token from a previous
	// call.)
	NextToken *string

	noSmithyDocumentSerde
}

type ListProcurementPortalPreferencesOutput struct {

	// The token to use to retrieve the next set of results, or null if there are no
	// more results.
	NextToken *string

	// The list of procurement portal preferences associated with the Amazon Web
	// Services account.
	ProcurementPortalPreferences []types.ProcurementPortalPreferenceSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListProcurementPortalPreferencesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListProcurementPortalPreferences{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListProcurementPortalPreferences{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListProcurementPortalPreferences"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListProcurementPortalPreferences(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListProcurementPortalPreferencesPaginatorOptions is the paginator options for
// ListProcurementPortalPreferences
type ListProcurementPortalPreferencesPaginatorOptions struct {
	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListProcurementPortalPreferencesPaginator is a paginator for
// ListProcurementPortalPreferences
type ListProcurementPortalPreferencesPaginator struct {
	options   ListProcurementPortalPreferencesPaginatorOptions
	client    ListProcurementPortalPreferencesAPIClient
	params    *ListProcurementPortalPreferencesInput
	nextToken *string
	firstPage bool
}

// NewListProcurementPortalPreferencesPaginator returns a new
// ListProcurementPortalPreferencesPaginator
func NewListProcurementPortalPreferencesPaginator(client ListProcurementPortalPreferencesAPIClient, params *ListProcurementPortalPreferencesInput, optFns ...func(*ListProcurementPortalPreferencesPaginatorOptions)) *ListProcurementPortalPreferencesPaginator {
	if params == nil {
		params = &ListProcurementPortalPreferencesInput{}
	}

	options := ListProcurementPortalPreferencesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListProcurementPortalPreferencesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListProcurementPortalPreferencesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListProcurementPortalPreferences page.
func (p *ListProcurementPortalPreferencesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListProcurementPortalPreferencesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListProcurementPortalPreferences(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListProcurementPortalPreferencesAPIClient is a client that implements the
// ListProcurementPortalPreferences operation.
type ListProcurementPortalPreferencesAPIClient interface {
	ListProcurementPortalPreferences(context.Context, *ListProcurementPortalPreferencesInput, ...func(*Options)) (*ListProcurementPortalPreferencesOutput, error)
}

var _ ListProcurementPortalPreferencesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListProcurementPortalPreferences(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListProcurementPortalPreferences",
	}
}
