// Code generated by smithy-go-codegen DO NOT EDIT.

package invoicing

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/invoicing/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpBatchGetInvoiceProfile struct {
}

func (*validateOpBatchGetInvoiceProfile) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchGetInvoiceProfile) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchGetInvoiceProfileInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchGetInvoiceProfileInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateInvoiceUnit struct {
}

func (*validateOpCreateInvoiceUnit) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateInvoiceUnit) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateInvoiceUnitInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateInvoiceUnitInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateProcurementPortalPreference struct {
}

func (*validateOpCreateProcurementPortalPreference) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateProcurementPortalPreference) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateProcurementPortalPreferenceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateProcurementPortalPreferenceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteInvoiceUnit struct {
}

func (*validateOpDeleteInvoiceUnit) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteInvoiceUnit) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteInvoiceUnitInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteInvoiceUnitInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteProcurementPortalPreference struct {
}

func (*validateOpDeleteProcurementPortalPreference) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteProcurementPortalPreference) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteProcurementPortalPreferenceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteProcurementPortalPreferenceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetInvoicePDF struct {
}

func (*validateOpGetInvoicePDF) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetInvoicePDF) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetInvoicePDFInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetInvoicePDFInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetInvoiceUnit struct {
}

func (*validateOpGetInvoiceUnit) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetInvoiceUnit) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetInvoiceUnitInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetInvoiceUnitInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetProcurementPortalPreference struct {
}

func (*validateOpGetProcurementPortalPreference) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetProcurementPortalPreference) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetProcurementPortalPreferenceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetProcurementPortalPreferenceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListInvoiceSummaries struct {
}

func (*validateOpListInvoiceSummaries) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListInvoiceSummaries) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListInvoiceSummariesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListInvoiceSummariesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutProcurementPortalPreference struct {
}

func (*validateOpPutProcurementPortalPreference) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutProcurementPortalPreference) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutProcurementPortalPreferenceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutProcurementPortalPreferenceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateInvoiceUnit struct {
}

func (*validateOpUpdateInvoiceUnit) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateInvoiceUnit) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateInvoiceUnitInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateInvoiceUnitInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateProcurementPortalPreferenceStatus struct {
}

func (*validateOpUpdateProcurementPortalPreferenceStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateProcurementPortalPreferenceStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateProcurementPortalPreferenceStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateProcurementPortalPreferenceStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpBatchGetInvoiceProfileValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchGetInvoiceProfile{}, middleware.After)
}

func addOpCreateInvoiceUnitValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateInvoiceUnit{}, middleware.After)
}

func addOpCreateProcurementPortalPreferenceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateProcurementPortalPreference{}, middleware.After)
}

func addOpDeleteInvoiceUnitValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteInvoiceUnit{}, middleware.After)
}

func addOpDeleteProcurementPortalPreferenceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteProcurementPortalPreference{}, middleware.After)
}

func addOpGetInvoicePDFValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetInvoicePDF{}, middleware.After)
}

func addOpGetInvoiceUnitValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetInvoiceUnit{}, middleware.After)
}

func addOpGetProcurementPortalPreferenceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetProcurementPortalPreference{}, middleware.After)
}

func addOpListInvoiceSummariesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListInvoiceSummaries{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpPutProcurementPortalPreferenceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutProcurementPortalPreference{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateInvoiceUnitValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateInvoiceUnit{}, middleware.After)
}

func addOpUpdateProcurementPortalPreferenceStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateProcurementPortalPreferenceStatus{}, middleware.After)
}

func validateBillingPeriod(v *types.BillingPeriod) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BillingPeriod"}
	if v.Month == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Month"))
	}
	if v.Year == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Year"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDateInterval(v *types.DateInterval) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DateInterval"}
	if v.StartDate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartDate"))
	}
	if v.EndDate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndDate"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEinvoiceDeliveryPreference(v *types.EinvoiceDeliveryPreference) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EinvoiceDeliveryPreference"}
	if v.EinvoiceDeliveryDocumentTypes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EinvoiceDeliveryDocumentTypes"))
	}
	if len(v.Protocol) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Protocol"))
	}
	if v.PurchaseOrderDataSources == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PurchaseOrderDataSources"))
	}
	if len(v.ConnectionTestingMethod) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectionTestingMethod"))
	}
	if v.EinvoiceDeliveryActivationDate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EinvoiceDeliveryActivationDate"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInvoiceSummariesFilter(v *types.InvoiceSummariesFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InvoiceSummariesFilter"}
	if v.TimeInterval != nil {
		if err := validateDateInterval(v.TimeInterval); err != nil {
			invalidParams.AddNested("TimeInterval", err.(smithy.InvalidParamsError))
		}
	}
	if v.BillingPeriod != nil {
		if err := validateBillingPeriod(v.BillingPeriod); err != nil {
			invalidParams.AddNested("BillingPeriod", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInvoiceSummariesSelector(v *types.InvoiceSummariesSelector) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InvoiceSummariesSelector"}
	if len(v.ResourceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceType"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceTag(v *types.ResourceTag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceTag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceTagList(v []types.ResourceTag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceTagList"}
	for i := range v {
		if err := validateResourceTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTestEnvPreferenceInput(v *types.TestEnvPreferenceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TestEnvPreferenceInput"}
	if len(v.BuyerDomain) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("BuyerDomain"))
	}
	if v.BuyerIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BuyerIdentifier"))
	}
	if len(v.SupplierDomain) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SupplierDomain"))
	}
	if v.SupplierIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SupplierIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchGetInvoiceProfileInput(v *BatchGetInvoiceProfileInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchGetInvoiceProfileInput"}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateInvoiceUnitInput(v *CreateInvoiceUnitInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateInvoiceUnitInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.InvoiceReceiver == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InvoiceReceiver"))
	}
	if v.Rule == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Rule"))
	}
	if v.ResourceTags != nil {
		if err := validateResourceTagList(v.ResourceTags); err != nil {
			invalidParams.AddNested("ResourceTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateProcurementPortalPreferenceInput(v *CreateProcurementPortalPreferenceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateProcurementPortalPreferenceInput"}
	if len(v.ProcurementPortalName) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ProcurementPortalName"))
	}
	if len(v.BuyerDomain) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("BuyerDomain"))
	}
	if v.BuyerIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BuyerIdentifier"))
	}
	if len(v.SupplierDomain) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SupplierDomain"))
	}
	if v.SupplierIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SupplierIdentifier"))
	}
	if v.TestEnvPreference != nil {
		if err := validateTestEnvPreferenceInput(v.TestEnvPreference); err != nil {
			invalidParams.AddNested("TestEnvPreference", err.(smithy.InvalidParamsError))
		}
	}
	if v.EinvoiceDeliveryEnabled == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EinvoiceDeliveryEnabled"))
	}
	if v.EinvoiceDeliveryPreference != nil {
		if err := validateEinvoiceDeliveryPreference(v.EinvoiceDeliveryPreference); err != nil {
			invalidParams.AddNested("EinvoiceDeliveryPreference", err.(smithy.InvalidParamsError))
		}
	}
	if v.PurchaseOrderRetrievalEnabled == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PurchaseOrderRetrievalEnabled"))
	}
	if v.Contacts == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Contacts"))
	}
	if v.ResourceTags != nil {
		if err := validateResourceTagList(v.ResourceTags); err != nil {
			invalidParams.AddNested("ResourceTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteInvoiceUnitInput(v *DeleteInvoiceUnitInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteInvoiceUnitInput"}
	if v.InvoiceUnitArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InvoiceUnitArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteProcurementPortalPreferenceInput(v *DeleteProcurementPortalPreferenceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteProcurementPortalPreferenceInput"}
	if v.ProcurementPortalPreferenceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProcurementPortalPreferenceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetInvoicePDFInput(v *GetInvoicePDFInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetInvoicePDFInput"}
	if v.InvoiceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InvoiceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetInvoiceUnitInput(v *GetInvoiceUnitInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetInvoiceUnitInput"}
	if v.InvoiceUnitArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InvoiceUnitArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetProcurementPortalPreferenceInput(v *GetProcurementPortalPreferenceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetProcurementPortalPreferenceInput"}
	if v.ProcurementPortalPreferenceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProcurementPortalPreferenceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListInvoiceSummariesInput(v *ListInvoiceSummariesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListInvoiceSummariesInput"}
	if v.Selector == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Selector"))
	} else if v.Selector != nil {
		if err := validateInvoiceSummariesSelector(v.Selector); err != nil {
			invalidParams.AddNested("Selector", err.(smithy.InvalidParamsError))
		}
	}
	if v.Filter != nil {
		if err := validateInvoiceSummariesFilter(v.Filter); err != nil {
			invalidParams.AddNested("Filter", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutProcurementPortalPreferenceInput(v *PutProcurementPortalPreferenceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutProcurementPortalPreferenceInput"}
	if v.ProcurementPortalPreferenceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProcurementPortalPreferenceArn"))
	}
	if v.TestEnvPreference != nil {
		if err := validateTestEnvPreferenceInput(v.TestEnvPreference); err != nil {
			invalidParams.AddNested("TestEnvPreference", err.(smithy.InvalidParamsError))
		}
	}
	if v.EinvoiceDeliveryEnabled == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EinvoiceDeliveryEnabled"))
	}
	if v.EinvoiceDeliveryPreference != nil {
		if err := validateEinvoiceDeliveryPreference(v.EinvoiceDeliveryPreference); err != nil {
			invalidParams.AddNested("EinvoiceDeliveryPreference", err.(smithy.InvalidParamsError))
		}
	}
	if v.PurchaseOrderRetrievalEnabled == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PurchaseOrderRetrievalEnabled"))
	}
	if v.Contacts == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Contacts"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.ResourceTags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceTags"))
	} else if v.ResourceTags != nil {
		if err := validateResourceTagList(v.ResourceTags); err != nil {
			invalidParams.AddNested("ResourceTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.ResourceTagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceTagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateInvoiceUnitInput(v *UpdateInvoiceUnitInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateInvoiceUnitInput"}
	if v.InvoiceUnitArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InvoiceUnitArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateProcurementPortalPreferenceStatusInput(v *UpdateProcurementPortalPreferenceStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateProcurementPortalPreferenceStatusInput"}
	if v.ProcurementPortalPreferenceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProcurementPortalPreferenceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
