// Code generated by smithy-go-codegen DO NOT EDIT.

package iotmanagedintegrations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of connectors filtered by its Lambda Amazon Resource Name (ARN)
// and type .
func (c *Client) ListCloudConnectors(ctx context.Context, params *ListCloudConnectorsInput, optFns ...func(*Options)) (*ListCloudConnectorsOutput, error) {
	if params == nil {
		params = &ListCloudConnectorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCloudConnectors", params, optFns, c.addOperationListCloudConnectorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCloudConnectorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCloudConnectorsInput struct {

	// The Amazon Resource Name (ARN) of the Lambda function to filter cloud
	// connectors by.
	LambdaArn *string

	// The maximum number of results to return at one time.
	MaxResults *int32

	// A token that can be used to retrieve the next set of results.
	NextToken *string

	// The type of cloud connectors to filter by when listing available connectors.
	Type types.CloudConnectorType

	noSmithyDocumentSerde
}

type ListCloudConnectorsOutput struct {

	// The list of connectors.
	Items []types.ConnectorItem

	// A token that can be used to retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCloudConnectorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCloudConnectors{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCloudConnectors{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCloudConnectors"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCloudConnectors(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCloudConnectorsPaginatorOptions is the paginator options for
// ListCloudConnectors
type ListCloudConnectorsPaginatorOptions struct {
	// The maximum number of results to return at one time.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCloudConnectorsPaginator is a paginator for ListCloudConnectors
type ListCloudConnectorsPaginator struct {
	options   ListCloudConnectorsPaginatorOptions
	client    ListCloudConnectorsAPIClient
	params    *ListCloudConnectorsInput
	nextToken *string
	firstPage bool
}

// NewListCloudConnectorsPaginator returns a new ListCloudConnectorsPaginator
func NewListCloudConnectorsPaginator(client ListCloudConnectorsAPIClient, params *ListCloudConnectorsInput, optFns ...func(*ListCloudConnectorsPaginatorOptions)) *ListCloudConnectorsPaginator {
	if params == nil {
		params = &ListCloudConnectorsInput{}
	}

	options := ListCloudConnectorsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCloudConnectorsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCloudConnectorsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCloudConnectors page.
func (p *ListCloudConnectorsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCloudConnectorsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCloudConnectors(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCloudConnectorsAPIClient is a client that implements the
// ListCloudConnectors operation.
type ListCloudConnectorsAPIClient interface {
	ListCloudConnectors(context.Context, *ListCloudConnectorsInput, ...func(*Options)) (*ListCloudConnectorsOutput, error)
}

var _ ListCloudConnectorsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCloudConnectors(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCloudConnectors",
	}
}
