// Code generated by smithy-go-codegen DO NOT EDIT.

package iotmanagedintegrations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all device discovery tasks, with optional filtering by type and status.
func (c *Client) ListDeviceDiscoveries(ctx context.Context, params *ListDeviceDiscoveriesInput, optFns ...func(*Options)) (*ListDeviceDiscoveriesOutput, error) {
	if params == nil {
		params = &ListDeviceDiscoveriesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDeviceDiscoveries", params, optFns, c.addOperationListDeviceDiscoveriesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDeviceDiscoveriesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDeviceDiscoveriesInput struct {

	// The maximum number of device discovery jobs to return in a single response.
	MaxResults *int32

	// A token used for pagination of results.
	NextToken *string

	// The status to filter device discovery jobs by.
	StatusFilter types.DeviceDiscoveryStatus

	// The discovery type to filter device discovery jobs by.
	TypeFilter types.DiscoveryType

	noSmithyDocumentSerde
}

type ListDeviceDiscoveriesOutput struct {

	// The list of device discovery jobs that match the specified criteria.
	Items []types.DeviceDiscoverySummary

	// A token used for pagination of results when there are more device discovery
	// jobs than can be returned in a single response.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDeviceDiscoveriesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDeviceDiscoveries{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDeviceDiscoveries{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDeviceDiscoveries"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDeviceDiscoveries(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDeviceDiscoveriesPaginatorOptions is the paginator options for
// ListDeviceDiscoveries
type ListDeviceDiscoveriesPaginatorOptions struct {
	// The maximum number of device discovery jobs to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDeviceDiscoveriesPaginator is a paginator for ListDeviceDiscoveries
type ListDeviceDiscoveriesPaginator struct {
	options   ListDeviceDiscoveriesPaginatorOptions
	client    ListDeviceDiscoveriesAPIClient
	params    *ListDeviceDiscoveriesInput
	nextToken *string
	firstPage bool
}

// NewListDeviceDiscoveriesPaginator returns a new ListDeviceDiscoveriesPaginator
func NewListDeviceDiscoveriesPaginator(client ListDeviceDiscoveriesAPIClient, params *ListDeviceDiscoveriesInput, optFns ...func(*ListDeviceDiscoveriesPaginatorOptions)) *ListDeviceDiscoveriesPaginator {
	if params == nil {
		params = &ListDeviceDiscoveriesInput{}
	}

	options := ListDeviceDiscoveriesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDeviceDiscoveriesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDeviceDiscoveriesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDeviceDiscoveries page.
func (p *ListDeviceDiscoveriesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDeviceDiscoveriesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDeviceDiscoveries(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDeviceDiscoveriesAPIClient is a client that implements the
// ListDeviceDiscoveries operation.
type ListDeviceDiscoveriesAPIClient interface {
	ListDeviceDiscoveries(context.Context, *ListDeviceDiscoveriesInput, ...func(*Options)) (*ListDeviceDiscoveriesOutput, error)
}

var _ ListDeviceDiscoveriesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDeviceDiscoveries(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDeviceDiscoveries",
	}
}
