// Code generated by smithy-go-codegen DO NOT EDIT.

package iotmanagedintegrations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all devices discovered during a specific device discovery task.
func (c *Client) ListDiscoveredDevices(ctx context.Context, params *ListDiscoveredDevicesInput, optFns ...func(*Options)) (*ListDiscoveredDevicesOutput, error) {
	if params == nil {
		params = &ListDiscoveredDevicesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDiscoveredDevices", params, optFns, c.addOperationListDiscoveredDevicesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDiscoveredDevicesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDiscoveredDevicesInput struct {

	// The identifier of the device discovery job to list discovered devices for.
	//
	// This member is required.
	Identifier *string

	// The maximum number of discovered devices to return in a single response.
	MaxResults *int32

	// A token used for pagination of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListDiscoveredDevicesOutput struct {

	// The list of discovered devices that match the specified criteria.
	Items []types.DiscoveredDeviceSummary

	// A token used for pagination of results when there are more discovered devices
	// than can be returned in a single response.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDiscoveredDevicesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDiscoveredDevices{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDiscoveredDevices{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDiscoveredDevices"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDiscoveredDevicesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDiscoveredDevices(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDiscoveredDevicesPaginatorOptions is the paginator options for
// ListDiscoveredDevices
type ListDiscoveredDevicesPaginatorOptions struct {
	// The maximum number of discovered devices to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDiscoveredDevicesPaginator is a paginator for ListDiscoveredDevices
type ListDiscoveredDevicesPaginator struct {
	options   ListDiscoveredDevicesPaginatorOptions
	client    ListDiscoveredDevicesAPIClient
	params    *ListDiscoveredDevicesInput
	nextToken *string
	firstPage bool
}

// NewListDiscoveredDevicesPaginator returns a new ListDiscoveredDevicesPaginator
func NewListDiscoveredDevicesPaginator(client ListDiscoveredDevicesAPIClient, params *ListDiscoveredDevicesInput, optFns ...func(*ListDiscoveredDevicesPaginatorOptions)) *ListDiscoveredDevicesPaginator {
	if params == nil {
		params = &ListDiscoveredDevicesInput{}
	}

	options := ListDiscoveredDevicesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDiscoveredDevicesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDiscoveredDevicesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDiscoveredDevices page.
func (p *ListDiscoveredDevicesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDiscoveredDevicesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDiscoveredDevices(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDiscoveredDevicesAPIClient is a client that implements the
// ListDiscoveredDevices operation.
type ListDiscoveredDevicesAPIClient interface {
	ListDiscoveredDevices(context.Context, *ListDiscoveredDevicesInput, ...func(*Options)) (*ListDiscoveredDevicesOutput, error)
}

var _ ListDiscoveredDevicesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDiscoveredDevices(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDiscoveredDevices",
	}
}
