// Code generated by smithy-go-codegen DO NOT EDIT.

package iotmanagedintegrations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Listing all managed things with provision for filters.
func (c *Client) ListManagedThings(ctx context.Context, params *ListManagedThingsInput, optFns ...func(*Options)) (*ListManagedThingsOutput, error) {
	if params == nil {
		params = &ListManagedThingsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListManagedThings", params, optFns, c.addOperationListManagedThingsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListManagedThingsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListManagedThingsInput struct {

	// Filter managed things by the connector destination ID they are associated with.
	ConnectorDestinationIdFilter *string

	// Filter managed things by the connector device ID they are associated with. When
	// specified, only managed things with this connector device ID will be returned.
	ConnectorDeviceIdFilter *string

	// Filter on a connector policy id for a managed thing.
	//
	// Deprecated: ConnectorPolicyIdFilter is deprecated
	ConnectorPolicyIdFilter *string

	// Filter on a credential locker for a managed thing.
	CredentialLockerFilter *string

	// The maximum number of results to return at one time.
	MaxResults *int32

	// A token that can be used to retrieve the next set of results.
	NextToken *string

	// Filter on device owners when listing managed things.
	OwnerFilter *string

	// Filter on a parent controller id for a managed thing.
	ParentControllerIdentifierFilter *string

	// Filter on the status of the device.
	ProvisioningStatusFilter types.ProvisioningStatus

	// Filter on the type of device used. This will be the Amazon Web Services hub
	// controller, cloud device, or IoT device.
	RoleFilter types.Role

	// Filter on the serial number of the device.
	SerialNumberFilter *string

	noSmithyDocumentSerde
}

type ListManagedThingsOutput struct {

	// The list of managed things.
	Items []types.ManagedThingSummary

	// A token that can be used to retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListManagedThingsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListManagedThings{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListManagedThings{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListManagedThings"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListManagedThings(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListManagedThingsPaginatorOptions is the paginator options for ListManagedThings
type ListManagedThingsPaginatorOptions struct {
	// The maximum number of results to return at one time.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListManagedThingsPaginator is a paginator for ListManagedThings
type ListManagedThingsPaginator struct {
	options   ListManagedThingsPaginatorOptions
	client    ListManagedThingsAPIClient
	params    *ListManagedThingsInput
	nextToken *string
	firstPage bool
}

// NewListManagedThingsPaginator returns a new ListManagedThingsPaginator
func NewListManagedThingsPaginator(client ListManagedThingsAPIClient, params *ListManagedThingsInput, optFns ...func(*ListManagedThingsPaginatorOptions)) *ListManagedThingsPaginator {
	if params == nil {
		params = &ListManagedThingsInput{}
	}

	options := ListManagedThingsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListManagedThingsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListManagedThingsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListManagedThings page.
func (p *ListManagedThingsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListManagedThingsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListManagedThings(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListManagedThingsAPIClient is a client that implements the ListManagedThings
// operation.
type ListManagedThingsAPIClient interface {
	ListManagedThings(context.Context, *ListManagedThingsInput, ...func(*Options)) (*ListManagedThingsOutput, error)
}

var _ ListManagedThingsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListManagedThings(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListManagedThings",
	}
}
