// Code generated by smithy-go-codegen DO NOT EDIT.

package iotsitewise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotsitewise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves information about an interface relationship between an asset model
// and an interface asset model.
func (c *Client) DescribeAssetModelInterfaceRelationship(ctx context.Context, params *DescribeAssetModelInterfaceRelationshipInput, optFns ...func(*Options)) (*DescribeAssetModelInterfaceRelationshipOutput, error) {
	if params == nil {
		params = &DescribeAssetModelInterfaceRelationshipInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeAssetModelInterfaceRelationship", params, optFns, c.addOperationDescribeAssetModelInterfaceRelationshipMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeAssetModelInterfaceRelationshipOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeAssetModelInterfaceRelationshipInput struct {

	// The ID of the asset model. This can be either the actual ID in UUID format, or
	// else externalId: followed by the external ID.
	//
	// This member is required.
	AssetModelId *string

	// The ID of the interface asset model. This can be either the actual ID in UUID
	// format, or else externalId: followed by the external ID.
	//
	// This member is required.
	InterfaceAssetModelId *string

	noSmithyDocumentSerde
}

type DescribeAssetModelInterfaceRelationshipOutput struct {

	// The ID of the asset model.
	//
	// This member is required.
	AssetModelId *string

	// A list of hierarchy mappings between the interface asset model and the asset
	// model where the interface is applied.
	//
	// This member is required.
	HierarchyMappings []types.HierarchyMapping

	// The ID of the interface asset model.
	//
	// This member is required.
	InterfaceAssetModelId *string

	// A list of property mappings between the interface asset model and the asset
	// model where the interface is applied.
	//
	// This member is required.
	PropertyMappings []types.PropertyMapping

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeAssetModelInterfaceRelationshipMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeAssetModelInterfaceRelationship{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeAssetModelInterfaceRelationship{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeAssetModelInterfaceRelationship"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opDescribeAssetModelInterfaceRelationshipMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeAssetModelInterfaceRelationshipValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeAssetModelInterfaceRelationship(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opDescribeAssetModelInterfaceRelationshipMiddleware struct {
}

func (*endpointPrefix_opDescribeAssetModelInterfaceRelationshipMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opDescribeAssetModelInterfaceRelationshipMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "api." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opDescribeAssetModelInterfaceRelationshipMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opDescribeAssetModelInterfaceRelationshipMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opDescribeAssetModelInterfaceRelationship(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeAssetModelInterfaceRelationship",
	}
}
