// Code generated by smithy-go-codegen DO NOT EDIT.

package iotsitewise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotsitewise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates or updates an interface relationship between an asset model and an
// interface asset model. This operation applies an interface to an asset model.
func (c *Client) PutAssetModelInterfaceRelationship(ctx context.Context, params *PutAssetModelInterfaceRelationshipInput, optFns ...func(*Options)) (*PutAssetModelInterfaceRelationshipOutput, error) {
	if params == nil {
		params = &PutAssetModelInterfaceRelationshipInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutAssetModelInterfaceRelationship", params, optFns, c.addOperationPutAssetModelInterfaceRelationshipMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutAssetModelInterfaceRelationshipOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutAssetModelInterfaceRelationshipInput struct {

	// The ID of the asset model. This can be either the actual ID in UUID format, or
	// else externalId: followed by the external ID.
	//
	// This member is required.
	AssetModelId *string

	// The ID of the interface asset model. This can be either the actual ID in UUID
	// format, or else externalId: followed by the external ID.
	//
	// This member is required.
	InterfaceAssetModelId *string

	// The configuration for mapping properties from the interface asset model to the
	// asset model where the interface is applied. This configuration controls how
	// properties are matched and created during the interface application process.
	//
	// This member is required.
	PropertyMappingConfiguration *types.PropertyMappingConfiguration

	// A unique case-sensitive identifier that you can provide to ensure the
	// idempotency of the request. Don't reuse this client token if a new idempotent
	// request is required.
	ClientToken *string

	noSmithyDocumentSerde
}

type PutAssetModelInterfaceRelationshipOutput struct {

	// The ARN of the asset model, which has the following format.
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
	//
	// This member is required.
	AssetModelArn *string

	// The ID of the asset model.
	//
	// This member is required.
	AssetModelId *string

	// Contains current status information for an asset model. For more information,
	// see [Asset and model states]in the IoT SiteWise User Guide.
	//
	// [Asset and model states]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html
	//
	// This member is required.
	AssetModelStatus *types.AssetModelStatus

	// The ID of the interface asset model.
	//
	// This member is required.
	InterfaceAssetModelId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutAssetModelInterfaceRelationshipMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutAssetModelInterfaceRelationship{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutAssetModelInterfaceRelationship{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutAssetModelInterfaceRelationship"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opPutAssetModelInterfaceRelationshipMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opPutAssetModelInterfaceRelationshipMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpPutAssetModelInterfaceRelationshipValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutAssetModelInterfaceRelationship(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opPutAssetModelInterfaceRelationshipMiddleware struct {
}

func (*endpointPrefix_opPutAssetModelInterfaceRelationshipMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opPutAssetModelInterfaceRelationshipMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "api." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opPutAssetModelInterfaceRelationshipMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opPutAssetModelInterfaceRelationshipMiddleware{}, "ResolveEndpointV2", middleware.After)
}

type idempotencyToken_initializeOpPutAssetModelInterfaceRelationship struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpPutAssetModelInterfaceRelationship) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpPutAssetModelInterfaceRelationship) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*PutAssetModelInterfaceRelationshipInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *PutAssetModelInterfaceRelationshipInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opPutAssetModelInterfaceRelationshipMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpPutAssetModelInterfaceRelationship{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opPutAssetModelInterfaceRelationship(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutAssetModelInterfaceRelationship",
	}
}
