// Code generated by smithy-go-codegen DO NOT EDIT.

package kafka

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kafka/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns partition details of this topic on a MSK cluster.
func (c *Client) DescribeTopicPartitions(ctx context.Context, params *DescribeTopicPartitionsInput, optFns ...func(*Options)) (*DescribeTopicPartitionsOutput, error) {
	if params == nil {
		params = &DescribeTopicPartitionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeTopicPartitions", params, optFns, c.addOperationDescribeTopicPartitionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeTopicPartitionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeTopicPartitionsInput struct {

	// The Amazon Resource Name (ARN) that uniquely identifies the cluster.
	//
	// This member is required.
	ClusterArn *string

	// The Kafka topic name that uniquely identifies the topic.
	//
	// This member is required.
	TopicName *string

	// The maximum number of results to return in the response. If there are more
	// results, the response includes a NextToken parameter.
	MaxResults *int32

	// The paginated results marker. When the result of the operation is truncated,
	// the call returns NextToken in the response. To get the next batch, provide this
	// token in your next request.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeTopicPartitionsOutput struct {

	// The paginated results marker. When the result of a DescribeTopicPartitions
	// operation is truncated, the call returns NextToken in the response. To get
	// another batch of configurations, provide this token in your next request.
	NextToken *string

	// The list of partition information for the topic.
	Partitions []types.TopicPartitionInfo

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeTopicPartitionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeTopicPartitions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeTopicPartitions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeTopicPartitions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeTopicPartitionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeTopicPartitions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeTopicPartitionsPaginatorOptions is the paginator options for
// DescribeTopicPartitions
type DescribeTopicPartitionsPaginatorOptions struct {
	// The maximum number of results to return in the response. If there are more
	// results, the response includes a NextToken parameter.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeTopicPartitionsPaginator is a paginator for DescribeTopicPartitions
type DescribeTopicPartitionsPaginator struct {
	options   DescribeTopicPartitionsPaginatorOptions
	client    DescribeTopicPartitionsAPIClient
	params    *DescribeTopicPartitionsInput
	nextToken *string
	firstPage bool
}

// NewDescribeTopicPartitionsPaginator returns a new
// DescribeTopicPartitionsPaginator
func NewDescribeTopicPartitionsPaginator(client DescribeTopicPartitionsAPIClient, params *DescribeTopicPartitionsInput, optFns ...func(*DescribeTopicPartitionsPaginatorOptions)) *DescribeTopicPartitionsPaginator {
	if params == nil {
		params = &DescribeTopicPartitionsInput{}
	}

	options := DescribeTopicPartitionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeTopicPartitionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeTopicPartitionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeTopicPartitions page.
func (p *DescribeTopicPartitionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeTopicPartitionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeTopicPartitions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeTopicPartitionsAPIClient is a client that implements the
// DescribeTopicPartitions operation.
type DescribeTopicPartitionsAPIClient interface {
	DescribeTopicPartitions(context.Context, *DescribeTopicPartitionsInput, ...func(*Options)) (*DescribeTopicPartitionsOutput, error)
}

var _ DescribeTopicPartitionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeTopicPartitions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeTopicPartitions",
	}
}
