// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesisvideo

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kinesisvideo/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns an array of ChannelInfo objects. Each object describes a signaling
// channel. To retrieve only those channels that satisfy a specific condition, you
// can specify a ChannelNameCondition .
func (c *Client) ListSignalingChannels(ctx context.Context, params *ListSignalingChannelsInput, optFns ...func(*Options)) (*ListSignalingChannelsOutput, error) {
	if params == nil {
		params = &ListSignalingChannelsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSignalingChannels", params, optFns, c.addOperationListSignalingChannelsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSignalingChannelsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSignalingChannelsInput struct {

	// Optional: Returns only the channels that satisfy a specific condition.
	ChannelNameCondition *types.ChannelNameCondition

	// The maximum number of channels to return in the response. The default is 500.
	MaxResults *int32

	// If you specify this parameter, when the result of a ListSignalingChannels
	// operation is truncated, the call returns the NextToken in the response. To get
	// another batch of channels, provide this token in your next request.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSignalingChannelsOutput struct {

	// An array of ChannelInfo objects.
	ChannelInfoList []types.ChannelInfo

	// If the response is truncated, the call returns this element with a token. To
	// get the next batch of streams, use this token in your next request.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSignalingChannelsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListSignalingChannels{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListSignalingChannels{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSignalingChannels"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSignalingChannels(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListSignalingChannelsPaginatorOptions is the paginator options for
// ListSignalingChannels
type ListSignalingChannelsPaginatorOptions struct {
	// The maximum number of channels to return in the response. The default is 500.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSignalingChannelsPaginator is a paginator for ListSignalingChannels
type ListSignalingChannelsPaginator struct {
	options   ListSignalingChannelsPaginatorOptions
	client    ListSignalingChannelsAPIClient
	params    *ListSignalingChannelsInput
	nextToken *string
	firstPage bool
}

// NewListSignalingChannelsPaginator returns a new ListSignalingChannelsPaginator
func NewListSignalingChannelsPaginator(client ListSignalingChannelsAPIClient, params *ListSignalingChannelsInput, optFns ...func(*ListSignalingChannelsPaginatorOptions)) *ListSignalingChannelsPaginator {
	if params == nil {
		params = &ListSignalingChannelsInput{}
	}

	options := ListSignalingChannelsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSignalingChannelsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSignalingChannelsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSignalingChannels page.
func (p *ListSignalingChannelsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSignalingChannelsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListSignalingChannels(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListSignalingChannelsAPIClient is a client that implements the
// ListSignalingChannels operation.
type ListSignalingChannelsAPIClient interface {
	ListSignalingChannels(context.Context, *ListSignalingChannelsInput, ...func(*Options)) (*ListSignalingChannelsOutput, error)
}

var _ ListSignalingChannelsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListSignalingChannels(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSignalingChannels",
	}
}
