// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesisvideo

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kinesisvideo/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the storage configuration for an existing Kinesis video stream.
//
// This operation allows you to modify the storage tier settings for a stream,
// enabling you to optimize storage costs and performance based on your access
// patterns.
//
// UpdateStreamStorageConfiguration is an asynchronous operation.
//
// You must have permissions for the KinesisVideo:UpdateStreamStorageConfiguration
// action.
func (c *Client) UpdateStreamStorageConfiguration(ctx context.Context, params *UpdateStreamStorageConfigurationInput, optFns ...func(*Options)) (*UpdateStreamStorageConfigurationOutput, error) {
	if params == nil {
		params = &UpdateStreamStorageConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateStreamStorageConfiguration", params, optFns, c.addOperationUpdateStreamStorageConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateStreamStorageConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateStreamStorageConfigurationInput struct {

	// The version of the stream whose storage configuration you want to change. To
	// get the version, call either the DescribeStream or the ListStreams API.
	//
	// This member is required.
	CurrentVersion *string

	// The new storage configuration for the stream. This includes the default storage
	// tier that determines how stream data is stored and accessed.
	//
	// Different storage tiers offer varying levels of performance and cost
	// optimization to match your specific use case requirements.
	//
	// This member is required.
	StreamStorageConfiguration *types.StreamStorageConfiguration

	// The Amazon Resource Name (ARN) of the stream for which you want to update the
	// storage configuration.
	StreamARN *string

	// The name of the stream for which you want to update the storage configuration.
	StreamName *string

	noSmithyDocumentSerde
}

type UpdateStreamStorageConfigurationOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateStreamStorageConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateStreamStorageConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateStreamStorageConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateStreamStorageConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateStreamStorageConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateStreamStorageConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateStreamStorageConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateStreamStorageConfiguration",
	}
}
