// Code generated by smithy-go-codegen DO NOT EDIT.

package lambda

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lambda/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the execution history for a [durable execution], showing all the steps, callbacks, and
// events that occurred during the execution. This provides a detailed audit trail
// of the execution's progress over time.
//
// The history is available while the execution is running and for a retention
// period after it completes (1-90 days, default 30 days). You can control whether
// to include execution data such as step results and callback payloads.
//
// [durable execution]: https://docs.aws.amazon.com/lambda/latest/dg/durable-functions.html
func (c *Client) GetDurableExecutionHistory(ctx context.Context, params *GetDurableExecutionHistoryInput, optFns ...func(*Options)) (*GetDurableExecutionHistoryOutput, error) {
	if params == nil {
		params = &GetDurableExecutionHistoryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDurableExecutionHistory", params, optFns, c.addOperationGetDurableExecutionHistoryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDurableExecutionHistoryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDurableExecutionHistoryInput struct {

	// The Amazon Resource Name (ARN) of the durable execution.
	//
	// This member is required.
	DurableExecutionArn *string

	// Specifies whether to include execution data such as step results and callback
	// payloads in the history events. Set to true to include data, or false to
	// exclude it for a more compact response. The default is true .
	IncludeExecutionData *bool

	// If NextMarker was returned from a previous request, use this value to retrieve
	// the next page of results. Each pagination token expires after 24 hours.
	Marker *string

	// The maximum number of history events to return per call. You can use Marker to
	// retrieve additional pages of results. The default is 100 and the maximum allowed
	// is 1000. A value of 0 uses the default.
	MaxItems int32

	// When set to true , returns the history events in reverse chronological order
	// (newest first). By default, events are returned in chronological order (oldest
	// first).
	ReverseOrder *bool

	noSmithyDocumentSerde
}

// The response from the GetDurableExecutionHistory operation, containing the
// execution history and events.
type GetDurableExecutionHistoryOutput struct {

	// An array of execution history events, ordered chronologically unless
	// ReverseOrder is set to true . Each event represents a significant occurrence
	// during the execution, such as step completion or callback resolution.
	//
	// This member is required.
	Events []types.Event

	// If present, indicates that more history events are available. Use this value as
	// the Marker parameter in a subsequent request to retrieve the next page of
	// results.
	NextMarker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDurableExecutionHistoryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetDurableExecutionHistory{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetDurableExecutionHistory{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetDurableExecutionHistory"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetDurableExecutionHistoryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDurableExecutionHistory(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// GetDurableExecutionHistoryPaginatorOptions is the paginator options for
// GetDurableExecutionHistory
type GetDurableExecutionHistoryPaginatorOptions struct {
	// The maximum number of history events to return per call. You can use Marker to
	// retrieve additional pages of results. The default is 100 and the maximum allowed
	// is 1000. A value of 0 uses the default.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetDurableExecutionHistoryPaginator is a paginator for
// GetDurableExecutionHistory
type GetDurableExecutionHistoryPaginator struct {
	options   GetDurableExecutionHistoryPaginatorOptions
	client    GetDurableExecutionHistoryAPIClient
	params    *GetDurableExecutionHistoryInput
	nextToken *string
	firstPage bool
}

// NewGetDurableExecutionHistoryPaginator returns a new
// GetDurableExecutionHistoryPaginator
func NewGetDurableExecutionHistoryPaginator(client GetDurableExecutionHistoryAPIClient, params *GetDurableExecutionHistoryInput, optFns ...func(*GetDurableExecutionHistoryPaginatorOptions)) *GetDurableExecutionHistoryPaginator {
	if params == nil {
		params = &GetDurableExecutionHistoryInput{}
	}

	options := GetDurableExecutionHistoryPaginatorOptions{}
	if params.MaxItems != 0 {
		options.Limit = params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetDurableExecutionHistoryPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetDurableExecutionHistoryPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetDurableExecutionHistory page.
func (p *GetDurableExecutionHistoryPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetDurableExecutionHistoryOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	params.MaxItems = p.options.Limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetDurableExecutionHistory(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetDurableExecutionHistoryAPIClient is a client that implements the
// GetDurableExecutionHistory operation.
type GetDurableExecutionHistoryAPIClient interface {
	GetDurableExecutionHistory(context.Context, *GetDurableExecutionHistoryInput, ...func(*Options)) (*GetDurableExecutionHistoryOutput, error)
}

var _ GetDurableExecutionHistoryAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetDurableExecutionHistory(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetDurableExecutionHistory",
	}
}
