// Code generated by smithy-go-codegen DO NOT EDIT.

package lambda

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lambda/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the current execution state required for the replay process during [durable function]
// execution. This API is used by the Lambda durable functions SDK to get state
// information needed for replay. You typically don't need to call this API
// directly as the SDK handles state management automatically.
//
// The response contains operations ordered by start sequence number in ascending
// order. Completed operations with children don't include child operation details
// since they don't need to be replayed.
//
// [durable function]: https://docs.aws.amazon.com/lambda/latest/dg/durable-functions.html
func (c *Client) GetDurableExecutionState(ctx context.Context, params *GetDurableExecutionStateInput, optFns ...func(*Options)) (*GetDurableExecutionStateOutput, error) {
	if params == nil {
		params = &GetDurableExecutionStateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDurableExecutionState", params, optFns, c.addOperationGetDurableExecutionStateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDurableExecutionStateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDurableExecutionStateInput struct {

	// A checkpoint token that identifies the current state of the execution. This
	// token is provided by the Lambda runtime and ensures that state retrieval is
	// consistent with the current execution context.
	//
	// This member is required.
	CheckpointToken *string

	// The Amazon Resource Name (ARN) of the durable execution.
	//
	// This member is required.
	DurableExecutionArn *string

	// If NextMarker was returned from a previous request, use this value to retrieve
	// the next page of operations. Each pagination token expires after 24 hours.
	Marker *string

	// The maximum number of operations to return per call. You can use Marker to
	// retrieve additional pages of results. The default is 100 and the maximum allowed
	// is 1000. A value of 0 uses the default.
	MaxItems int32

	noSmithyDocumentSerde
}

// The response from the GetDurableExecutionState operation, containing the
// current execution state for replay.
type GetDurableExecutionStateOutput struct {

	// An array of operations that represent the current state of the durable
	// execution. Operations are ordered by their start sequence number in ascending
	// order and include information needed for replay processing.
	//
	// This member is required.
	Operations []types.Operation

	// If present, indicates that more operations are available. Use this value as the
	// Marker parameter in a subsequent request to retrieve the next page of results.
	NextMarker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDurableExecutionStateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetDurableExecutionState{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetDurableExecutionState{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetDurableExecutionState"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetDurableExecutionStateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDurableExecutionState(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// GetDurableExecutionStatePaginatorOptions is the paginator options for
// GetDurableExecutionState
type GetDurableExecutionStatePaginatorOptions struct {
	// The maximum number of operations to return per call. You can use Marker to
	// retrieve additional pages of results. The default is 100 and the maximum allowed
	// is 1000. A value of 0 uses the default.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetDurableExecutionStatePaginator is a paginator for GetDurableExecutionState
type GetDurableExecutionStatePaginator struct {
	options   GetDurableExecutionStatePaginatorOptions
	client    GetDurableExecutionStateAPIClient
	params    *GetDurableExecutionStateInput
	nextToken *string
	firstPage bool
}

// NewGetDurableExecutionStatePaginator returns a new
// GetDurableExecutionStatePaginator
func NewGetDurableExecutionStatePaginator(client GetDurableExecutionStateAPIClient, params *GetDurableExecutionStateInput, optFns ...func(*GetDurableExecutionStatePaginatorOptions)) *GetDurableExecutionStatePaginator {
	if params == nil {
		params = &GetDurableExecutionStateInput{}
	}

	options := GetDurableExecutionStatePaginatorOptions{}
	if params.MaxItems != 0 {
		options.Limit = params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetDurableExecutionStatePaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetDurableExecutionStatePaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetDurableExecutionState page.
func (p *GetDurableExecutionStatePaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetDurableExecutionStateOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	params.MaxItems = p.options.Limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetDurableExecutionState(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetDurableExecutionStateAPIClient is a client that implements the
// GetDurableExecutionState operation.
type GetDurableExecutionStateAPIClient interface {
	GetDurableExecutionState(context.Context, *GetDurableExecutionStateInput, ...func(*Options)) (*GetDurableExecutionStateOutput, error)
}

var _ GetDurableExecutionStateAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetDurableExecutionState(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetDurableExecutionState",
	}
}
