// Code generated by smithy-go-codegen DO NOT EDIT.

package lambda

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lambda/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns a list of [durable executions] for a specified Lambda function. You can filter the results
// by execution name, status, and start time range. This API supports pagination
// for large result sets.
//
// [durable executions]: https://docs.aws.amazon.com/lambda/latest/dg/durable-functions.html
func (c *Client) ListDurableExecutionsByFunction(ctx context.Context, params *ListDurableExecutionsByFunctionInput, optFns ...func(*Options)) (*ListDurableExecutionsByFunctionOutput, error) {
	if params == nil {
		params = &ListDurableExecutionsByFunctionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDurableExecutionsByFunction", params, optFns, c.addOperationListDurableExecutionsByFunctionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDurableExecutionsByFunctionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDurableExecutionsByFunctionInput struct {

	// The name or ARN of the Lambda function. You can specify a function name, a
	// partial ARN, or a full ARN.
	//
	// This member is required.
	FunctionName *string

	// Filter executions by name. Only executions with names that contain this string
	// are returned.
	DurableExecutionName *string

	// Pagination token from a previous request to continue retrieving results.
	Marker *string

	// Maximum number of executions to return (1-1000). Default is 100.
	MaxItems int32

	// The function version or alias. If not specified, lists executions for the
	// $LATEST version.
	Qualifier *string

	// Set to true to return results in reverse chronological order (newest first).
	// Default is false.
	ReverseOrder *bool

	// Filter executions that started after this timestamp (ISO 8601 format).
	StartedAfter *time.Time

	// Filter executions that started before this timestamp (ISO 8601 format).
	StartedBefore *time.Time

	// Filter executions by status. Valid values: RUNNING, SUCCEEDED, FAILED,
	// TIMED_OUT, STOPPED.
	Statuses []types.ExecutionStatus

	noSmithyDocumentSerde
}

// The response from the ListDurableExecutionsByFunction operation, containing a
// list of durable executions and pagination information.
type ListDurableExecutionsByFunctionOutput struct {

	// List of durable execution summaries matching the filter criteria.
	DurableExecutions []types.Execution

	// Pagination token for retrieving additional results. Present only if there are
	// more results available.
	NextMarker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDurableExecutionsByFunctionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDurableExecutionsByFunction{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDurableExecutionsByFunction{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDurableExecutionsByFunction"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDurableExecutionsByFunctionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDurableExecutionsByFunction(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDurableExecutionsByFunctionPaginatorOptions is the paginator options for
// ListDurableExecutionsByFunction
type ListDurableExecutionsByFunctionPaginatorOptions struct {
	// Maximum number of executions to return (1-1000). Default is 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDurableExecutionsByFunctionPaginator is a paginator for
// ListDurableExecutionsByFunction
type ListDurableExecutionsByFunctionPaginator struct {
	options   ListDurableExecutionsByFunctionPaginatorOptions
	client    ListDurableExecutionsByFunctionAPIClient
	params    *ListDurableExecutionsByFunctionInput
	nextToken *string
	firstPage bool
}

// NewListDurableExecutionsByFunctionPaginator returns a new
// ListDurableExecutionsByFunctionPaginator
func NewListDurableExecutionsByFunctionPaginator(client ListDurableExecutionsByFunctionAPIClient, params *ListDurableExecutionsByFunctionInput, optFns ...func(*ListDurableExecutionsByFunctionPaginatorOptions)) *ListDurableExecutionsByFunctionPaginator {
	if params == nil {
		params = &ListDurableExecutionsByFunctionInput{}
	}

	options := ListDurableExecutionsByFunctionPaginatorOptions{}
	if params.MaxItems != 0 {
		options.Limit = params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDurableExecutionsByFunctionPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDurableExecutionsByFunctionPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDurableExecutionsByFunction page.
func (p *ListDurableExecutionsByFunctionPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDurableExecutionsByFunctionOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	params.MaxItems = p.options.Limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDurableExecutionsByFunction(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDurableExecutionsByFunctionAPIClient is a client that implements the
// ListDurableExecutionsByFunction operation.
type ListDurableExecutionsByFunctionAPIClient interface {
	ListDurableExecutionsByFunction(context.Context, *ListDurableExecutionsByFunctionInput, ...func(*Options)) (*ListDurableExecutionsByFunctionOutput, error)
}

var _ ListDurableExecutionsByFunctionAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDurableExecutionsByFunction(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDurableExecutionsByFunction",
	}
}
