// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Limits that are related to concurrency and storage. All file and storage sizes
// are in bytes.
type AccountLimit struct {

	// The maximum size of a function's deployment package and layers when they're
	// extracted.
	CodeSizeUnzipped int64

	// The maximum size of a deployment package when it's uploaded directly to Lambda.
	// Use Amazon S3 for larger files.
	CodeSizeZipped int64

	// The maximum number of simultaneous function executions.
	ConcurrentExecutions int32

	// The amount of storage space that you can use for all deployment packages and
	// layer archives.
	TotalCodeSize int64

	// The maximum number of simultaneous function executions, minus the capacity
	// that's reserved for individual functions with PutFunctionConcurrency.
	UnreservedConcurrentExecutions *int32

	noSmithyDocumentSerde
}

// The number of functions and amount of storage in use.
type AccountUsage struct {

	// The number of Lambda functions.
	FunctionCount int64

	// The amount of storage space, in bytes, that's being used by deployment packages
	// and layer archives.
	TotalCodeSize int64

	noSmithyDocumentSerde
}

// Provides configuration information about a Lambda function [alias].
//
// [alias]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html
type AliasConfiguration struct {

	// The Amazon Resource Name (ARN) of the alias.
	AliasArn *string

	// A description of the alias.
	Description *string

	// The function version that the alias invokes.
	FunctionVersion *string

	// The name of the alias.
	Name *string

	// A unique identifier that changes when you update the alias.
	RevisionId *string

	// The [routing configuration] of the alias.
	//
	// [routing configuration]: https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html
	RoutingConfig *AliasRoutingConfiguration

	noSmithyDocumentSerde
}

// The [traffic-shifting] configuration of a Lambda function alias.
//
// [traffic-shifting]: https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html
type AliasRoutingConfiguration struct {

	// The second version, and the percentage of traffic that's routed to it.
	AdditionalVersionWeights map[string]float64

	noSmithyDocumentSerde
}

// List of signing profiles that can sign a code package.
type AllowedPublishers struct {

	// The Amazon Resource Name (ARN) for each of the signing profiles. A signing
	// profile defines a trusted user who can sign a code package.
	//
	// This member is required.
	SigningProfileVersionArns []string

	noSmithyDocumentSerde
}

// Specific configuration settings for an Amazon Managed Streaming for Apache
// Kafka (Amazon MSK) event source.
type AmazonManagedKafkaEventSourceConfig struct {

	// The identifier for the Kafka consumer group to join. The consumer group ID must
	// be unique among all your Kafka event sources. After creating a Kafka event
	// source mapping with the consumer group ID specified, you cannot update this
	// value. For more information, see [Customizable consumer group ID].
	//
	// [Customizable consumer group ID]: https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-consumer-group-id
	ConsumerGroupId *string

	// Specific configuration settings for a Kafka schema registry.
	SchemaRegistryConfig *KafkaSchemaRegistryConfig

	noSmithyDocumentSerde
}

// Contains details about a callback operation in a durable execution, including
// the callback token and timeout configuration.
type CallbackDetails struct {

	// The callback ID. Callback IDs are generated by the DurableContext when a
	// durable function calls ctx.waitForCallback .
	CallbackId *string

	// An error object that contains details about the failure.
	Error *ErrorObject

	// The response payload from the callback operation as a string.
	Result *string

	noSmithyDocumentSerde
}

// Contains details about a failed callback operation, including error information
// and the reason for failure.
type CallbackFailedDetails struct {

	// An error object that contains details about the failure.
	//
	// This member is required.
	Error *EventError

	noSmithyDocumentSerde
}

// Configuration options for callback operations in durable executions, including
// timeout settings and retry behavior.
type CallbackOptions struct {

	// The heartbeat timeout for the callback operation, in seconds. If not specified
	// or set to 0, heartbeat timeout is disabled.
	HeartbeatTimeoutSeconds int32

	// The timeout for the callback operation in seconds. If not specified or set to
	// 0, the callback has no timeout.
	TimeoutSeconds int32

	noSmithyDocumentSerde
}

// Contains details about a callback operation that has started, including timing
// information and callback metadata.
type CallbackStartedDetails struct {

	// The callback ID. Callback IDs are generated by the DurableContext when a
	// durable function calls ctx.waitForCallback .
	//
	// This member is required.
	CallbackId *string

	// The heartbeat timeout value, in seconds.
	HeartbeatTimeout *int32

	// The timeout value, in seconds.
	Timeout *int32

	noSmithyDocumentSerde
}

// Contains details about a successfully completed callback operation, including
// the result data and completion timestamp.
type CallbackSucceededDetails struct {

	// The response payload from the successful operation.
	//
	// This member is required.
	Result *EventResult

	noSmithyDocumentSerde
}

// Contains details about a callback operation that timed out, including timeout
// duration and any partial results.
type CallbackTimedOutDetails struct {

	// Details about the callback timeout.
	//
	// This member is required.
	Error *EventError

	noSmithyDocumentSerde
}

// A capacity provider manages compute resources for Lambda functions.
type CapacityProvider struct {

	// The Amazon Resource Name (ARN) of the capacity provider.
	//
	// This member is required.
	CapacityProviderArn *string

	// The permissions configuration for the capacity provider.
	//
	// This member is required.
	PermissionsConfig *CapacityProviderPermissionsConfig

	// The current state of the capacity provider.
	//
	// This member is required.
	State CapacityProviderState

	// The VPC configuration for the capacity provider.
	//
	// This member is required.
	VpcConfig *CapacityProviderVpcConfig

	// The scaling configuration for the capacity provider.
	CapacityProviderScalingConfig *CapacityProviderScalingConfig

	// The instance requirements for compute resources managed by the capacity
	// provider.
	InstanceRequirements *InstanceRequirements

	// The ARN of the KMS key used to encrypt the capacity provider's resources.
	KmsKeyArn *string

	// The date and time when the capacity provider was last modified.
	LastModified *string

	noSmithyDocumentSerde
}

// Configuration for the capacity provider that manages compute resources for
// Lambda functions.
type CapacityProviderConfig struct {

	// Configuration for Lambda-managed instances used by the capacity provider.
	//
	// This member is required.
	LambdaManagedInstancesCapacityProviderConfig *LambdaManagedInstancesCapacityProviderConfig

	noSmithyDocumentSerde
}

// Configuration that specifies the permissions required for the capacity provider
// to manage compute resources.
type CapacityProviderPermissionsConfig struct {

	// The ARN of the IAM role that the capacity provider uses to manage compute
	// instances and other Amazon Web Services resources.
	//
	// This member is required.
	CapacityProviderOperatorRoleArn *string

	noSmithyDocumentSerde
}

// Configuration that defines how the capacity provider scales compute instances
// based on demand and policies.
type CapacityProviderScalingConfig struct {

	// The maximum number of vCPUs that the capacity provider can provision across all
	// compute instances.
	MaxVCpuCount *int32

	// The scaling mode that determines how the capacity provider responds to changes
	// in demand.
	ScalingMode CapacityProviderScalingMode

	// A list of scaling policies that define how the capacity provider scales compute
	// instances based on metrics and thresholds.
	ScalingPolicies []TargetTrackingScalingPolicy

	noSmithyDocumentSerde
}

// VPC configuration that specifies the network settings for compute instances
// managed by the capacity provider.
type CapacityProviderVpcConfig struct {

	// A list of security group IDs that control network access for compute instances
	// managed by the capacity provider.
	//
	// This member is required.
	SecurityGroupIds []string

	// A list of subnet IDs where the capacity provider launches compute instances.
	//
	// This member is required.
	SubnetIds []string

	noSmithyDocumentSerde
}

// Contains details about a chained function invocation in a durable execution,
// including the target function and invocation parameters.
type ChainedInvokeDetails struct {

	// Details about the chained invocation failure.
	Error *ErrorObject

	// The response payload from the chained invocation.
	Result *string

	noSmithyDocumentSerde
}

// Contains details about a failed chained function invocation, including error
// information and failure reason.
type ChainedInvokeFailedDetails struct {

	// Details about the chained invocation failure.
	//
	// This member is required.
	Error *EventError

	noSmithyDocumentSerde
}

// Configuration options for chained function invocations in durable executions,
// including retry settings and timeout configuration.
type ChainedInvokeOptions struct {

	// The name or ARN of the Lambda function to invoke.
	//
	// This member is required.
	FunctionName *string

	// The tenant identifier for the chained invocation.
	TenantId *string

	noSmithyDocumentSerde
}

// Contains details about a chained function invocation that has started
// execution, including start time and execution context.
type ChainedInvokeStartedDetails struct {

	// The name or ARN of the Lambda function being invoked.
	//
	// This member is required.
	FunctionName *string

	// The Amazon Resource Name (ARN) that identifies the durable execution.
	DurableExecutionArn *string

	// The version of the function that was executed.
	ExecutedVersion *string

	// The JSON input payload provided to the chained invocation.
	Input *EventInput

	// The tenant identifier for the chained invocation.
	TenantId *string

	noSmithyDocumentSerde
}

// Details about a chained invocation that was stopped.
type ChainedInvokeStoppedDetails struct {

	// Details about why the chained invocation stopped.
	//
	// This member is required.
	Error *EventError

	noSmithyDocumentSerde
}

// Details about a chained invocation that succeeded.
type ChainedInvokeSucceededDetails struct {

	// The response payload from the successful operation.
	//
	// This member is required.
	Result *EventResult

	noSmithyDocumentSerde
}

// Details about a chained invocation that timed out.
type ChainedInvokeTimedOutDetails struct {

	// Details about the chained invocation timeout.
	//
	// This member is required.
	Error *EventError

	noSmithyDocumentSerde
}

// Contains operations that have been updated since the last checkpoint, such as
// completed asynchronous work like timers or callbacks.
type CheckpointUpdatedExecutionState struct {

	// Indicates that more results are available. Use this value in a subsequent call
	// to retrieve the next page of results.
	NextMarker *string

	// A list of operations that have been updated since the last checkpoint.
	Operations []Operation

	noSmithyDocumentSerde
}

// Details about a [Code signing configuration].
//
// [Code signing configuration]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html
type CodeSigningConfig struct {

	// List of allowed publishers.
	//
	// This member is required.
	AllowedPublishers *AllowedPublishers

	// The Amazon Resource Name (ARN) of the Code signing configuration.
	//
	// This member is required.
	CodeSigningConfigArn *string

	// Unique identifer for the Code signing configuration.
	//
	// This member is required.
	CodeSigningConfigId *string

	// The code signing policy controls the validation failure action for signature
	// mismatch or expiry.
	//
	// This member is required.
	CodeSigningPolicies *CodeSigningPolicies

	// The date and time that the Code signing configuration was last modified, in
	// ISO-8601 format (YYYY-MM-DDThh:mm:ss.sTZD).
	//
	// This member is required.
	LastModified *string

	// Code signing configuration description.
	Description *string

	noSmithyDocumentSerde
}

// Code signing configuration [policies] specify the validation failure action for signature
// mismatch or expiry.
//
// [policies]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html#config-codesigning-policies
type CodeSigningPolicies struct {

	// Code signing configuration policy for deployment validation failure. If you set
	// the policy to Enforce , Lambda blocks the deployment request if signature
	// validation checks fail. If you set the policy to Warn , Lambda allows the
	// deployment and issues a new Amazon CloudWatch metric ( SignatureValidationErrors
	// ) and also stores the warning in the CloudTrail log.
	//
	// Default value: Warn
	UntrustedArtifactOnDeployment CodeSigningPolicy

	noSmithyDocumentSerde
}

type Concurrency struct {

	// The number of concurrent executions that are reserved for this function. For
	// more information, see [Managing Lambda reserved concurrency].
	//
	// [Managing Lambda reserved concurrency]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-concurrency.html
	ReservedConcurrentExecutions *int32

	noSmithyDocumentSerde
}

// Details about a durable execution context.
type ContextDetails struct {

	// Details about the context failure.
	Error *ErrorObject

	// Whether the state data of child operations of this completed context should be
	// included in the invoke payload and GetDurableExecutionState response.
	ReplayChildren *bool

	// The response payload from the context.
	Result *string

	noSmithyDocumentSerde
}

// Details about a context that failed.
type ContextFailedDetails struct {

	// Details about the context failure.
	//
	// This member is required.
	Error *EventError

	noSmithyDocumentSerde
}

// Configuration options for a durable execution context.
type ContextOptions struct {

	// Whether the state data of children of the completed context should be included
	// in the invoke payload and GetDurableExecutionState response.
	ReplayChildren *bool

	noSmithyDocumentSerde
}

// Details about a context that has started.
type ContextStartedDetails struct {
	noSmithyDocumentSerde
}

// Details about a context that succeeded.
type ContextSucceededDetails struct {

	// The JSON response payload from the successful context.
	//
	// This member is required.
	Result *EventResult

	noSmithyDocumentSerde
}

// The [cross-origin resource sharing (CORS)] settings for your Lambda function URL. Use CORS to grant access to your
// function URL from any origin. You can also use CORS to control access for
// specific HTTP headers and methods in requests to your function URL.
//
// [cross-origin resource sharing (CORS)]: https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS
type Cors struct {

	// Whether to allow cookies or other credentials in requests to your function URL.
	// The default is false .
	AllowCredentials *bool

	// The HTTP headers that origins can include in requests to your function URL. For
	// example: Date , Keep-Alive , X-Custom-Header .
	AllowHeaders []string

	// The HTTP methods that are allowed when calling your function URL. For example:
	// GET , POST , DELETE , or the wildcard character ( * ).
	AllowMethods []string

	// The origins that can access your function URL. You can list any number of
	// specific origins, separated by a comma. For example: https://www.example.com ,
	// http://localhost:60905 .
	//
	// Alternatively, you can grant access to all origins using the wildcard character
	// ( * ).
	AllowOrigins []string

	// The HTTP headers in your function response that you want to expose to origins
	// that call your function URL. For example: Date , Keep-Alive , X-Custom-Header .
	ExposeHeaders []string

	// The maximum amount of time, in seconds, that web browsers can cache results of
	// a preflight request. By default, this is set to 0 , which means that the browser
	// doesn't cache results.
	MaxAge *int32

	noSmithyDocumentSerde
}

// The [dead-letter queue] for failed asynchronous invocations.
//
// [dead-letter queue]: https://docs.aws.amazon.com/lambda/latest/dg/invocation-async-retain-records.html#invocation-dlq
type DeadLetterConfig struct {

	// The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.
	TargetArn *string

	noSmithyDocumentSerde
}

// A configuration object that specifies the destination of an event after Lambda
// processes it. For more information, see [Adding a destination].
//
// [Adding a destination]: https://docs.aws.amazon.com/lambda/latest/dg/invocation-async-retain-records.html#invocation-async-destinations
type DestinationConfig struct {

	// The destination configuration for failed invocations.
	OnFailure *OnFailure

	// The destination configuration for successful invocations. Not supported in
	// CreateEventSourceMapping or UpdateEventSourceMapping .
	OnSuccess *OnSuccess

	noSmithyDocumentSerde
}

// Specific configuration settings for a DocumentDB event source.
type DocumentDBEventSourceConfig struct {

	//  The name of the collection to consume within the database. If you do not
	// specify a collection, Lambda consumes all collections.
	CollectionName *string

	//  The name of the database to consume within the DocumentDB cluster.
	DatabaseName *string

	//  Determines what DocumentDB sends to your event stream during document update
	// operations. If set to UpdateLookup, DocumentDB sends a delta describing the
	// changes, along with a copy of the entire document. Otherwise, DocumentDB sends
	// only a partial document that contains the changes.
	FullDocument FullDocument

	noSmithyDocumentSerde
}

// Configuration settings for [durable functions], including execution timeout and retention period
// for execution history.
//
// [durable functions]: https://docs.aws.amazon.com/lambda/latest/dg/durable-functions.html
type DurableConfig struct {

	// The maximum time (in seconds) that a durable execution can run before timing
	// out. This timeout applies to the entire durable execution, not individual
	// function invocations.
	ExecutionTimeout *int32

	// The number of days to retain execution history after a durable execution
	// completes. After this period, execution history is no longer available through
	// the GetDurableExecutionHistory API.
	RetentionPeriodInDays *int32

	noSmithyDocumentSerde
}

// A function's environment variable settings. You can use environment variables
// to adjust your function's behavior without updating code. An environment
// variable is a pair of strings that are stored in a function's version-specific
// configuration.
type Environment struct {

	// Environment variable key-value pairs. For more information, see [Using Lambda environment variables].
	//
	// [Using Lambda environment variables]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html
	Variables map[string]string

	noSmithyDocumentSerde
}

// Error messages for environment variables that couldn't be applied.
type EnvironmentError struct {

	// The error code.
	ErrorCode *string

	// The error message.
	Message *string

	noSmithyDocumentSerde
}

// The results of an operation to update or read environment variables. If the
// operation succeeds, the response contains the environment variables. If it
// fails, the response contains details about the error.
type EnvironmentResponse struct {

	// Error messages for environment variables that couldn't be applied.
	Error *EnvironmentError

	// Environment variable key-value pairs. Omitted from CloudTrail logs.
	Variables map[string]string

	noSmithyDocumentSerde
}

// The size of the function's /tmp directory in MB. The default value is 512, but
// can be any whole number between 512 and 10,240 MB. For more information, see [Configuring ephemeral storage (console)].
//
// [Configuring ephemeral storage (console)]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-ephemeral-storage
type EphemeralStorage struct {

	// The size of the function's /tmp directory.
	//
	// This member is required.
	Size *int32

	noSmithyDocumentSerde
}

// An object that contains error information.
type ErrorObject struct {

	// Machine-readable error data.
	ErrorData *string

	// A human-readable error message.
	ErrorMessage *string

	// The error type.
	ErrorType *string

	// Stack trace information for the error.
	StackTrace []string

	noSmithyDocumentSerde
}

// An event that occurred during the execution of a durable function.
type Event struct {

	// Contains details about a failed callback operation, including error information
	// and the reason for failure.
	CallbackFailedDetails *CallbackFailedDetails

	// Contains details about a callback operation that has started, including timing
	// information and callback metadata.
	CallbackStartedDetails *CallbackStartedDetails

	// Contains details about a successfully completed callback operation, including
	// the result data and completion timestamp.
	CallbackSucceededDetails *CallbackSucceededDetails

	// Contains details about a callback operation that timed out, including timeout
	// duration and any partial results.
	CallbackTimedOutDetails *CallbackTimedOutDetails

	// Contains details about a failed chained function invocation, including error
	// information and failure reason.
	ChainedInvokeFailedDetails *ChainedInvokeFailedDetails

	// Contains details about a chained function invocation that has started
	// execution, including start time and execution context.
	ChainedInvokeStartedDetails *ChainedInvokeStartedDetails

	// Details about a chained invocation that was stopped.
	ChainedInvokeStoppedDetails *ChainedInvokeStoppedDetails

	// Details about a chained invocation that succeeded.
	ChainedInvokeSucceededDetails *ChainedInvokeSucceededDetails

	// Details about a chained invocation that timed out.
	ChainedInvokeTimedOutDetails *ChainedInvokeTimedOutDetails

	// Details about a context that failed.
	ContextFailedDetails *ContextFailedDetails

	// Details about a context that started.
	ContextStartedDetails *ContextStartedDetails

	// Details about a context that succeeded.
	ContextSucceededDetails *ContextSucceededDetails

	// The unique identifier for this event. Event IDs increment sequentially.
	EventId *int32

	// The date and time when this event occurred, in [ISO-8601 format] (YYYY-MM-DDThh:mm:ss.sTZD).
	//
	// [ISO-8601 format]: https://www.w3.org/TR/NOTE-datetime
	EventTimestamp *time.Time

	// The type of event that occurred.
	EventType EventType

	// Details about an execution that failed.
	ExecutionFailedDetails *ExecutionFailedDetails

	// Details about an execution that started.
	ExecutionStartedDetails *ExecutionStartedDetails

	// Details about an execution that was stopped.
	ExecutionStoppedDetails *ExecutionStoppedDetails

	// Details about an execution that succeeded.
	ExecutionSucceededDetails *ExecutionSucceededDetails

	// Details about an execution that timed out.
	ExecutionTimedOutDetails *ExecutionTimedOutDetails

	// The unique identifier for this operation.
	Id *string

	// Details about a function invocation that completed.
	InvocationCompletedDetails *InvocationCompletedDetails

	// The customer-provided name for this operation.
	Name *string

	// The unique identifier of the parent operation, if this operation is running
	// within a child context.
	ParentId *string

	// Details about a step that failed.
	StepFailedDetails *StepFailedDetails

	// Details about a step that started.
	StepStartedDetails *StepStartedDetails

	// Details about a step that succeeded.
	StepSucceededDetails *StepSucceededDetails

	// The subtype of the event, providing additional categorization.
	SubType *string

	// Details about a wait operation that was cancelled.
	WaitCancelledDetails *WaitCancelledDetails

	// Details about a wait operation that started.
	WaitStartedDetails *WaitStartedDetails

	// Details about a wait operation that succeeded.
	WaitSucceededDetails *WaitSucceededDetails

	noSmithyDocumentSerde
}

// Error information for an event.
type EventError struct {

	// The error payload.
	Payload *ErrorObject

	// Indicates if the error payload was truncated due to size limits.
	Truncated *bool

	noSmithyDocumentSerde
}

// Input information for an event.
type EventInput struct {

	// The input payload.
	Payload *string

	// Indicates if the error payload was truncated due to size limits.
	Truncated *bool

	noSmithyDocumentSerde
}

// Result information for an event.
type EventResult struct {

	// The result payload.
	Payload *string

	// Indicates if the error payload was truncated due to size limits.
	Truncated *bool

	noSmithyDocumentSerde
}

// A mapping between an Amazon Web Services resource and a Lambda function. For
// details, see CreateEventSourceMapping.
type EventSourceMappingConfiguration struct {

	// Specific configuration settings for an Amazon Managed Streaming for Apache
	// Kafka (Amazon MSK) event source.
	AmazonManagedKafkaEventSourceConfig *AmazonManagedKafkaEventSourceConfig

	// The maximum number of records in each batch that Lambda pulls from your stream
	// or queue and sends to your function. Lambda passes all of the records in the
	// batch to the function in a single call, up to the payload limit for synchronous
	// invocation (6 MB).
	//
	// Default value: Varies by service. For Amazon SQS, the default is 10. For all
	// other services, the default is 100.
	//
	// Related setting: When you set BatchSize to a value greater than 10, you must
	// set MaximumBatchingWindowInSeconds to at least 1.
	BatchSize *int32

	// (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka) If the
	// function returns an error, split the batch in two and retry. The default value
	// is false.
	BisectBatchOnFunctionError *bool

	// (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka) A
	// configuration object that specifies the destination of an event after Lambda
	// processes it.
	DestinationConfig *DestinationConfig

	// Specific configuration settings for a DocumentDB event source.
	DocumentDBEventSourceConfig *DocumentDBEventSourceConfig

	// The Amazon Resource Name (ARN) of the event source.
	EventSourceArn *string

	// The Amazon Resource Name (ARN) of the event source mapping.
	EventSourceMappingArn *string

	// An object that defines the filter criteria that determine whether Lambda should
	// process an event. For more information, see [Lambda event filtering].
	//
	// If filter criteria is encrypted, this field shows up as null in the response of
	// ListEventSourceMapping API calls. You can view this field in plaintext in the
	// response of GetEventSourceMapping and DeleteEventSourceMapping calls if you have
	// kms:Decrypt permissions for the correct KMS key.
	//
	// [Lambda event filtering]: https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html
	FilterCriteria *FilterCriteria

	// An object that contains details about an error related to filter criteria
	// encryption.
	FilterCriteriaError *FilterCriteriaError

	// The ARN of the Lambda function.
	FunctionArn *string

	// (Kinesis, DynamoDB Streams, Amazon MSK, self-managed Apache Kafka, and Amazon
	// SQS) A list of current response type enums applied to the event source mapping.
	FunctionResponseTypes []FunctionResponseType

	//  The ARN of the Key Management Service (KMS) customer managed key that Lambda
	// uses to encrypt your function's [filter criteria].
	//
	// [filter criteria]: https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-basics
	KMSKeyArn *string

	// The date that the event source mapping was last updated or that its state
	// changed.
	LastModified *time.Time

	// The result of the event source mapping's last processing attempt.
	LastProcessingResult *string

	// The maximum amount of time, in seconds, that Lambda spends gathering records
	// before invoking the function. You can configure MaximumBatchingWindowInSeconds
	// to any value from 0 seconds to 300 seconds in increments of seconds.
	//
	// For streams and Amazon SQS event sources, the default batching window is 0
	// seconds. For Amazon MSK, Self-managed Apache Kafka, Amazon MQ, and DocumentDB
	// event sources, the default batching window is 500 ms. Note that because you can
	// only change MaximumBatchingWindowInSeconds in increments of seconds, you cannot
	// revert back to the 500 ms default batching window after you have changed it. To
	// restore the default batching window, you must create a new event source mapping.
	//
	// Related setting: For streams and Amazon SQS event sources, when you set
	// BatchSize to a value greater than 10, you must set
	// MaximumBatchingWindowInSeconds to at least 1.
	MaximumBatchingWindowInSeconds *int32

	// (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka) Discard
	// records older than the specified age. The default value is -1, which sets the
	// maximum age to infinite. When the value is set to infinite, Lambda never
	// discards old records.
	//
	// The minimum valid value for maximum record age is 60s. Although values less
	// than 60 and greater than -1 fall within the parameter's absolute range, they are
	// not allowed
	MaximumRecordAgeInSeconds *int32

	// (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka) Discard
	// records after the specified number of retries. The default value is -1, which
	// sets the maximum number of retries to infinite. When MaximumRetryAttempts is
	// infinite, Lambda retries failed records until the record expires in the event
	// source.
	MaximumRetryAttempts *int32

	// The metrics configuration for your event source. For more information, see [Event source mapping metrics].
	//
	// [Event source mapping metrics]: https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics
	MetricsConfig *EventSourceMappingMetricsConfig

	// (Kinesis and DynamoDB Streams only) The number of batches to process
	// concurrently from each shard. The default value is 1.
	ParallelizationFactor *int32

	// (Amazon SQS, Amazon MSK, and self-managed Apache Kafka only) The provisioned
	// mode configuration for the event source. For more information, see [provisioned mode].
	//
	// [provisioned mode]: https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode
	ProvisionedPollerConfig *ProvisionedPollerConfig

	//  (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
	Queues []string

	// (Amazon SQS only) The scaling configuration for the event source. For more
	// information, see [Configuring maximum concurrency for Amazon SQS event sources].
	//
	// [Configuring maximum concurrency for Amazon SQS event sources]: https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency
	ScalingConfig *ScalingConfig

	// The self-managed Apache Kafka cluster for your event source.
	SelfManagedEventSource *SelfManagedEventSource

	// Specific configuration settings for a self-managed Apache Kafka event source.
	SelfManagedKafkaEventSourceConfig *SelfManagedKafkaEventSourceConfig

	// An array of the authentication protocol, VPC components, or virtual host to
	// secure and define your event source.
	SourceAccessConfigurations []SourceAccessConfiguration

	// The position in a stream from which to start reading. Required for Amazon
	// Kinesis and Amazon DynamoDB Stream event sources. AT_TIMESTAMP is supported
	// only for Amazon Kinesis streams, Amazon DocumentDB, Amazon MSK, and self-managed
	// Apache Kafka.
	StartingPosition EventSourcePosition

	// With StartingPosition set to AT_TIMESTAMP , the time from which to start
	// reading. StartingPositionTimestamp cannot be in the future.
	StartingPositionTimestamp *time.Time

	// The state of the event source mapping. It can be one of the following: Creating
	// , Enabling , Enabled , Disabling , Disabled , Updating , or Deleting .
	State *string

	// Indicates whether a user or Lambda made the last change to the event source
	// mapping.
	StateTransitionReason *string

	// The name of the Kafka topic.
	Topics []string

	// (Kinesis and DynamoDB Streams only) The duration in seconds of a processing
	// window for DynamoDB and Kinesis Streams event sources. A value of 0 seconds
	// indicates no tumbling window.
	TumblingWindowInSeconds *int32

	// The identifier of the event source mapping.
	UUID *string

	noSmithyDocumentSerde
}

// The metrics configuration for your event source. Use this configuration object
// to define which metrics you want your event source mapping to produce.
type EventSourceMappingMetricsConfig struct {

	//  The metrics you want your event source mapping to produce. Include EventCount
	// to receive event source mapping metrics related to the number of events
	// processed by your event source mapping. For more information about these
	// metrics, see [Event source mapping metrics].
	//
	// [Event source mapping metrics]: https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics
	Metrics []EventSourceMappingMetric

	noSmithyDocumentSerde
}

// Information about a [durable execution].
//
// [durable execution]: https://docs.aws.amazon.com/lambda/latest/dg/durable-functions.html
type Execution struct {

	// The Amazon Resource Name (ARN) of the durable execution, if this execution is a
	// durable execution.
	//
	// This member is required.
	DurableExecutionArn *string

	// The unique name of the durable execution, if one was provided when the
	// execution was started.
	//
	// This member is required.
	DurableExecutionName *string

	// The Amazon Resource Name (ARN) of the Lambda function.
	//
	// This member is required.
	FunctionArn *string

	// The date and time when the durable execution started, in [ISO-8601 format]
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	//
	// [ISO-8601 format]: https://www.w3.org/TR/NOTE-datetime
	//
	// This member is required.
	StartTimestamp *time.Time

	// The current status of the durable execution.
	//
	// This member is required.
	Status ExecutionStatus

	// The date and time when the durable execution ended, in [ISO-8601 format]
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	//
	// [ISO-8601 format]: https://www.w3.org/TR/NOTE-datetime
	EndTimestamp *time.Time

	noSmithyDocumentSerde
}

// Details about a [durable execution].
//
// [durable execution]: https://docs.aws.amazon.com/lambda/latest/dg/durable-functions.html
type ExecutionDetails struct {

	// The original input payload provided for the durable execution.
	InputPayload *string

	noSmithyDocumentSerde
}

// Details about a failed [durable execution].
//
// [durable execution]: https://docs.aws.amazon.com/lambda/latest/dg/durable-functions.html
type ExecutionFailedDetails struct {

	// Details about the execution failure.
	//
	// This member is required.
	Error *EventError

	noSmithyDocumentSerde
}

// Details about a durable execution that started.
type ExecutionStartedDetails struct {

	// The maximum amount of time that the durable execution is allowed to run, in
	// seconds.
	//
	// This member is required.
	ExecutionTimeout *int32

	// The input payload provided for the durable execution.
	//
	// This member is required.
	Input *EventInput

	noSmithyDocumentSerde
}

// Details about a [durable execution] that stopped.
//
// [durable execution]: https://docs.aws.amazon.com/lambda/latest/dg/durable-functions.html
type ExecutionStoppedDetails struct {

	// Details about why the execution stopped.
	//
	// This member is required.
	Error *EventError

	noSmithyDocumentSerde
}

// Details about a [durable execution] that succeeded.
//
// [durable execution]: https://docs.aws.amazon.com/lambda/latest/dg/durable-functions.html
type ExecutionSucceededDetails struct {

	// The response payload from the successful operation.
	//
	// This member is required.
	Result *EventResult

	noSmithyDocumentSerde
}

// Details about a [durable execution] that timed out.
//
// [durable execution]: https://docs.aws.amazon.com/lambda/latest/dg/durable-functions.html
type ExecutionTimedOutDetails struct {

	// Details about the execution timeout.
	Error *EventError

	noSmithyDocumentSerde
}

// Details about the connection between a Lambda function and an [Amazon EFS file system].
//
// [Amazon EFS file system]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html
type FileSystemConfig struct {

	// The Amazon Resource Name (ARN) of the Amazon EFS access point that provides
	// access to the file system.
	//
	// This member is required.
	Arn *string

	// The path where the function can access the file system, starting with /mnt/ .
	//
	// This member is required.
	LocalMountPath *string

	noSmithyDocumentSerde
}

//	A structure within a FilterCriteria object that defines an event filtering
//
// pattern.
type Filter struct {

	//  A filter pattern. For more information on the syntax of a filter pattern, see [Filter rule syntax]
	// .
	//
	// [Filter rule syntax]: https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-syntax
	Pattern *string

	noSmithyDocumentSerde
}

// An object that contains the filters for an event source.
type FilterCriteria struct {

	//  A list of filters.
	Filters []Filter

	noSmithyDocumentSerde
}

// An object that contains details about an error related to filter criteria
// encryption.
type FilterCriteriaError struct {

	// The KMS exception that resulted from filter criteria encryption or decryption.
	ErrorCode *string

	// The error message.
	Message *string

	noSmithyDocumentSerde
}

// The code for the Lambda function. You can either specify an object in Amazon
// S3, upload a .zip file archive deployment package directly, or specify the URI
// of a container image.
type FunctionCode struct {

	// URI of a [container image] in the Amazon ECR registry.
	//
	// [container image]: https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html
	ImageUri *string

	// An Amazon S3 bucket in the same Amazon Web Services Region as your function.
	// The bucket can be in a different Amazon Web Services account.
	S3Bucket *string

	// The Amazon S3 key of the deployment package.
	S3Key *string

	// For versioned objects, the version of the deployment package object to use.
	S3ObjectVersion *string

	// The ARN of the Key Management Service (KMS) customer managed key that's used to
	// encrypt your function's .zip deployment package. If you don't provide a customer
	// managed key, Lambda uses an [Amazon Web Services owned key].
	//
	// [Amazon Web Services owned key]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-cmk
	SourceKMSKeyArn *string

	// The base64-encoded contents of the deployment package. Amazon Web Services SDK
	// and CLI clients handle the encoding for you.
	ZipFile []byte

	noSmithyDocumentSerde
}

// Details about a function's deployment package.
type FunctionCodeLocation struct {

	// URI of a container image in the Amazon ECR registry.
	ImageUri *string

	// A presigned URL that you can use to download the deployment package.
	Location *string

	// The service that's hosting the file.
	RepositoryType *string

	// The resolved URI for the image.
	ResolvedImageUri *string

	// The ARN of the Key Management Service (KMS) customer managed key that's used to
	// encrypt your function's .zip deployment package. If you don't provide a customer
	// managed key, Lambda uses an [Amazon Web Services owned key].
	//
	// [Amazon Web Services owned key]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-cmk
	SourceKMSKeyArn *string

	noSmithyDocumentSerde
}

// Details about a function's configuration.
type FunctionConfiguration struct {

	// The instruction set architecture that the function supports. Architecture is a
	// string array with one of the valid values. The default architecture value is
	// x86_64 .
	Architectures []Architecture

	// Configuration for the capacity provider that manages compute resources for
	// Lambda functions.
	CapacityProviderConfig *CapacityProviderConfig

	// The SHA256 hash of the function's deployment package.
	CodeSha256 *string

	// The size of the function's deployment package, in bytes.
	CodeSize int64

	// The SHA256 hash of the function configuration.
	ConfigSha256 *string

	// The function's dead letter queue.
	DeadLetterConfig *DeadLetterConfig

	// The function's description.
	Description *string

	// The function's durable execution configuration settings, if the function is
	// configured for durability.
	DurableConfig *DurableConfig

	// The function's [environment variables]. Omitted from CloudTrail logs.
	//
	// [environment variables]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html
	Environment *EnvironmentResponse

	// The size of the function's /tmp directory in MB. The default value is 512, but
	// can be any whole number between 512 and 10,240 MB. For more information, see [Configuring ephemeral storage (console)].
	//
	// [Configuring ephemeral storage (console)]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-ephemeral-storage
	EphemeralStorage *EphemeralStorage

	// Connection settings for an [Amazon EFS file system].
	//
	// [Amazon EFS file system]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html
	FileSystemConfigs []FileSystemConfig

	// The function's Amazon Resource Name (ARN).
	FunctionArn *string

	// The name of the function.
	FunctionName *string

	// The function that Lambda calls to begin running your function.
	Handler *string

	// The function's image configuration values.
	ImageConfigResponse *ImageConfigResponse

	// The ARN of the Key Management Service (KMS) customer managed key that's used to
	// encrypt the following resources:
	//
	//   - The function's [environment variables].
	//
	//   - The function's [Lambda SnapStart]snapshots.
	//
	//   - When used with SourceKMSKeyArn , the unzipped version of the .zip deployment
	//   package that's used for function invocations. For more information, see [Specifying a customer managed key for Lambda].
	//
	//   - The optimized version of the container image that's used for function
	//   invocations. Note that this is not the same key that's used to protect your
	//   container image in the Amazon Elastic Container Registry (Amazon ECR). For more
	//   information, see [Function lifecycle].
	//
	// If you don't provide a customer managed key, Lambda uses an [Amazon Web Services owned key] or an [Amazon Web Services managed key].
	//
	// [Amazon Web Services owned key]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-cmk
	// [Specifying a customer managed key for Lambda]: https://docs.aws.amazon.com/lambda/latest/dg/encrypt-zip-package.html#enable-zip-custom-encryption
	// [Lambda SnapStart]: https://docs.aws.amazon.com/lambda/latest/dg/snapstart-security.html
	// [environment variables]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-encryption
	// [Function lifecycle]: https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-lifecycle
	// [Amazon Web Services managed key]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk
	KMSKeyArn *string

	// The date and time that the function was last updated, in [ISO-8601 format]
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	//
	// [ISO-8601 format]: https://www.w3.org/TR/NOTE-datetime
	LastModified *string

	// The status of the last update that was performed on the function. This is first
	// set to Successful after function creation completes.
	LastUpdateStatus LastUpdateStatus

	// The reason for the last update that was performed on the function.
	LastUpdateStatusReason *string

	// The reason code for the last update that was performed on the function.
	LastUpdateStatusReasonCode LastUpdateStatusReasonCode

	// The function's [layers].
	//
	// [layers]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html
	Layers []Layer

	// The function's Amazon CloudWatch Logs configuration settings.
	LoggingConfig *LoggingConfig

	// For Lambda@Edge functions, the ARN of the main function.
	MasterArn *string

	// The amount of memory available to the function at runtime.
	MemorySize *int32

	// The type of deployment package. Set to Image for container image and set Zip
	// for .zip file archive.
	PackageType PackageType

	// The latest updated revision of the function or alias.
	RevisionId *string

	// The function's execution role.
	Role *string

	// The identifier of the function's [runtime]. Runtime is required if the deployment
	// package is a .zip file archive. Specifying a runtime results in an error if
	// you're deploying a function using a container image.
	//
	// The following list includes deprecated runtimes. Lambda blocks creating new
	// functions and updating existing functions shortly after each runtime is
	// deprecated. For more information, see [Runtime use after deprecation].
	//
	// For a list of all currently supported runtimes, see [Supported runtimes].
	//
	// [Runtime use after deprecation]: https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels
	// [runtime]: https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html
	// [Supported runtimes]: https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported
	Runtime Runtime

	// The ARN of the runtime and any errors that occured.
	RuntimeVersionConfig *RuntimeVersionConfig

	// The ARN of the signing job.
	SigningJobArn *string

	// The ARN of the signing profile version.
	SigningProfileVersionArn *string

	// Set ApplyOn to PublishedVersions to create a snapshot of the initialized
	// execution environment when you publish a function version. For more information,
	// see [Improving startup performance with Lambda SnapStart].
	//
	// [Improving startup performance with Lambda SnapStart]: https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html
	SnapStart *SnapStartResponse

	// The current state of the function. When the state is Inactive , you can
	// reactivate the function by invoking it.
	State State

	// The reason for the function's current state.
	StateReason *string

	// The reason code for the function's current state. When the code is Creating ,
	// you can't invoke or modify the function.
	StateReasonCode StateReasonCode

	// The function's tenant isolation configuration settings. Determines whether the
	// Lambda function runs on a shared or dedicated infrastructure per unique tenant.
	TenancyConfig *TenancyConfig

	// The amount of time in seconds that Lambda allows a function to run before
	// stopping it.
	Timeout *int32

	// The function's X-Ray tracing configuration.
	TracingConfig *TracingConfigResponse

	// The version of the Lambda function.
	Version *string

	// The function's networking configuration.
	VpcConfig *VpcConfigResponse

	noSmithyDocumentSerde
}

type FunctionEventInvokeConfig struct {

	// A destination for events after they have been sent to a function for processing.
	//
	// Destinations
	//
	//   - Function - The Amazon Resource Name (ARN) of a Lambda function.
	//
	//   - Queue - The ARN of a standard SQS queue.
	//
	//   - Bucket - The ARN of an Amazon S3 bucket.
	//
	//   - Topic - The ARN of a standard SNS topic.
	//
	//   - Event Bus - The ARN of an Amazon EventBridge event bus.
	//
	// S3 buckets are supported only for on-failure destinations. To retain records of
	// successful invocations, use another destination type.
	DestinationConfig *DestinationConfig

	// The Amazon Resource Name (ARN) of the function.
	FunctionArn *string

	// The date and time that the configuration was last updated.
	LastModified *time.Time

	// The maximum age of a request that Lambda sends to a function for processing.
	MaximumEventAgeInSeconds *int32

	// The maximum number of times to retry when the function returns an error.
	MaximumRetryAttempts *int32

	noSmithyDocumentSerde
}

// Configuration that defines the scaling behavior for a Lambda Managed Instances
// function, including the minimum and maximum number of execution environments
// that can be provisioned.
type FunctionScalingConfig struct {

	// The maximum number of execution environments that can be provisioned for the
	// function.
	MaxExecutionEnvironments *int32

	// The minimum number of execution environments to maintain for the function.
	MinExecutionEnvironments *int32

	noSmithyDocumentSerde
}

// Details about a Lambda function URL.
type FunctionUrlConfig struct {

	// The type of authentication that your function URL uses. Set to AWS_IAM if you
	// want to restrict access to authenticated users only. Set to NONE if you want to
	// bypass IAM authentication to create a public endpoint. For more information, see
	// [Security and auth model for Lambda function URLs].
	//
	// [Security and auth model for Lambda function URLs]: https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html
	//
	// This member is required.
	AuthType FunctionUrlAuthType

	// When the function URL was created, in [ISO-8601 format] (YYYY-MM-DDThh:mm:ss.sTZD).
	//
	// [ISO-8601 format]: https://www.w3.org/TR/NOTE-datetime
	//
	// This member is required.
	CreationTime *string

	// The Amazon Resource Name (ARN) of your function.
	//
	// This member is required.
	FunctionArn *string

	// The HTTP URL endpoint for your function.
	//
	// This member is required.
	FunctionUrl *string

	// When the function URL configuration was last updated, in [ISO-8601 format]
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	//
	// [ISO-8601 format]: https://www.w3.org/TR/NOTE-datetime
	//
	// This member is required.
	LastModifiedTime *string

	// The [cross-origin resource sharing (CORS)] settings for your function URL.
	//
	// [cross-origin resource sharing (CORS)]: https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS
	Cors *Cors

	// Use one of the following options:
	//
	//   - BUFFERED – This is the default option. Lambda invokes your function using
	//   the Invoke API operation. Invocation results are available when the payload is
	//   complete. The maximum payload size is 6 MB.
	//
	//   - RESPONSE_STREAM – Your function streams payload results as they become
	//   available. Lambda invokes your function using the InvokeWithResponseStream API
	//   operation. The maximum response payload size is 200 MB.
	InvokeMode InvokeMode

	noSmithyDocumentSerde
}

// Information about a function version that uses a specific capacity provider,
// including its ARN and current state.
type FunctionVersionsByCapacityProviderListItem struct {

	// The Amazon Resource Name (ARN) of the function version.
	//
	// This member is required.
	FunctionArn *string

	// The current state of the function version.
	//
	// This member is required.
	State State

	noSmithyDocumentSerde
}

// Configuration values that override the container image Dockerfile settings. For
// more information, see [Container image settings].
//
// [Container image settings]: https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms
type ImageConfig struct {

	// Specifies parameters that you want to pass in with ENTRYPOINT.
	Command []string

	// Specifies the entry point to their application, which is typically the location
	// of the runtime executable.
	EntryPoint []string

	// Specifies the working directory.
	WorkingDirectory *string

	noSmithyDocumentSerde
}

// Error response to GetFunctionConfiguration .
type ImageConfigError struct {

	// Error code.
	ErrorCode *string

	// Error message.
	Message *string

	noSmithyDocumentSerde
}

// Response to a GetFunctionConfiguration request.
type ImageConfigResponse struct {

	// Error response to GetFunctionConfiguration .
	Error *ImageConfigError

	// Configuration values that override the container image Dockerfile.
	ImageConfig *ImageConfig

	noSmithyDocumentSerde
}

// Specifications that define the characteristics and constraints for compute
// instances used by the capacity provider.
type InstanceRequirements struct {

	// A list of EC2 instance types that the capacity provider is allowed to use. If
	// not specified, all compatible instance types are allowed.
	AllowedInstanceTypes []string

	// A list of supported CPU architectures for compute instances. Valid values
	// include x86_64 and arm64 .
	Architectures []Architecture

	// A list of EC2 instance types that the capacity provider should not use, even if
	// they meet other requirements.
	ExcludedInstanceTypes []string

	noSmithyDocumentSerde
}

// Details about a function invocation that completed.
type InvocationCompletedDetails struct {

	// The date and time when the invocation ended, in [ISO-8601 format] (YYYY-MM-DDThh:mm:ss.sTZD).
	//
	// [ISO-8601 format]: https://www.w3.org/TR/NOTE-datetime
	//
	// This member is required.
	EndTimestamp *time.Time

	// The request ID for the invocation.
	//
	// This member is required.
	RequestId *string

	// The date and time when the invocation started, in [ISO-8601 format] (YYYY-MM-DDThh:mm:ss.sTZD).
	//
	// [ISO-8601 format]: https://www.w3.org/TR/NOTE-datetime
	//
	// This member is required.
	StartTimestamp *time.Time

	// Details about the invocation failure.
	Error *EventError

	noSmithyDocumentSerde
}

// A chunk of the streamed response payload.
type InvokeResponseStreamUpdate struct {

	// Data returned by your Lambda function.
	Payload []byte

	noSmithyDocumentSerde
}

// A response confirming that the event stream is complete.
type InvokeWithResponseStreamCompleteEvent struct {

	// An error code.
	ErrorCode *string

	// The details of any returned error.
	ErrorDetails *string

	// The last 4 KB of the execution log, which is base64-encoded.
	LogResult *string

	noSmithyDocumentSerde
}

// An object that includes a chunk of the response payload. When the stream has
// ended, Lambda includes a InvokeComplete object.
//
// The following types satisfy this interface:
//
//	InvokeWithResponseStreamResponseEventMemberInvokeComplete
//	InvokeWithResponseStreamResponseEventMemberPayloadChunk
type InvokeWithResponseStreamResponseEvent interface {
	isInvokeWithResponseStreamResponseEvent()
}

// An object that's returned when the stream has ended and all the payload chunks
// have been returned.
type InvokeWithResponseStreamResponseEventMemberInvokeComplete struct {
	Value InvokeWithResponseStreamCompleteEvent

	noSmithyDocumentSerde
}

func (*InvokeWithResponseStreamResponseEventMemberInvokeComplete) isInvokeWithResponseStreamResponseEvent() {
}

// A chunk of the streamed response payload.
type InvokeWithResponseStreamResponseEventMemberPayloadChunk struct {
	Value InvokeResponseStreamUpdate

	noSmithyDocumentSerde
}

func (*InvokeWithResponseStreamResponseEventMemberPayloadChunk) isInvokeWithResponseStreamResponseEvent() {
}

// Specific access configuration settings that tell Lambda how to authenticate
// with your schema registry.
//
// If you're working with an Glue schema registry, don't provide authentication
// details in this object. Instead, ensure that your execution role has the
// required permissions for Lambda to access your cluster.
//
// If you're working with a Confluent schema registry, choose the authentication
// method in the Type field, and provide the Secrets Manager secret ARN in the URI
// field.
type KafkaSchemaRegistryAccessConfig struct {

	//  The type of authentication Lambda uses to access your schema registry.
	Type KafkaSchemaRegistryAuthType

	//  The URI of the secret (Secrets Manager secret ARN) to authenticate with your
	// schema registry.
	URI *string

	noSmithyDocumentSerde
}

// Specific configuration settings for a Kafka schema registry.
type KafkaSchemaRegistryConfig struct {

	// An array of access configuration objects that tell Lambda how to authenticate
	// with your schema registry.
	AccessConfigs []KafkaSchemaRegistryAccessConfig

	// The record format that Lambda delivers to your function after schema validation.
	//
	//   - Choose JSON to have Lambda deliver the record to your function as a standard
	//   JSON object.
	//
	//   - Choose SOURCE to have Lambda deliver the record to your function in its
	//   original source format. Lambda removes all schema metadata, such as the schema
	//   ID, before sending the record to your function.
	EventRecordFormat SchemaRegistryEventRecordFormat

	// The URI for your schema registry. The correct URI format depends on the type of
	// schema registry you're using.
	//
	//   - For Glue schema registries, use the ARN of the registry.
	//
	//   - For Confluent schema registries, use the URL of the registry.
	SchemaRegistryURI *string

	// An array of schema validation configuration objects, which tell Lambda the
	// message attributes you want to validate and filter using your schema registry.
	SchemaValidationConfigs []KafkaSchemaValidationConfig

	noSmithyDocumentSerde
}

// Specific schema validation configuration settings that tell Lambda the message
// attributes you want to validate and filter using your schema registry.
type KafkaSchemaValidationConfig struct {

	//  The attributes you want your schema registry to validate and filter for. If
	// you selected JSON as the EventRecordFormat , Lambda also deserializes the
	// selected message attributes.
	Attribute KafkaSchemaValidationAttribute

	noSmithyDocumentSerde
}

// Configuration for Lambda-managed instances used by the capacity provider.
type LambdaManagedInstancesCapacityProviderConfig struct {

	// The Amazon Resource Name (ARN) of the capacity provider.
	//
	// This member is required.
	CapacityProviderArn *string

	// The amount of memory in GiB allocated per vCPU for execution environments.
	ExecutionEnvironmentMemoryGiBPerVCpu *float64

	// The maximum number of concurrent execution environments that can run on each
	// compute instance.
	PerExecutionEnvironmentMaxConcurrency *int32

	noSmithyDocumentSerde
}

// An [Lambda layer].
//
// [Lambda layer]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html
type Layer struct {

	// The Amazon Resource Name (ARN) of the function layer.
	Arn *string

	// The size of the layer archive in bytes.
	CodeSize int64

	// The Amazon Resource Name (ARN) of a signing job.
	SigningJobArn *string

	// The Amazon Resource Name (ARN) for a signing profile version.
	SigningProfileVersionArn *string

	noSmithyDocumentSerde
}

// Details about an [Lambda layer].
//
// [Lambda layer]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html
type LayersListItem struct {

	// The newest version of the layer.
	LatestMatchingVersion *LayerVersionsListItem

	// The Amazon Resource Name (ARN) of the function layer.
	LayerArn *string

	// The name of the layer.
	LayerName *string

	noSmithyDocumentSerde
}

// A ZIP archive that contains the contents of an [Lambda layer]. You can specify either an
// Amazon S3 location, or upload a layer archive directly.
//
// [Lambda layer]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html
type LayerVersionContentInput struct {

	// The Amazon S3 bucket of the layer archive.
	S3Bucket *string

	// The Amazon S3 key of the layer archive.
	S3Key *string

	// For versioned objects, the version of the layer archive object to use.
	S3ObjectVersion *string

	// The base64-encoded contents of the layer archive. Amazon Web Services SDK and
	// Amazon Web Services CLI clients handle the encoding for you.
	ZipFile []byte

	noSmithyDocumentSerde
}

// Details about a version of an [Lambda layer].
//
// [Lambda layer]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html
type LayerVersionContentOutput struct {

	// The SHA-256 hash of the layer archive.
	CodeSha256 *string

	// The size of the layer archive in bytes.
	CodeSize int64

	// A link to the layer archive in Amazon S3 that is valid for 10 minutes.
	Location *string

	// The Amazon Resource Name (ARN) of a signing job.
	SigningJobArn *string

	// The Amazon Resource Name (ARN) for a signing profile version.
	SigningProfileVersionArn *string

	noSmithyDocumentSerde
}

// Details about a version of an [Lambda layer].
//
// [Lambda layer]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html
type LayerVersionsListItem struct {

	// A list of compatible [instruction set architectures].
	//
	// [instruction set architectures]: https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html
	CompatibleArchitectures []Architecture

	// The layer's compatible runtimes.
	//
	// The following list includes deprecated runtimes. For more information, see [Runtime use after deprecation].
	//
	// For a list of all currently supported runtimes, see [Supported runtimes].
	//
	// [Runtime use after deprecation]: https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels
	// [Supported runtimes]: https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported
	CompatibleRuntimes []Runtime

	// The date that the version was created, in ISO 8601 format. For example,
	// 2018-11-27T15:10:45.123+0000 .
	CreatedDate *string

	// The description of the version.
	Description *string

	// The ARN of the layer version.
	LayerVersionArn *string

	// The layer's open-source license.
	LicenseInfo *string

	// The version number.
	Version int64

	noSmithyDocumentSerde
}

// The function's Amazon CloudWatch Logs configuration settings.
type LoggingConfig struct {

	// Set this property to filter the application logs for your function that Lambda
	// sends to CloudWatch. Lambda only sends application logs at the selected level of
	// detail and lower, where TRACE is the highest level and FATAL is the lowest.
	ApplicationLogLevel ApplicationLogLevel

	// The format in which Lambda sends your function's application and system logs to
	// CloudWatch. Select between plain text and structured JSON.
	LogFormat LogFormat

	// The name of the Amazon CloudWatch log group the function sends logs to. By
	// default, Lambda functions send logs to a default log group named
	// /aws/lambda/<function name> . To use a different log group, enter an existing
	// log group or enter a new log group name.
	LogGroup *string

	// Set this property to filter the system logs for your function that Lambda sends
	// to CloudWatch. Lambda only sends system logs at the selected level of detail and
	// lower, where DEBUG is the highest level and WARN is the lowest.
	SystemLogLevel SystemLogLevel

	noSmithyDocumentSerde
}

// A destination for events that failed processing. For more information, see [Adding a destination].
//
// [Adding a destination]: https://docs.aws.amazon.com/lambda/latest/dg/invocation-async-retain-records.html#invocation-async-destinations
type OnFailure struct {

	// The Amazon Resource Name (ARN) of the destination resource.
	//
	// To retain records of failed invocations from [Kinesis], [DynamoDB], [self-managed Apache Kafka], or [Amazon MSK], you can configure an
	// Amazon SNS topic, Amazon SQS queue, Amazon S3 bucket, or Kafka topic as the
	// destination.
	//
	// Amazon SNS destinations have a message size limit of 256 KB. If the combined
	// size of the function request and response payload exceeds the limit, Lambda will
	// drop the payload when sending OnFailure event to the destination. For details
	// on this behavior, refer to [Retaining records of asynchronous invocations].
	//
	// To retain records of failed invocations from [Kinesis], [DynamoDB], [self-managed Kafka] or [Amazon MSK], you can configure an
	// Amazon SNS topic, Amazon SQS queue, or Amazon S3 bucket as the destination.
	//
	// [Amazon MSK]: https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-onfailure-destination
	// [Retaining records of asynchronous invocations]: https://docs.aws.amazon.com/lambda/latest/dg/invocation-async-retain-records.html
	// [Kinesis]: https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html
	// [DynamoDB]: https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html
	// [self-managed Apache Kafka]: https://docs.aws.amazon.com/lambda/latest/dg/kafka-on-failure.html
	// [self-managed Kafka]: https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-smaa-onfailure-destination
	Destination *string

	noSmithyDocumentSerde
}

// A destination for events that were processed successfully.
//
// To retain records of successful [asynchronous invocations], you can configure an Amazon SNS topic, Amazon
// SQS queue, Lambda function, or Amazon EventBridge event bus as the destination.
//
// OnSuccess is not supported in CreateEventSourceMapping or
// UpdateEventSourceMapping requests.
//
// [asynchronous invocations]: https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations
type OnSuccess struct {

	// The Amazon Resource Name (ARN) of the destination resource.
	//
	// Amazon SNS destinations have a message size limit of 256 KB. If the combined
	// size of the function request and response payload exceeds the limit, Lambda will
	// drop the payload when sending OnFailure event to the destination. For details
	// on this behavior, refer to [Retaining records of asynchronous invocations].
	//
	// [Retaining records of asynchronous invocations]: https://docs.aws.amazon.com/lambda/latest/dg/invocation-async-retain-records.html
	Destination *string

	noSmithyDocumentSerde
}

// Information about an operation within a durable execution.
type Operation struct {

	// The unique identifier for this operation.
	//
	// This member is required.
	Id *string

	// The date and time when the operation started, in [ISO-8601 format] (YYYY-MM-DDThh:mm:ss.sTZD).
	//
	// [ISO-8601 format]: https://www.w3.org/TR/NOTE-datetime
	//
	// This member is required.
	StartTimestamp *time.Time

	// The current status of the operation.
	//
	// This member is required.
	Status OperationStatus

	// The type of operation.
	//
	// This member is required.
	Type OperationType

	// Contains details about a callback operation in a durable execution, including
	// the callback token and timeout configuration.
	CallbackDetails *CallbackDetails

	// Contains details about a chained function invocation in a durable execution,
	// including the target function and invocation parameters.
	ChainedInvokeDetails *ChainedInvokeDetails

	// Details about the context, if this operation represents a context.
	ContextDetails *ContextDetails

	// The date and time when the operation ended, in [ISO-8601 format] (YYYY-MM-DDThh:mm:ss.sTZD).
	//
	// [ISO-8601 format]: https://www.w3.org/TR/NOTE-datetime
	EndTimestamp *time.Time

	// Details about the execution, if this operation represents an execution.
	ExecutionDetails *ExecutionDetails

	// The customer-provided name for this operation.
	Name *string

	// The unique identifier of the parent operation, if this operation is running
	// within a child context.
	ParentId *string

	// Details about the step, if this operation represents a step.
	StepDetails *StepDetails

	// The subtype of the operation, providing additional categorization.
	SubType *string

	// Details about the wait operation, if this operation represents a wait.
	WaitDetails *WaitDetails

	noSmithyDocumentSerde
}

// An update to be applied to an operation during checkpointing.
type OperationUpdate struct {

	// The action to take on the operation.
	//
	// This member is required.
	Action OperationAction

	// The unique identifier for this operation.
	//
	// This member is required.
	Id *string

	// The type of operation to update.
	//
	// This member is required.
	Type OperationType

	// Configuration options for callback operations in durable executions, including
	// timeout settings and retry behavior.
	CallbackOptions *CallbackOptions

	// Configuration options for chained function invocations in durable executions,
	// including retry settings and timeout configuration.
	ChainedInvokeOptions *ChainedInvokeOptions

	// Options for context operations.
	ContextOptions *ContextOptions

	// The error information for failed operations.
	Error *ErrorObject

	// The customer-provided name for this operation.
	Name *string

	// The unique identifier of the parent operation, if this operation is running
	// within a child context.
	ParentId *string

	// The payload for successful operations.
	Payload *string

	// Options for step operations.
	StepOptions *StepOptions

	// The subtype of the operation, providing additional categorization.
	SubType *string

	// Options for wait operations.
	WaitOptions *WaitOptions

	noSmithyDocumentSerde
}

// Details about the provisioned concurrency configuration for a function alias or
// version.
type ProvisionedConcurrencyConfigListItem struct {

	// The amount of provisioned concurrency allocated. When a weighted alias is used
	// during linear and canary deployments, this value fluctuates depending on the
	// amount of concurrency that is provisioned for the function versions.
	AllocatedProvisionedConcurrentExecutions *int32

	// The amount of provisioned concurrency available.
	AvailableProvisionedConcurrentExecutions *int32

	// The Amazon Resource Name (ARN) of the alias or version.
	FunctionArn *string

	// The date and time that a user last updated the configuration, in [ISO 8601 format].
	//
	// [ISO 8601 format]: https://www.iso.org/iso-8601-date-and-time-format.html
	LastModified *string

	// The amount of provisioned concurrency requested.
	RequestedProvisionedConcurrentExecutions *int32

	// The status of the allocation process.
	Status ProvisionedConcurrencyStatusEnum

	// For failed allocations, the reason that provisioned concurrency could not be
	// allocated.
	StatusReason *string

	noSmithyDocumentSerde
}

// The [provisioned mode] configuration for the event source. Use Provisioned Mode to customize the
// minimum and maximum number of event pollers for your event source.
//
// [provisioned mode]: https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode
type ProvisionedPollerConfig struct {

	// The maximum number of event pollers this event source can scale up to. For
	// Amazon SQS events source mappings, default is 200, and minimum value allowed is
	// 2. For Amazon MSK and self-managed Apache Kafka event source mappings, default
	// is 200, and minimum value allowed is 1.
	MaximumPollers *int32

	// The minimum number of event pollers this event source can scale down to. For
	// Amazon SQS events source mappings, default is 2, and minimum 2 required. For
	// Amazon MSK and self-managed Apache Kafka event source mappings, default is 1.
	MinimumPollers *int32

	// (Amazon MSK and self-managed Apache Kafka) The name of the provisioned poller
	// group. Use this option to group multiple ESMs within the event source's VPC to
	// share Event Poller Unit (EPU) capacity. You can use this option to optimize
	// Provisioned mode costs for your ESMs. You can group up to 100 ESMs per poller
	// group and aggregate maximum pollers across all ESMs in a group cannot exceed
	// 2000.
	PollerGroupName *string

	noSmithyDocumentSerde
}

// Information about retry attempts for an operation.
type RetryDetails struct {

	// The current attempt number for this operation.
	CurrentAttempt int32

	// The delay before the next retry attempt, in seconds.
	NextAttemptDelaySeconds *int32

	noSmithyDocumentSerde
}

// The ARN of the runtime and any errors that occured.
type RuntimeVersionConfig struct {

	// Error response when Lambda is unable to retrieve the runtime version for a
	// function.
	Error *RuntimeVersionError

	// The ARN of the runtime version you want the function to use.
	RuntimeVersionArn *string

	noSmithyDocumentSerde
}

// Any error returned when the runtime version information for the function could
// not be retrieved.
type RuntimeVersionError struct {

	// The error code.
	ErrorCode *string

	// The error message.
	Message *string

	noSmithyDocumentSerde
}

// (Amazon SQS only) The scaling configuration for the event source. To remove the
// configuration, pass an empty value.
type ScalingConfig struct {

	// Limits the number of concurrent instances that the Amazon SQS event source can
	// invoke.
	MaximumConcurrency *int32

	noSmithyDocumentSerde
}

// The self-managed Apache Kafka cluster for your event source.
type SelfManagedEventSource struct {

	// The list of bootstrap servers for your Kafka brokers in the following format:
	// "KAFKA_BOOTSTRAP_SERVERS": ["abc.xyz.com:xxxx","abc2.xyz.com:xxxx"] .
	Endpoints map[string][]string

	noSmithyDocumentSerde
}

// Specific configuration settings for a self-managed Apache Kafka event source.
type SelfManagedKafkaEventSourceConfig struct {

	//  The identifier for the Kafka consumer group to join. The consumer group ID
	// must be unique among all your Kafka event sources. After creating a Kafka event
	// source mapping with the consumer group ID specified, you cannot update this
	// value. For more information, see [Customizable consumer group ID].
	//
	// [Customizable consumer group ID]: https://docs.aws.amazon.com/lambda/latest/dg/with-kafka-process.html#services-smaa-topic-add
	ConsumerGroupId *string

	// Specific configuration settings for a Kafka schema registry.
	SchemaRegistryConfig *KafkaSchemaRegistryConfig

	noSmithyDocumentSerde
}

// The function's [Lambda SnapStart] setting. Set ApplyOn to PublishedVersions to create a snapshot
// of the initialized execution environment when you publish a function version.
//
// [Lambda SnapStart]: https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html
type SnapStart struct {

	// Set to PublishedVersions to create a snapshot of the initialized execution
	// environment when you publish a function version.
	ApplyOn SnapStartApplyOn

	noSmithyDocumentSerde
}

// The function's [SnapStart] setting.
//
// [SnapStart]: https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html
type SnapStartResponse struct {

	// When set to PublishedVersions , Lambda creates a snapshot of the execution
	// environment when you publish a function version.
	ApplyOn SnapStartApplyOn

	// When you provide a [qualified Amazon Resource Name (ARN)], this response element indicates whether SnapStart is
	// activated for the specified function version.
	//
	// [qualified Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using
	OptimizationStatus SnapStartOptimizationStatus

	noSmithyDocumentSerde
}

// To secure and define access to your event source, you can specify the
// authentication protocol, VPC components, or virtual host.
type SourceAccessConfiguration struct {

	// The type of authentication protocol, VPC components, or virtual host for your
	// event source. For example: "Type":"SASL_SCRAM_512_AUTH" .
	//
	//   - BASIC_AUTH – (Amazon MQ) The Secrets Manager secret that stores your broker
	//   credentials.
	//
	//   - BASIC_AUTH – (Self-managed Apache Kafka) The Secrets Manager ARN of your
	//   secret key used for SASL/PLAIN authentication of your Apache Kafka brokers.
	//
	//   - VPC_SUBNET – (Self-managed Apache Kafka) The subnets associated with your
	//   VPC. Lambda connects to these subnets to fetch data from your self-managed
	//   Apache Kafka cluster.
	//
	//   - VPC_SECURITY_GROUP – (Self-managed Apache Kafka) The VPC security group used
	//   to manage access to your self-managed Apache Kafka brokers.
	//
	//   - SASL_SCRAM_256_AUTH – (Self-managed Apache Kafka) The Secrets Manager ARN of
	//   your secret key used for SASL SCRAM-256 authentication of your self-managed
	//   Apache Kafka brokers.
	//
	//   - SASL_SCRAM_512_AUTH – (Amazon MSK, Self-managed Apache Kafka) The Secrets
	//   Manager ARN of your secret key used for SASL SCRAM-512 authentication of your
	//   self-managed Apache Kafka brokers.
	//
	//   - VIRTUAL_HOST –- (RabbitMQ) The name of the virtual host in your RabbitMQ
	//   broker. Lambda uses this RabbitMQ host as the event source. This property cannot
	//   be specified in an UpdateEventSourceMapping API call.
	//
	//   - CLIENT_CERTIFICATE_TLS_AUTH – (Amazon MSK, self-managed Apache Kafka) The
	//   Secrets Manager ARN of your secret key containing the certificate chain (X.509
	//   PEM), private key (PKCS#8 PEM), and private key password (optional) used for
	//   mutual TLS authentication of your MSK/Apache Kafka brokers.
	//
	//   - SERVER_ROOT_CA_CERTIFICATE – (Self-managed Apache Kafka) The Secrets Manager
	//   ARN of your secret key containing the root CA certificate (X.509 PEM) used for
	//   TLS encryption of your Apache Kafka brokers.
	Type SourceAccessType

	// The value for your chosen configuration in Type . For example: "URI":
	// "arn:aws:secretsmanager:us-east-1:01234567890:secret:MyBrokerSecretName" .
	URI *string

	noSmithyDocumentSerde
}

// Details about a step operation.
type StepDetails struct {

	// The current attempt number for this step.
	Attempt int32

	// Details about the step failure.
	Error *ErrorObject

	// The date and time when the next attempt is scheduled, in [ISO-8601 format]
	// (YYYY-MM-DDThh:mm:ss.sTZD). Only populated when the step is in a pending state.
	//
	// [ISO-8601 format]: https://www.w3.org/TR/NOTE-datetime
	NextAttemptTimestamp *time.Time

	// The JSON response payload from the step operation.
	Result *string

	noSmithyDocumentSerde
}

// Details about a step that failed.
type StepFailedDetails struct {

	// Details about the step failure.
	//
	// This member is required.
	Error *EventError

	// Information about retry attempts for this step operation.
	//
	// This member is required.
	RetryDetails *RetryDetails

	noSmithyDocumentSerde
}

// Configuration options for a step operation.
type StepOptions struct {

	// The delay in seconds before the next retry attempt.
	NextAttemptDelaySeconds *int32

	noSmithyDocumentSerde
}

// Details about a step that has started.
type StepStartedDetails struct {
	noSmithyDocumentSerde
}

// Details about a step that succeeded.
type StepSucceededDetails struct {

	// The response payload from the successful operation.
	//
	// This member is required.
	Result *EventResult

	// Information about retry attempts for this step operation.
	//
	// This member is required.
	RetryDetails *RetryDetails

	noSmithyDocumentSerde
}

// An object that contains details about an error related to retrieving tags.
type TagsError struct {

	// The error code.
	//
	// This member is required.
	ErrorCode *string

	// The error message.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// A scaling policy for the capacity provider that automatically adjusts capacity
// to maintain a target value for a specific metric.
type TargetTrackingScalingPolicy struct {

	// The predefined metric type to track for scaling decisions.
	//
	// This member is required.
	PredefinedMetricType CapacityProviderPredefinedMetricType

	// The target value for the metric that the scaling policy attempts to maintain
	// through scaling actions.
	//
	// This member is required.
	TargetValue *float64

	noSmithyDocumentSerde
}

// Specifies the tenant isolation mode configuration for a Lambda function. This
// allows you to configure specific tenant isolation strategies for your function
// invocations. Tenant isolation configuration cannot be modified after function
// creation.
type TenancyConfig struct {

	// Tenant isolation mode allows for invocation to be sent to a corresponding
	// execution environment dedicated to a specific tenant ID.
	//
	// This member is required.
	TenantIsolationMode TenantIsolationMode

	noSmithyDocumentSerde
}

// Contains trace headers for the Lambda durable execution.
type TraceHeader struct {

	// The X-Ray trace header associated with the durable execution.
	XAmznTraceId *string

	noSmithyDocumentSerde
}

// The function's [X-Ray] tracing configuration. To sample and record incoming requests,
// set Mode to Active .
//
// [X-Ray]: https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html
type TracingConfig struct {

	// The tracing mode.
	Mode TracingMode

	noSmithyDocumentSerde
}

// The function's X-Ray tracing configuration.
type TracingConfigResponse struct {

	// The tracing mode.
	Mode TracingMode

	noSmithyDocumentSerde
}

// The VPC security groups and subnets that are attached to a Lambda function. For
// more information, see [Configuring a Lambda function to access resources in a VPC].
//
// [Configuring a Lambda function to access resources in a VPC]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html
type VpcConfig struct {

	// Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack
	// subnets.
	Ipv6AllowedForDualStack *bool

	// A list of VPC security group IDs.
	SecurityGroupIds []string

	// A list of VPC subnet IDs.
	SubnetIds []string

	noSmithyDocumentSerde
}

// The VPC security groups and subnets that are attached to a Lambda function.
type VpcConfigResponse struct {

	// Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack
	// subnets.
	Ipv6AllowedForDualStack *bool

	// A list of VPC security group IDs.
	SecurityGroupIds []string

	// A list of VPC subnet IDs.
	SubnetIds []string

	// The ID of the VPC.
	VpcId *string

	noSmithyDocumentSerde
}

// Details about a wait operation that was cancelled.
type WaitCancelledDetails struct {

	// Details about why the wait operation was cancelled.
	Error *EventError

	noSmithyDocumentSerde
}

// Details about a wait operation.
type WaitDetails struct {

	// The date and time when the wait operation is scheduled to complete, in [ISO-8601 format]
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	//
	// [ISO-8601 format]: https://www.w3.org/TR/NOTE-datetime
	ScheduledEndTimestamp *time.Time

	noSmithyDocumentSerde
}

// Specifies how long to pause the durable execution.
type WaitOptions struct {

	// The duration to wait, in seconds.
	WaitSeconds *int32

	noSmithyDocumentSerde
}

// Details about a wait operation that has started.
type WaitStartedDetails struct {

	// The duration to wait, in seconds.
	//
	// This member is required.
	Duration *int32

	// The date and time when the wait operation is scheduled to complete, in [ISO-8601 format]
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	//
	// [ISO-8601 format]: https://www.w3.org/TR/NOTE-datetime
	//
	// This member is required.
	ScheduledEndTimestamp *time.Time

	noSmithyDocumentSerde
}

// Details about a wait operation that succeeded.
type WaitSucceededDetails struct {

	// The wait duration, in seconds.
	Duration *int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isInvokeWithResponseStreamResponseEvent() {}
