// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Builds a bot, its intents, and its slot types into a specific locale. A bot can
// be built into multiple locales. At runtime the locale is used to choose a
// specific build of the bot.
func (c *Client) BuildBotLocale(ctx context.Context, params *BuildBotLocaleInput, optFns ...func(*Options)) (*BuildBotLocaleOutput, error) {
	if params == nil {
		params = &BuildBotLocaleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BuildBotLocale", params, optFns, c.addOperationBuildBotLocaleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BuildBotLocaleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BuildBotLocaleInput struct {

	// The identifier of the bot to build. The identifier is returned in the response
	// from the [CreateBot]operation.
	//
	// [CreateBot]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBot.html
	//
	// This member is required.
	BotId *string

	// The version of the bot to build. This can only be the draft version of the bot.
	//
	// This member is required.
	BotVersion *string

	// The identifier of the language and locale that the bot will be used in. The
	// string must match one of the supported locales. All of the intents, slot types,
	// and slots used in the bot must have the same locale. For more information, see [Supported languages].
	//
	// [Supported languages]: https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html
	//
	// This member is required.
	LocaleId *string

	noSmithyDocumentSerde
}

type BuildBotLocaleOutput struct {

	// The identifier of the specified bot.
	BotId *string

	// The bot's build status. When the status is ReadyExpressTesting you can test the
	// bot using the utterances defined for the intents and slot types. When the status
	// is Built , the bot is ready for use and can be tested using any utterance.
	BotLocaleStatus types.BotLocaleStatus

	// The version of the bot that was built. This is only the draft version of the
	// bot.
	BotVersion *string

	// A timestamp indicating the date and time that the bot was last built for this
	// locale.
	LastBuildSubmittedDateTime *time.Time

	// The language and locale specified of where the bot can be used.
	LocaleId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBuildBotLocaleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpBuildBotLocale{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpBuildBotLocale{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BuildBotLocale"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpBuildBotLocaleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBuildBotLocale(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBuildBotLocale(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BuildBotLocale",
	}
}
