// Code generated by smithy-go-codegen DO NOT EDIT.

package location

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/location/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// This operation is no longer current and may be deprecated in the future. We
// recommend you upgrade to the Places API V2 unless you require Grab data.
//
//   - CreatePlaceIndex is part of a previous Amazon Location Service Places API
//     (version 1) which has been superseded by a more intuitive, powerful, and
//     complete API (version 2).
//
//   - The Places API version 2 has a simplified interface that can be used
//     without creating or managing place index resources.
//
//   - If you are using an Amazon Web Services SDK or the Amazon Web Services CLI,
//     note that the Places API version 2 is found under geo-places or geo_places ,
//     not under location .
//
//   - Since Grab is not yet fully supported in Places API version 2, we recommend
//     you continue using API version 1 when using Grab.
//
//   - Start your version 2 API journey with the Places V2 API Referenceor the Developer Guide.
//
// Creates a place index resource in your Amazon Web Services account. Use a place
// index resource to geocode addresses and other text queries by using the
// SearchPlaceIndexForText operation, and reverse geocode coordinates by using the
// SearchPlaceIndexForPosition operation, and enable autosuggestions by using the
// SearchPlaceIndexForSuggestions operation.
//
// If your application is tracking or routing assets you use in your business,
// such as delivery vehicles or employees, you must not use Esri as your
// geolocation provider. See section 82 of the [Amazon Web Services service terms]for more details.
//
// [Amazon Web Services service terms]: http://aws.amazon.com/service-terms
func (c *Client) CreatePlaceIndex(ctx context.Context, params *CreatePlaceIndexInput, optFns ...func(*Options)) (*CreatePlaceIndexOutput, error) {
	if params == nil {
		params = &CreatePlaceIndexInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreatePlaceIndex", params, optFns, c.addOperationCreatePlaceIndexMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreatePlaceIndexOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreatePlaceIndexInput struct {

	// Specifies the geospatial data provider for the new place index.
	//
	// This field is case-sensitive. Enter the valid values as shown. For example,
	// entering HERE returns an error.
	//
	// Valid values include:
	//
	//   - Esri – For additional information about [Esri]'s coverage in your region of
	//   interest, see [Esri details on geocoding coverage].
	//
	//   - Grab – Grab provides place index functionality for Southeast Asia. For
	//   additional information about [GrabMaps]' coverage, see [GrabMaps countries and areas covered].
	//
	//   - Here – For additional information about [HERE Technologies]' coverage in your region of
	//   interest, see [HERE details on goecoding coverage].
	//
	// If you specify HERE Technologies ( Here ) as the data provider, you may not [store results]for
	//   locations in Japan. For more information, see the [Amazon Web Services service terms]for Amazon Location Service.
	//
	// For additional information , see [Data providers] on the Amazon Location Service developer
	// guide.
	//
	// [Esri]: https://docs.aws.amazon.com/location/previous/developerguide/esri.html
	// [Esri details on geocoding coverage]: https://developers.arcgis.com/rest/geocode/api-reference/geocode-coverage.htm
	// [Amazon Web Services service terms]: http://aws.amazon.com/service-terms/
	// [HERE Technologies]: https://docs.aws.amazon.com/location/previous/developerguide/HERE.html
	// [GrabMaps]: https://docs.aws.amazon.com/location/previous/developerguide/grab.html
	// [Data providers]: https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html
	// [GrabMaps countries and areas covered]: https://docs.aws.amazon.com/location/previous/developerguide/grab.html#grab-coverage-area
	// [store results]: https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html
	// [HERE details on goecoding coverage]: https://developer.here.com/documentation/geocoder/dev_guide/topics/coverage-geocoder.html
	//
	// This member is required.
	DataSource *string

	// The name of the place index resource.
	//
	// Requirements:
	//
	//   - Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods
	//   (.), and underscores (_).
	//
	//   - Must be a unique place index resource name.
	//
	//   - No spaces allowed. For example, ExamplePlaceIndex .
	//
	// This member is required.
	IndexName *string

	// Specifies the data storage option requesting Places.
	DataSourceConfiguration *types.DataSourceConfiguration

	// The optional description for the place index resource.
	Description *string

	// No longer used. If included, the only allowed value is RequestBasedUsage .
	//
	// Deprecated: Deprecated. If included, the only allowed value is
	// RequestBasedUsage.
	PricingPlan types.PricingPlan

	// Applies one or more tags to the place index resource. A tag is a key-value pair
	// that helps you manage, identify, search, and filter your resources.
	//
	// Format: "key" : "value"
	//
	// Restrictions:
	//
	//   - Maximum 50 tags per resource.
	//
	//   - Each tag key must be unique and must have exactly one associated value.
	//
	//   - Maximum key length: 128 Unicode characters in UTF-8.
	//
	//   - Maximum value length: 256 Unicode characters in UTF-8.
	//
	//   - Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
	//   characters: + - = . _ : / @
	//
	//   - Cannot use "aws:" as a prefix for a key.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreatePlaceIndexOutput struct {

	// The timestamp for when the place index resource was created in [ISO 8601] format:
	// YYYY-MM-DDThh:mm:ss.sssZ .
	//
	// [ISO 8601]: https://www.iso.org/iso-8601-date-and-time-format.html
	//
	// This member is required.
	CreateTime *time.Time

	// The Amazon Resource Name (ARN) for the place index resource. Used to specify a
	// resource across Amazon Web Services.
	//
	//   - Format example: arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex
	//
	// This member is required.
	IndexArn *string

	// The name for the place index resource.
	//
	// This member is required.
	IndexName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreatePlaceIndexMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreatePlaceIndex{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreatePlaceIndex{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreatePlaceIndex"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opCreatePlaceIndexMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreatePlaceIndexValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreatePlaceIndex(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opCreatePlaceIndexMiddleware struct {
}

func (*endpointPrefix_opCreatePlaceIndexMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opCreatePlaceIndexMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "cp.places." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opCreatePlaceIndexMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opCreatePlaceIndexMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opCreatePlaceIndex(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreatePlaceIndex",
	}
}
