// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Metadata assigned to an allocation. Each tag is made up of a key and a value .
type Tag struct {

	// One part of a key-value pair that makes up a tag . A key is a label that acts
	// like a category for the specific tag values.
	//
	// This member is required.
	Key *string

	// One part of a key-value pair that makes up a tag . A value acts as a descriptor
	// within a tag category (key). The value can be empty or null.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Usage allocations allow you to split usage into buckets by tags.
//
// Each UsageAllocation indicates the usage quantity for a specific set of tags.
type UsageAllocation struct {

	// The total quantity allocated to this bucket of usage.
	//
	// This member is required.
	AllocatedUsageQuantity *int32

	// The set of tags that define the bucket of usage. For the bucket of items with
	// no tags, this parameter can be left out.
	Tags []Tag

	noSmithyDocumentSerde
}

// A UsageRecord indicates a quantity of usage for a given product, customer,
// dimension and time.
//
// Multiple requests with the same UsageRecords as input will be de-duplicated to
// prevent double charges.
type UsageRecord struct {

	// During the process of registering a product on Amazon Web Services Marketplace,
	// dimensions are specified. These represent different units of value in your
	// application.
	//
	// This member is required.
	Dimension *string

	// Timestamp, in UTC, for which the usage is being reported.
	//
	// Your application can meter usage for up to six hours in the past. Make sure the
	// timestamp value is not before the start of the software usage.
	//
	// This member is required.
	Timestamp *time.Time

	//  The CustomerAWSAccountID parameter specifies the AWS account ID of the buyer.
	CustomerAWSAccountId *string

	// The CustomerIdentifier is obtained through the ResolveCustomer operation and
	// represents an individual buyer in your application.
	CustomerIdentifier *string

	// The quantity of usage consumed by the customer for the given dimension and
	// time. Defaults to 0 if not specified.
	Quantity *int32

	// The set of UsageAllocations to submit. The sum of all UsageAllocation
	// quantities must equal the Quantity of the UsageRecord .
	UsageAllocations []UsageAllocation

	noSmithyDocumentSerde
}

// A UsageRecordResult indicates the status of a given UsageRecord processed by
// BatchMeterUsage .
type UsageRecordResult struct {

	// The MeteringRecordId is a unique identifier for this metering event.
	MeteringRecordId *string

	// The UsageRecordResult Status indicates the status of an individual UsageRecord
	// processed by BatchMeterUsage .
	//
	//   - Success- The UsageRecord was accepted and honored by BatchMeterUsage .
	//
	//   - CustomerNotSubscribed- The CustomerIdentifier specified is not able to use
	//   your product. The UsageRecord was not honored. There are three causes for this
	//   result:
	//
	//   - The customer identifier is invalid.
	//
	//   - The customer identifier provided in the metering record does not have an
	//   active agreement or subscription with this product. Future UsageRecords for
	//   this customer will fail until the customer subscribes to your product.
	//
	//   - The customer's Amazon Web Services account was suspended.
	//
	//   - DuplicateRecord- Indicates that the UsageRecord was invalid and not honored.
	//   A previously metered UsageRecord had the same customer, dimension, and time,
	//   but a different quantity.
	Status UsageRecordResultStatus

	// The UsageRecord that was part of the BatchMeterUsage request.
	UsageRecord *UsageRecord

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
