// Code generated by smithy-go-codegen DO NOT EDIT.

package medialive

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/medialive/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Change the settings for a ChannelPlacementGroup.
func (c *Client) UpdateChannelPlacementGroup(ctx context.Context, params *UpdateChannelPlacementGroupInput, optFns ...func(*Options)) (*UpdateChannelPlacementGroupOutput, error) {
	if params == nil {
		params = &UpdateChannelPlacementGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateChannelPlacementGroup", params, optFns, c.addOperationUpdateChannelPlacementGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateChannelPlacementGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// A request to update the channel placement group
type UpdateChannelPlacementGroupInput struct {

	// The ID of the channel placement group.
	//
	// This member is required.
	ChannelPlacementGroupId *string

	// The ID of the cluster.
	//
	// This member is required.
	ClusterId *string

	// Include this parameter only if you want to change the current name of the
	// ChannelPlacementGroup. Specify a name that is unique in the Cluster. You can't
	// change the name. Names are case-sensitive.
	Name *string

	// Include this parameter only if you want to change the list of Nodes that are
	// associated with the ChannelPlacementGroup.
	Nodes []string

	noSmithyDocumentSerde
}

// Placeholder documentation for UpdateChannelPlacementGroupResponse
type UpdateChannelPlacementGroupOutput struct {

	// The ARN of this ChannelPlacementGroup. It is automatically assigned when the
	// ChannelPlacementGroup is created.
	Arn *string

	// Used in ListChannelPlacementGroupsResult
	Channels []string

	// The ID of the Cluster that the Node belongs to.
	ClusterId *string

	// The ID of the ChannelPlacementGroup. Unique in the AWS account. The ID is the
	// resource-id portion of the ARN.
	Id *string

	// The name that you specified for the ChannelPlacementGroup.
	Name *string

	// An array with one item, which is the single Node that is associated with the
	// ChannelPlacementGroup.
	Nodes []string

	// The current state of the ChannelPlacementGroup.
	State types.ChannelPlacementGroupState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateChannelPlacementGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateChannelPlacementGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateChannelPlacementGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateChannelPlacementGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateChannelPlacementGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateChannelPlacementGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateChannelPlacementGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateChannelPlacementGroup",
	}
}
