// Code generated by smithy-go-codegen DO NOT EDIT.

package mpa

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deletes an inactive approval team. For more information, see [Team health] in the
// Multi-party approval User Guide.
//
// You can also use this operation to delete a team draft. For more information,
// see [Interacting with drafts]in the Multi-party approval User Guide.
//
// [Team health]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html
// [Interacting with drafts]: https://docs.aws.amazon.com/mpa/latest/userguide/update-team.html#update-team-draft-status
func (c *Client) DeleteInactiveApprovalTeamVersion(ctx context.Context, params *DeleteInactiveApprovalTeamVersionInput, optFns ...func(*Options)) (*DeleteInactiveApprovalTeamVersionOutput, error) {
	if params == nil {
		params = &DeleteInactiveApprovalTeamVersionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteInactiveApprovalTeamVersion", params, optFns, c.addOperationDeleteInactiveApprovalTeamVersionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteInactiveApprovalTeamVersionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteInactiveApprovalTeamVersionInput struct {

	// Amaazon Resource Name (ARN) for the team.
	//
	// This member is required.
	Arn *string

	// Version ID for the team.
	//
	// This member is required.
	VersionId *string

	noSmithyDocumentSerde
}

type DeleteInactiveApprovalTeamVersionOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteInactiveApprovalTeamVersionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDeleteInactiveApprovalTeamVersion{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDeleteInactiveApprovalTeamVersion{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteInactiveApprovalTeamVersion"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDeleteInactiveApprovalTeamVersionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteInactiveApprovalTeamVersion(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteInactiveApprovalTeamVersion(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteInactiveApprovalTeamVersion",
	}
}
