// Code generated by smithy-go-codegen DO NOT EDIT.

package mpa

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mpa/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns details for an approval team.
func (c *Client) GetApprovalTeam(ctx context.Context, params *GetApprovalTeamInput, optFns ...func(*Options)) (*GetApprovalTeamOutput, error) {
	if params == nil {
		params = &GetApprovalTeamInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetApprovalTeam", params, optFns, c.addOperationGetApprovalTeamMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetApprovalTeamOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetApprovalTeamInput struct {

	// Amazon Resource Name (ARN) for the team.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

type GetApprovalTeamOutput struct {

	// An ApprovalStrategyResponse object. Contains details for how the team grants
	// approval.
	ApprovalStrategy types.ApprovalStrategyResponse

	// An array of GetApprovalTeamResponseApprover  objects. Contains details for the
	// approvers in the team.
	Approvers []types.GetApprovalTeamResponseApprover

	// Amazon Resource Name (ARN) for the team.
	Arn *string

	// Timestamp when the team was created.
	CreationTime *time.Time

	// Description for the team.
	Description *string

	// Timestamp when the team was last updated.
	LastUpdateTime *time.Time

	// Name of the approval team.
	Name *string

	// Total number of approvers in the team.
	NumberOfApprovers *int32

	// A PendingUpdate object. Contains details for the pending updates for the team,
	// if applicable.
	PendingUpdate *types.PendingUpdate

	// An array of PolicyReference objects. Contains a list of policies that define
	// the permissions for team resources.
	//
	// The protected operation for a service integration might require specific
	// permissions. For more information, see [How other services work with Multi-party approval]in the Multi-party approval User Guide.
	//
	// [How other services work with Multi-party approval]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html
	Policies []types.PolicyReference

	// Status for the team. For more information, see [Team health] in the Multi-party approval
	// User Guide.
	//
	// [Team health]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html
	Status types.ApprovalTeamStatus

	// Status code for the approval team. For more information, see [Team health] in the
	// Multi-party approval User Guide.
	//
	// [Team health]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html
	StatusCode types.ApprovalTeamStatusCode

	// Message describing the status for the team.
	StatusMessage *string

	// Amazon Resource Name (ARN) for the session.
	UpdateSessionArn *string

	// Version ID for the team.
	VersionId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetApprovalTeamMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetApprovalTeam{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetApprovalTeam{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetApprovalTeam"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetApprovalTeamValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetApprovalTeam(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetApprovalTeam(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetApprovalTeam",
	}
}
