// Code generated by smithy-go-codegen DO NOT EDIT.

package mwaaserverless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mwaaserverless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves detailed information about a specific task instance within a workflow
// run. Task instances represent individual tasks that are executed as part of a
// workflow in the Amazon Managed Workflows for Apache Airflow Serverless
// environment. Each task instance runs in an isolated ECS container with dedicated
// resources and security boundaries. The service tracks task execution state,
// retry attempts, and provides detailed timing and error information for
// troubleshooting and monitoring purposes.
func (c *Client) GetTaskInstance(ctx context.Context, params *GetTaskInstanceInput, optFns ...func(*Options)) (*GetTaskInstanceOutput, error) {
	if params == nil {
		params = &GetTaskInstanceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetTaskInstance", params, optFns, c.addOperationGetTaskInstanceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetTaskInstanceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetTaskInstanceInput struct {

	// The unique identifier of the workflow run that contains the task instance.
	//
	// This member is required.
	RunId *string

	// The unique identifier of the task instance to retrieve.
	//
	// This member is required.
	TaskInstanceId *string

	// The Amazon Resource Name (ARN) of the workflow that contains the task instance.
	//
	// This member is required.
	WorkflowArn *string

	noSmithyDocumentSerde
}

type GetTaskInstanceOutput struct {

	// The unique identifier of the workflow run that contains this task instance.
	//
	// This member is required.
	RunId *string

	// The unique identifier of this task instance.
	//
	// This member is required.
	TaskInstanceId *string

	// The Amazon Resource Name (ARN) of the workflow that contains this task instance.
	//
	// This member is required.
	WorkflowArn *string

	// The attempt number for this task instance.
	AttemptNumber *int32

	// The duration of the task instance execution in seconds. This value is null if
	// the task is not complete.
	DurationInSeconds *int32

	// The timestamp when the task instance completed execution, in ISO 8601 date-time
	// format. This value is null if the task is not complete.
	EndedAt *time.Time

	// The error message if the task instance failed. This value is null if the task
	// completed successfully.
	ErrorMessage *string

	// The CloudWatch log stream name for this task instance execution.
	LogStream *string

	// The timestamp when the task instance was last modified, in ISO 8601 date-time
	// format.
	ModifiedAt *time.Time

	// The name of the Apache Airflow operator used for this task instance.
	OperatorName *string

	// The timestamp when the task instance started execution, in ISO 8601 date-time
	// format. This value is null if the task has not started.
	StartedAt *time.Time

	// The current status of the task instance.
	Status types.TaskInstanceStatus

	// The unique identifier of the task definition within the workflow.
	TaskId *string

	// The version of the workflow that contains this task instance.
	WorkflowVersion *string

	// Cross-communication data exchanged between tasks in the workflow execution.
	Xcom map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetTaskInstanceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetTaskInstance{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetTaskInstance{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetTaskInstance"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetTaskInstanceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetTaskInstance(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetTaskInstance(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetTaskInstance",
	}
}
