// Code generated by smithy-go-codegen DO NOT EDIT.

package mwaaserverless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mwaaserverless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all versions of a specified workflow, with optional pagination support.
func (c *Client) ListWorkflowVersions(ctx context.Context, params *ListWorkflowVersionsInput, optFns ...func(*Options)) (*ListWorkflowVersionsOutput, error) {
	if params == nil {
		params = &ListWorkflowVersionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListWorkflowVersions", params, optFns, c.addOperationListWorkflowVersionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListWorkflowVersionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListWorkflowVersionsInput struct {

	// The Amazon Resource Name (ARN) of the workflow for which you want to list
	// versions.
	//
	// This member is required.
	WorkflowArn *string

	// The maximum number of workflow versions to return in a single response.
	MaxResults *int32

	// The pagination token you need to use to retrieve the next set of results. This
	// value is returned from a previous call to ListWorkflowVersions .
	NextToken *string

	noSmithyDocumentSerde
}

type ListWorkflowVersionsOutput struct {

	// The pagination token you need to use to retrieve the next set of results. This
	// value is null if there are no more results.
	NextToken *string

	// A list of workflow version summaries for the specified workflow.
	WorkflowVersions []types.WorkflowVersionSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListWorkflowVersionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListWorkflowVersions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListWorkflowVersions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListWorkflowVersions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListWorkflowVersionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListWorkflowVersions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListWorkflowVersionsPaginatorOptions is the paginator options for
// ListWorkflowVersions
type ListWorkflowVersionsPaginatorOptions struct {
	// The maximum number of workflow versions to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListWorkflowVersionsPaginator is a paginator for ListWorkflowVersions
type ListWorkflowVersionsPaginator struct {
	options   ListWorkflowVersionsPaginatorOptions
	client    ListWorkflowVersionsAPIClient
	params    *ListWorkflowVersionsInput
	nextToken *string
	firstPage bool
}

// NewListWorkflowVersionsPaginator returns a new ListWorkflowVersionsPaginator
func NewListWorkflowVersionsPaginator(client ListWorkflowVersionsAPIClient, params *ListWorkflowVersionsInput, optFns ...func(*ListWorkflowVersionsPaginatorOptions)) *ListWorkflowVersionsPaginator {
	if params == nil {
		params = &ListWorkflowVersionsInput{}
	}

	options := ListWorkflowVersionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListWorkflowVersionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListWorkflowVersionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListWorkflowVersions page.
func (p *ListWorkflowVersionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListWorkflowVersionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListWorkflowVersions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListWorkflowVersionsAPIClient is a client that implements the
// ListWorkflowVersions operation.
type ListWorkflowVersionsAPIClient interface {
	ListWorkflowVersions(context.Context, *ListWorkflowVersionsInput, ...func(*Options)) (*ListWorkflowVersionsOutput, error)
}

var _ ListWorkflowVersionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListWorkflowVersions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListWorkflowVersions",
	}
}
