// Code generated by smithy-go-codegen DO NOT EDIT.

package mwaaserverless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mwaaserverless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Stops a running workflow execution. This operation terminates all running tasks
// and prevents new tasks from starting. Amazon Managed Workflows for Apache
// Airflow Serverless gracefully shuts down the workflow execution by stopping task
// scheduling and terminating active ECS worker containers. The operation
// transitions the workflow run to a STOPPING state and then to STOPPED once all
// cleanup is complete. In-flight tasks may complete or be terminated depending on
// their current execution state.
func (c *Client) StopWorkflowRun(ctx context.Context, params *StopWorkflowRunInput, optFns ...func(*Options)) (*StopWorkflowRunOutput, error) {
	if params == nil {
		params = &StopWorkflowRunInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StopWorkflowRun", params, optFns, c.addOperationStopWorkflowRunMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StopWorkflowRunOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StopWorkflowRunInput struct {

	// The unique identifier of the workflow run to stop.
	//
	// This member is required.
	RunId *string

	// The Amazon Resource Name (ARN) of the workflow that contains the run you want
	// to stop.
	//
	// This member is required.
	WorkflowArn *string

	noSmithyDocumentSerde
}

type StopWorkflowRunOutput struct {

	// The unique identifier of the stopped workflow run.
	RunId *string

	// The status of the workflow run after the stop operation. This is typically
	// STOPPING or STOPPED .
	Status types.WorkflowRunStatus

	// The Amazon Resource Name (ARN) of the workflow that contains the stopped run.
	WorkflowArn *string

	// The version of the workflow that was stopped.
	WorkflowVersion *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStopWorkflowRunMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpStopWorkflowRun{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpStopWorkflowRun{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StopWorkflowRun"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStopWorkflowRunValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStopWorkflowRun(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStopWorkflowRun(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StopWorkflowRun",
	}
}
