// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Specifies the Amazon S3 location of a workflow definition file. This structure
// contains the bucket name, object key, and optional version ID for the workflow
// definition. Amazon Managed Workflows for Apache Airflow Serverless takes a
// snapshot of the definition file at the time of workflow creation or update,
// ensuring that the workflow behavior remains consistent even if the source file
// is modified. The definition must be a valid YAML file that uses supported Amazon
// Web Services operators and Amazon Managed Workflows for Apache Airflow
// Serverless syntax.
type DefinitionS3Location struct {

	// The name of the Amazon S3 bucket that contains the workflow definition file.
	//
	// This member is required.
	Bucket *string

	// The key (name) of the workflow definition file within the S3 bucket.
	//
	// This member is required.
	ObjectKey *string

	// Optional. The version ID of the workflow definition file in Amazon S3. If not
	// specified, the latest version is used.
	VersionId *string

	noSmithyDocumentSerde
}

// Configuration for encrypting workflow data at rest and in transit. Amazon
// Managed Workflows for Apache Airflow Serverless provides comprehensive
// encryption capabilities to protect sensitive workflow data, parameters, and
// execution logs. When using customer-managed keys, the service integrates with
// Amazon Web Services KMS to provide fine-grained access control and audit
// capabilities. Encryption is applied consistently across the distributed
// execution environment including task containers, metadata storage, and log
// streams.
type EncryptionConfiguration struct {

	// The type of encryption to use. Values are AWS_MANAGED_KEY (Amazon Web Services
	// manages the encryption key) or CUSTOMER_MANAGED_KEY (you provide a KMS key).
	//
	// This member is required.
	Type EncryptionType

	// The ID or ARN of the Amazon Web Services KMS key to use for encryption.
	// Required when Type is CUSTOMER_MANAGED_KEY .
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Configuration for workflow logging that specifies where you should store your
// workflow execution logs. Amazon Managed Workflows for Apache Airflow Serverless
// provides comprehensive logging capabilities that capture workflow execution
// details, task-level information, and system events. Logs are automatically
// exported to your specified CloudWatch log group using remote logging
// functionality, providing centralized observability across the distributed,
// multi-tenant execution environment. This enables effective debugging,
// monitoring, and compliance auditing of workflow executions.
type LoggingConfiguration struct {

	// The name of the CloudWatch log group where workflow execution logs are stored.
	//
	// This member is required.
	LogGroupName *string

	noSmithyDocumentSerde
}

// Network configuration for workflow execution. Specifies VPC security groups and
// subnets for secure network access. When provided, Amazon Managed Workflows for
// Apache Airflow Serverless deploys ECS worker tasks in your specified VPC
// configuration, enabling secure access to VPC-only resources. The service uses a
// proxy API container architecture where one container handles external
// communication while the worker container connects to your VPC for task
// execution. This design provides both security isolation and connectivity
// flexibility.
type NetworkConfiguration struct {

	// A list of VPC security group IDs to associate with the workflow execution
	// environment.
	SecurityGroupIds []string

	// A list of VPC subnet IDs where the workflow execution environment is deployed.
	SubnetIds []string

	noSmithyDocumentSerde
}

// Summary information about a workflow run's execution details, including status
// and timing information.
type RunDetailSummary struct {

	// The timestamp when the workflow run was created, in ISO 8601 date-time format.
	CreatedOn *time.Time

	// The timestamp when the workflow run completed execution, in ISO 8601 date-time
	// format. This value is null if the run is not complete.
	EndedAt *time.Time

	// The timestamp when the workflow run started execution, in ISO 8601 date-time
	// format.
	StartedAt *time.Time

	// The current status of the workflow run.
	Status WorkflowRunStatus

	noSmithyDocumentSerde
}

// The configuration to use to schedule automated workflow execution using cron
// expressions. Amazon Managed Workflows for Apache Airflow Serverless integrates
// with EventBridge Scheduler to provide cost-effective, timezone-aware scheduling
// capabilities. The service supports both time-based and event-based scheduling
// (event-based scheduling available post-GA). When a workflow definition includes
// scheduling information, Amazon Managed Workflows for Apache Airflow Serverless
// automatically configures the appropriate triggers and ensures only one version
// of a workflow has an active schedule at any time.
type ScheduleConfiguration struct {

	// A cron expression that defines when the workflow is automatically executed.
	// Uses standard cron syntax.
	CronExpression *string

	noSmithyDocumentSerde
}

// Summary information about a task instance within a workflow run, including its
// status and execution details.
type TaskInstanceSummary struct {

	// The duration of the task instance execution in seconds. This value is null if
	// the task is not complete.
	DurationInSeconds *int32

	// The name of the Apache Airflow operator used for this task instance.
	OperatorName *string

	// The unique identifier of the workflow run that contains this task instance.
	RunId *string

	// The current status of the task instance.
	Status TaskInstanceStatus

	// The unique identifier of this task instance.
	TaskInstanceId *string

	// The Amazon Resource Name (ARN) of the workflow that contains this task instance.
	WorkflowArn *string

	// The version of the workflow that contains this task instance.
	WorkflowVersion *string

	noSmithyDocumentSerde
}

// Contains information about a field that failed validation, including the field
// name and a descriptive error message.
type ValidationExceptionField struct {

	// A message that describes why the field failed validation.
	//
	// This member is required.
	Message *string

	// The name of the field that failed validation.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Detailed information about a workflow run execution, including timing, status,
// error information, and associated task instances. This structure provides
// comprehensive visibility into the workflow execution lifecycle within the Amazon
// Managed Workflows for Apache Airflow Serverless serverless environment. The
// service tracks execution across distributed ECS worker tasks and provides
// detailed timing information, error diagnostics, and task instance relationships
// to support effective monitoring and troubleshooting of complex workflow
// executions.
type WorkflowRunDetail struct {

	// The timestamp when the workflow run completed execution, in ISO 8601 date-time
	// format. This value is null if the run is not complete.
	CompletedOn *time.Time

	// The timestamp when the workflow run was created, in ISO 8601 date-time format.
	CreatedAt *time.Time

	// The total duration of the workflow run execution in seconds. This value is null
	// if the run is not complete.
	Duration *int32

	// The error message if the workflow run failed. This value is null if the run
	// completed successfully.
	ErrorMessage *string

	// The timestamp when the workflow run was last modified, in ISO 8601 date-time
	// format.
	ModifiedAt *time.Time

	// The unique identifier of this workflow run.
	RunId *string

	// The current execution state of the workflow run.
	RunState WorkflowRunStatus

	// The type of workflow run.
	RunType RunType

	// The timestamp when the workflow run started execution, in ISO 8601 date-time
	// format.
	StartedOn *time.Time

	// A list of task instance IDs that are part of this workflow run.
	TaskInstances []string

	// The Amazon Resource Name (ARN) of the workflow that contains this run.
	WorkflowArn *string

	// The version of the workflow used for this run.
	WorkflowVersion *string

	noSmithyDocumentSerde
}

// Summary information about a workflow run, including basic identification and
// status information.
type WorkflowRunSummary struct {

	// Summary details about the workflow run execution.
	RunDetailSummary *RunDetailSummary

	// The unique identifier of the workflow run.
	RunId *string

	// The type of workflow run.
	RunType RunType

	// The Amazon Resource Name (ARN) of the workflow that contains this run.
	WorkflowArn *string

	// The version of the workflow used for this run.
	WorkflowVersion *string

	noSmithyDocumentSerde
}

// Summary information about a workflow, including basic identification and
// metadata.
type WorkflowSummary struct {

	// The Amazon Resource Name (ARN) of the workflow.
	//
	// This member is required.
	WorkflowArn *string

	// The timestamp when the workflow was created, in ISO 8601 date-time format.
	CreatedAt *time.Time

	// The description of the workflow.
	Description *string

	// The timestamp when the workflow was last modified, in ISO 8601 date-time format.
	ModifiedAt *time.Time

	// The name of the workflow.
	Name *string

	// The trigger mode for the workflow execution.
	TriggerMode *string

	// The current status of the workflow.
	WorkflowStatus WorkflowStatus

	// The version identifier of the workflow.
	WorkflowVersion *string

	noSmithyDocumentSerde
}

// Summary information about a workflow version, including identification and
// configuration details.
type WorkflowVersionSummary struct {

	// The Amazon Resource Name (ARN) of the workflow that contains this version.
	//
	// This member is required.
	WorkflowArn *string

	// The version identifier of the workflow version.
	//
	// This member is required.
	WorkflowVersion *string

	// The timestamp when the workflow version was created, in ISO 8601 date-time
	// format.
	CreatedAt *time.Time

	// The Amazon S3 location of the workflow definition file for this version.
	DefinitionS3Location *DefinitionS3Location

	// Boolean flag that indicates whether this is the latest version of the workflow.
	IsLatestVersion *bool

	// The timestamp when the workflow version was last modified, in ISO 8601
	// date-time format.
	ModifiedAt *time.Time

	// The schedule configuration for this workflow version.
	ScheduleConfiguration *ScheduleConfiguration

	// The trigger mode for the workflow execution.
	TriggerMode *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
