// Code generated by smithy-go-codegen DO NOT EDIT.

package neptunegraph

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/neptunegraph/types"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"strconv"
	"time"
)

// Retrieves a specified import task.
func (c *Client) GetImportTask(ctx context.Context, params *GetImportTaskInput, optFns ...func(*Options)) (*GetImportTaskOutput, error) {
	if params == nil {
		params = &GetImportTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetImportTask", params, optFns, c.addOperationGetImportTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetImportTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetImportTaskInput struct {

	// The unique identifier of the import task.
	//
	// This member is required.
	TaskIdentifier *string

	noSmithyDocumentSerde
}

func (in *GetImportTaskInput) bindEndpointParams(p *EndpointParameters) {

	p.ApiType = ptr.String("ControlPlane")
}

type GetImportTaskOutput struct {

	// The ARN of the IAM role that will allow access to the data that is to be
	// imported.
	//
	// This member is required.
	RoleArn *string

	// A URL identifying to the location of the data to be imported. This can be an
	// Amazon S3 path, or can point to a Neptune database endpoint or snapshot
	//
	// This member is required.
	Source *string

	// The status of the import task:
	//
	//   - INITIALIZING – The necessary resources needed to create the graph are being
	//   prepared.
	//
	//   - ANALYZING_DATA – The data is being analyzed to determine the optimal
	//   infrastructure configuration for the new graph.
	//
	//   - RE_PROVISIONING – The data did not fit into the provisioned graph, so it is
	//   being re-provisioned with more capacity.
	//
	//   - IMPORTING – The data is being loaded.
	//
	//   - ERROR_ENCOUNTERED – An error has been encountered while trying to create
	//   the graph and import the data.
	//
	//   - ERROR_ENCOUNTERED_ROLLING_BACK – Because of the error that was encountered,
	//   the graph is being rolled back and all its resources released.
	//
	//   - SUCCEEDED – Graph creation and data loading succeeded.
	//
	//   - FAILED – Graph creation or data loading failed. When the status is FAILED ,
	//   you can use get-graphs to get more information about the state of the graph.
	//
	//   - CANCELLING – Because you cancelled the import task, cancellation is in
	//   progress.
	//
	//   - CANCELLED – You have successfully cancelled the import task.
	//
	// This member is required.
	Status types.ImportTaskStatus

	// The unique identifier of the import task.
	//
	// This member is required.
	TaskId *string

	// The number of the current attempts to execute the import task.
	AttemptNumber *int32

	// Specifies the format of S3 data to be imported. Valid values are CSV , which
	// identifies the [Gremlin CSV format]or OPENCYPHER , which identies the [openCypher load format].
	//
	// [Gremlin CSV format]: https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html
	// [openCypher load format]: https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html
	Format types.Format

	// The unique identifier of the Neptune Analytics graph.
	GraphId *string

	// Contains options for controlling the import process. For example, if the
	// failOnError key is set to false , the import skips problem data and attempts to
	// continue (whereas if set to true , the default, or if omitted, the import
	// operation halts immediately when an error is encountered.
	ImportOptions types.ImportOptions

	// Contains details about the specified import task.
	ImportTaskDetails *types.ImportTaskDetails

	// The parquet type of the import task.
	ParquetType types.ParquetType

	// The reason that the import task has this status value.
	StatusReason *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetImportTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetImportTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetImportTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetImportTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetImportTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetImportTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ImportTaskSuccessfulWaiterOptions are waiter options for
// ImportTaskSuccessfulWaiter
type ImportTaskSuccessfulWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// ImportTaskSuccessfulWaiter will use default minimum delay of 60 seconds. Note
	// that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, ImportTaskSuccessfulWaiter will use default max delay of 28800
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetImportTaskInput, *GetImportTaskOutput, error) (bool, error)
}

// ImportTaskSuccessfulWaiter defines the waiters for ImportTaskSuccessful
type ImportTaskSuccessfulWaiter struct {
	client GetImportTaskAPIClient

	options ImportTaskSuccessfulWaiterOptions
}

// NewImportTaskSuccessfulWaiter constructs a ImportTaskSuccessfulWaiter.
func NewImportTaskSuccessfulWaiter(client GetImportTaskAPIClient, optFns ...func(*ImportTaskSuccessfulWaiterOptions)) *ImportTaskSuccessfulWaiter {
	options := ImportTaskSuccessfulWaiterOptions{}
	options.MinDelay = 60 * time.Second
	options.MaxDelay = 28800 * time.Second
	options.Retryable = importTaskSuccessfulStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &ImportTaskSuccessfulWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for ImportTaskSuccessful waiter. The maxWaitDur
// is the maximum wait duration the waiter will wait. The maxWaitDur is required
// and must be greater than zero.
func (w *ImportTaskSuccessfulWaiter) Wait(ctx context.Context, params *GetImportTaskInput, maxWaitDur time.Duration, optFns ...func(*ImportTaskSuccessfulWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for ImportTaskSuccessful waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *ImportTaskSuccessfulWaiter) WaitForOutput(ctx context.Context, params *GetImportTaskInput, maxWaitDur time.Duration, optFns ...func(*ImportTaskSuccessfulWaiterOptions)) (*GetImportTaskOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 28800 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetImportTask(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for ImportTaskSuccessful waiter")
}

func importTaskSuccessfulStateRetryable(ctx context.Context, input *GetImportTaskInput, output *GetImportTaskOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.Status
		expectedValue := "CANCELLING"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "CANCELLED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "ROLLING_BACK"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "FAILED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "SUCCEEDED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// ImportTaskCancelledWaiterOptions are waiter options for
// ImportTaskCancelledWaiter
type ImportTaskCancelledWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// ImportTaskCancelledWaiter will use default minimum delay of 60 seconds. Note
	// that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, ImportTaskCancelledWaiter will use default max delay of 3600
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetImportTaskInput, *GetImportTaskOutput, error) (bool, error)
}

// ImportTaskCancelledWaiter defines the waiters for ImportTaskCancelled
type ImportTaskCancelledWaiter struct {
	client GetImportTaskAPIClient

	options ImportTaskCancelledWaiterOptions
}

// NewImportTaskCancelledWaiter constructs a ImportTaskCancelledWaiter.
func NewImportTaskCancelledWaiter(client GetImportTaskAPIClient, optFns ...func(*ImportTaskCancelledWaiterOptions)) *ImportTaskCancelledWaiter {
	options := ImportTaskCancelledWaiterOptions{}
	options.MinDelay = 60 * time.Second
	options.MaxDelay = 3600 * time.Second
	options.Retryable = importTaskCancelledStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &ImportTaskCancelledWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for ImportTaskCancelled waiter. The maxWaitDur
// is the maximum wait duration the waiter will wait. The maxWaitDur is required
// and must be greater than zero.
func (w *ImportTaskCancelledWaiter) Wait(ctx context.Context, params *GetImportTaskInput, maxWaitDur time.Duration, optFns ...func(*ImportTaskCancelledWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for ImportTaskCancelled waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *ImportTaskCancelledWaiter) WaitForOutput(ctx context.Context, params *GetImportTaskInput, maxWaitDur time.Duration, optFns ...func(*ImportTaskCancelledWaiterOptions)) (*GetImportTaskOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 3600 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetImportTask(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for ImportTaskCancelled waiter")
}

func importTaskCancelledStateRetryable(ctx context.Context, input *GetImportTaskInput, output *GetImportTaskOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.Status
		v2 := "CANCELLING"
		v3 := string(v1) != string(v2)
		v4 := output.Status
		v5 := "CANCELLED"
		v6 := string(v4) != string(v5)
		v7 := v3 && v6
		expectedValue := "true"
		bv, err := strconv.ParseBool(expectedValue)
		if err != nil {
			return false, fmt.Errorf("error parsing boolean from string %w", err)
		}
		if v7 == bv {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "CANCELLED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// GetImportTaskAPIClient is a client that implements the GetImportTask operation.
type GetImportTaskAPIClient interface {
	GetImportTask(context.Context, *GetImportTaskInput, ...func(*Options)) (*GetImportTaskOutput, error)
}

var _ GetImportTaskAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetImportTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetImportTask",
	}
}
