// Code generated by smithy-go-codegen DO NOT EDIT.

package neptunegraph

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/neptunegraph/types"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Export data from an existing Neptune Analytics graph to Amazon S3. The graph
// state should be AVAILABLE .
func (c *Client) StartExportTask(ctx context.Context, params *StartExportTaskInput, optFns ...func(*Options)) (*StartExportTaskOutput, error) {
	if params == nil {
		params = &StartExportTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartExportTask", params, optFns, c.addOperationStartExportTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartExportTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartExportTaskInput struct {

	// The Amazon S3 URI where data will be exported to.
	//
	// This member is required.
	Destination *string

	// The format of the export task.
	//
	// This member is required.
	Format types.ExportFormat

	// The source graph identifier of the export task.
	//
	// This member is required.
	GraphIdentifier *string

	// The KMS key identifier of the export task.
	//
	// This member is required.
	KmsKeyIdentifier *string

	// The ARN of the IAM role that will allow data to be exported to the destination.
	//
	// This member is required.
	RoleArn *string

	// The export filter of the export task.
	ExportFilter *types.ExportFilter

	// The parquet type of the export task.
	ParquetType types.ParquetType

	// Tags to be applied to the export task.
	Tags map[string]string

	noSmithyDocumentSerde
}

func (in *StartExportTaskInput) bindEndpointParams(p *EndpointParameters) {

	p.ApiType = ptr.String("ControlPlane")
}

type StartExportTaskOutput struct {

	// The Amazon S3 URI of the export task where data will be exported to.
	//
	// This member is required.
	Destination *string

	// The format of the export task.
	//
	// This member is required.
	Format types.ExportFormat

	// The source graph identifier of the export task.
	//
	// This member is required.
	GraphId *string

	// The KMS key identifier of the export task.
	//
	// This member is required.
	KmsKeyIdentifier *string

	// The ARN of the IAM role that will allow data to be exported to the destination.
	//
	// This member is required.
	RoleArn *string

	// The current status of the export task.
	//
	// This member is required.
	Status types.ExportTaskStatus

	// The unique identifier of the export task.
	//
	// This member is required.
	TaskId *string

	// The export filter of the export task.
	ExportFilter *types.ExportFilter

	// The parquet type of the export task.
	ParquetType types.ParquetType

	// The reason that the export task has this status value.
	StatusReason *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartExportTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartExportTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartExportTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartExportTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartExportTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartExportTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartExportTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartExportTask",
	}
}
