// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies the AvailabilityZoneChangeProtection setting for a transit
// gateway-attached firewall. When enabled, this setting prevents accidental
// changes to the firewall's Availability Zone configuration. This helps protect
// against disrupting traffic flow in production environments.
//
// When enabled, you must disable this protection before using AssociateAvailabilityZones or DisassociateAvailabilityZones to modify the
// firewall's Availability Zone configuration.
func (c *Client) UpdateAvailabilityZoneChangeProtection(ctx context.Context, params *UpdateAvailabilityZoneChangeProtectionInput, optFns ...func(*Options)) (*UpdateAvailabilityZoneChangeProtectionOutput, error) {
	if params == nil {
		params = &UpdateAvailabilityZoneChangeProtectionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAvailabilityZoneChangeProtection", params, optFns, c.addOperationUpdateAvailabilityZoneChangeProtectionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAvailabilityZoneChangeProtectionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAvailabilityZoneChangeProtectionInput struct {

	// A setting indicating whether the firewall is protected against changes to the
	// subnet associations. Use this setting to protect against accidentally modifying
	// the subnet associations for a firewall that is in use. When you create a
	// firewall, the operation initializes this setting to TRUE .
	//
	// This member is required.
	AvailabilityZoneChangeProtection bool

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallArn *string

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallName *string

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks the
	// state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless of
	// whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails with
	// an InvalidTokenException . If this happens, retrieve the firewall again to get a
	// current copy of it with a new token. Reapply your changes as needed, then try
	// the operation again using the new token.
	UpdateToken *string

	noSmithyDocumentSerde
}

type UpdateAvailabilityZoneChangeProtectionOutput struct {

	// A setting indicating whether the firewall is protected against changes to the
	// subnet associations. Use this setting to protect against accidentally modifying
	// the subnet associations for a firewall that is in use. When you create a
	// firewall, the operation initializes this setting to TRUE .
	AvailabilityZoneChangeProtection bool

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	FirewallName *string

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks the
	// state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless of
	// whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails with
	// an InvalidTokenException . If this happens, retrieve the firewall again to get a
	// current copy of it with a new token. Reapply your changes as needed, then try
	// the operation again using the new token.
	UpdateToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAvailabilityZoneChangeProtectionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateAvailabilityZoneChangeProtection{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateAvailabilityZoneChangeProtection{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAvailabilityZoneChangeProtection"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateAvailabilityZoneChangeProtectionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAvailabilityZoneChangeProtection(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateAvailabilityZoneChangeProtection(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAvailabilityZoneChangeProtection",
	}
}
