// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the properties of the specified proxy rule.
func (c *Client) UpdateProxyRule(ctx context.Context, params *UpdateProxyRuleInput, optFns ...func(*Options)) (*UpdateProxyRuleOutput, error) {
	if params == nil {
		params = &UpdateProxyRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateProxyRule", params, optFns, c.addOperationUpdateProxyRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateProxyRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateProxyRuleInput struct {

	// The descriptive name of the proxy rule. You can't change the name of a proxy
	// rule after you create it.
	//
	// This member is required.
	ProxyRuleName *string

	// A token used for optimistic locking. Network Firewall returns a token to your
	// requests that access the proxy rule. The token marks the state of the proxy rule
	// resource at the time of the request.
	//
	// To make changes to the proxy rule, you provide the token in your request.
	// Network Firewall uses the token to ensure that the proxy rule hasn't changed
	// since you last retrieved it. If it has changed, the operation fails with an
	// InvalidTokenException . If this happens, retrieve the proxy rule again to get a
	// current copy of it with a current token. Reapply your changes as needed, then
	// try the operation again using the new token.
	//
	// This member is required.
	UpdateToken *string

	// Depending on the match action, the proxy either stops the evaluation (if the
	// action is terminal - allow or deny), or continues it (if the action is alert)
	// until it matches a rule with a terminal action.
	Action types.ProxyRulePhaseAction

	// Proxy rule conditions to add. Match criteria that specify what traffic
	// attributes to examine. Conditions include operators (StringEquals, StringLike)
	// and values to match against.
	AddConditions []types.ProxyRuleCondition

	// A description of the proxy rule.
	Description *string

	// The Amazon Resource Name (ARN) of a proxy rule group.
	//
	// You must specify the ARN or the name, and you can specify both.
	ProxyRuleGroupArn *string

	// The descriptive name of the proxy rule group. You can't change the name of a
	// proxy rule group after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	ProxyRuleGroupName *string

	// Proxy rule conditions to remove. Match criteria that specify what traffic
	// attributes to examine. Conditions include operators (StringEquals, StringLike)
	// and values to match against.
	RemoveConditions []types.ProxyRuleCondition

	noSmithyDocumentSerde
}

type UpdateProxyRuleOutput struct {

	// The updated proxy rule resource that reflects the updates from the request.
	ProxyRule *types.ProxyRule

	// Proxy rule conditions removed from the rule.
	RemovedConditions []types.ProxyRuleCondition

	// A token used for optimistic locking. Network Firewall returns a token to your
	// requests that access the proxy rule. The token marks the state of the proxy rule
	// resource at the time of the request.
	//
	// To make changes to the proxy rule, you provide the token in your request.
	// Network Firewall uses the token to ensure that the proxy rule hasn't changed
	// since you last retrieved it. If it has changed, the operation fails with an
	// InvalidTokenException . If this happens, retrieve the proxy rule again to get a
	// current copy of it with a current token. Reapply your changes as needed, then
	// try the operation again using the new token.
	UpdateToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateProxyRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateProxyRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateProxyRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateProxyRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateProxyRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateProxyRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateProxyRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateProxyRule",
	}
}
