// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates proxy rule group priorities within a proxy configuration.
func (c *Client) UpdateProxyRuleGroupPriorities(ctx context.Context, params *UpdateProxyRuleGroupPrioritiesInput, optFns ...func(*Options)) (*UpdateProxyRuleGroupPrioritiesOutput, error) {
	if params == nil {
		params = &UpdateProxyRuleGroupPrioritiesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateProxyRuleGroupPriorities", params, optFns, c.addOperationUpdateProxyRuleGroupPrioritiesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateProxyRuleGroupPrioritiesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateProxyRuleGroupPrioritiesInput struct {

	// proxy rule group resources to update to new positions.
	//
	// This member is required.
	RuleGroups []types.ProxyRuleGroupPriority

	// A token used for optimistic locking. Network Firewall returns a token to your
	// requests that access the proxy configuration. The token marks the state of the
	// proxy configuration resource at the time of the request.
	//
	// To make changes to the proxy configuration, you provide the token in your
	// request. Network Firewall uses the token to ensure that the proxy configuration
	// hasn't changed since you last retrieved it. If it has changed, the operation
	// fails with an InvalidTokenException . If this happens, retrieve the proxy
	// configuration again to get a current copy of it with a current token. Reapply
	// your changes as needed, then try the operation again using the new token.
	//
	// This member is required.
	UpdateToken *string

	// The Amazon Resource Name (ARN) of a proxy configuration.
	//
	// You must specify the ARN or the name, and you can specify both.
	ProxyConfigurationArn *string

	// The descriptive name of the proxy configuration. You can't change the name of a
	// proxy configuration after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	ProxyConfigurationName *string

	noSmithyDocumentSerde
}

type UpdateProxyRuleGroupPrioritiesOutput struct {

	// The updated proxy rule group hierarchy that reflects the updates from the
	// request.
	ProxyRuleGroups []types.ProxyRuleGroupPriorityResult

	// A token used for optimistic locking. Network Firewall returns a token to your
	// requests that access the proxy configuration. The token marks the state of the
	// proxy configuration resource at the time of the request.
	//
	// To make changes to the proxy configuration, you provide the token in your
	// request. Network Firewall uses the token to ensure that the proxy configuration
	// hasn't changed since you last retrieved it. If it has changed, the operation
	// fails with an InvalidTokenException . If this happens, retrieve the proxy
	// configuration again to get a current copy of it with a current token. Reapply
	// your changes as needed, then try the operation again using the new token.
	UpdateToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateProxyRuleGroupPrioritiesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateProxyRuleGroupPriorities{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateProxyRuleGroupPriorities{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateProxyRuleGroupPriorities"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateProxyRuleGroupPrioritiesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateProxyRuleGroupPriorities(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateProxyRuleGroupPriorities(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateProxyRuleGroupPriorities",
	}
}
