// Code generated by smithy-go-codegen DO NOT EDIT.

package networkflowmonitor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkflowmonitor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// In Network Flow Monitor, you specify a scope for the service to generate
// metrics for. By using the scope, Network Flow Monitor can generate a topology of
// all the resources to measure performance metrics for. When you create a scope,
// you enable permissions for Network Flow Monitor.
//
// A scope is a Region-account pair or multiple Region-account pairs. Network Flow
// Monitor uses your scope to determine all the resources (the topology) where
// Network Flow Monitor will gather network flow performance metrics for you. To
// provide performance metrics, Network Flow Monitor uses the data that is sent by
// the Network Flow Monitor agents you install on the resources.
//
// To define the Region-account pairs for your scope, the Network Flow Monitor API
// uses the following constucts, which allow for future flexibility in defining
// scopes:
//
//   - Targets, which are arrays of targetResources.
//
//   - Target resources, which are Region-targetIdentifier pairs.
//
//   - Target identifiers, made up of a targetID (currently always an account ID)
//     and a targetType (currently always an account).
func (c *Client) CreateScope(ctx context.Context, params *CreateScopeInput, optFns ...func(*Options)) (*CreateScopeOutput, error) {
	if params == nil {
		params = &CreateScopeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateScope", params, optFns, c.addOperationCreateScopeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateScopeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateScopeInput struct {

	// The targets to define the scope to be monitored. A target is an array of
	// targetResources, which are currently Region-account pairs, defined by
	// targetResource constructs.
	//
	// This member is required.
	Targets []types.TargetResource

	// A unique, case-sensitive string of up to 64 ASCII characters that you specify
	// to make an idempotent API request. Don't reuse the same client token for other
	// API requests.
	ClientToken *string

	// The tags for a scope. You can add a maximum of 200 tags.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateScopeOutput struct {

	// The Amazon Resource Name (ARN) of the scope.
	//
	// This member is required.
	ScopeArn *string

	// The identifier for the scope that includes the resources you want to get
	// metrics for. A scope ID is an internally-generated identifier that includes all
	// the resources for a specific root account.
	//
	// This member is required.
	ScopeId *string

	// The status for a scope. The status can be one of the following: SUCCEEDED ,
	// IN_PROGRESS , FAILED , DEACTIVATING , or DEACTIVATED .
	//
	// A status of DEACTIVATING means that you've requested a scope to be deactivated
	// and Network Flow Monitor is in the process of deactivating the scope. A status
	// of DEACTIVATED means that the deactivating process is complete.
	//
	// This member is required.
	Status types.ScopeStatus

	// The tags for a scope.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateScopeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateScope{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateScope{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateScope"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateScopeMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateScopeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateScope(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateScope struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateScope) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateScope) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateScopeInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateScopeInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateScopeMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateScope{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateScope(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateScope",
	}
}
