// Code generated by smithy-go-codegen DO NOT EDIT.

package networkmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkmanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the routing policy associations for attachments in a core network.
func (c *Client) ListAttachmentRoutingPolicyAssociations(ctx context.Context, params *ListAttachmentRoutingPolicyAssociationsInput, optFns ...func(*Options)) (*ListAttachmentRoutingPolicyAssociationsOutput, error) {
	if params == nil {
		params = &ListAttachmentRoutingPolicyAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAttachmentRoutingPolicyAssociations", params, optFns, c.addOperationListAttachmentRoutingPolicyAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAttachmentRoutingPolicyAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAttachmentRoutingPolicyAssociationsInput struct {

	// The ID of the core network to list attachment routing policy associations for.
	//
	// This member is required.
	CoreNetworkId *string

	// The ID of a specific attachment to filter the routing policy associations.
	AttachmentId *string

	// The maximum number of results to return in a single page.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAttachmentRoutingPolicyAssociationsOutput struct {

	// The list of attachment routing policy associations.
	AttachmentRoutingPolicyAssociations []types.AttachmentRoutingPolicyAssociationSummary

	// The token for the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAttachmentRoutingPolicyAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAttachmentRoutingPolicyAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAttachmentRoutingPolicyAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAttachmentRoutingPolicyAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAttachmentRoutingPolicyAssociationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAttachmentRoutingPolicyAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAttachmentRoutingPolicyAssociationsPaginatorOptions is the paginator
// options for ListAttachmentRoutingPolicyAssociations
type ListAttachmentRoutingPolicyAssociationsPaginatorOptions struct {
	// The maximum number of results to return in a single page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAttachmentRoutingPolicyAssociationsPaginator is a paginator for
// ListAttachmentRoutingPolicyAssociations
type ListAttachmentRoutingPolicyAssociationsPaginator struct {
	options   ListAttachmentRoutingPolicyAssociationsPaginatorOptions
	client    ListAttachmentRoutingPolicyAssociationsAPIClient
	params    *ListAttachmentRoutingPolicyAssociationsInput
	nextToken *string
	firstPage bool
}

// NewListAttachmentRoutingPolicyAssociationsPaginator returns a new
// ListAttachmentRoutingPolicyAssociationsPaginator
func NewListAttachmentRoutingPolicyAssociationsPaginator(client ListAttachmentRoutingPolicyAssociationsAPIClient, params *ListAttachmentRoutingPolicyAssociationsInput, optFns ...func(*ListAttachmentRoutingPolicyAssociationsPaginatorOptions)) *ListAttachmentRoutingPolicyAssociationsPaginator {
	if params == nil {
		params = &ListAttachmentRoutingPolicyAssociationsInput{}
	}

	options := ListAttachmentRoutingPolicyAssociationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAttachmentRoutingPolicyAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAttachmentRoutingPolicyAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAttachmentRoutingPolicyAssociations page.
func (p *ListAttachmentRoutingPolicyAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAttachmentRoutingPolicyAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAttachmentRoutingPolicyAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAttachmentRoutingPolicyAssociationsAPIClient is a client that implements
// the ListAttachmentRoutingPolicyAssociations operation.
type ListAttachmentRoutingPolicyAssociationsAPIClient interface {
	ListAttachmentRoutingPolicyAssociations(context.Context, *ListAttachmentRoutingPolicyAssociationsInput, ...func(*Options)) (*ListAttachmentRoutingPolicyAssociationsOutput, error)
}

var _ ListAttachmentRoutingPolicyAssociationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAttachmentRoutingPolicyAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAttachmentRoutingPolicyAssociations",
	}
}
