// Code generated by smithy-go-codegen DO NOT EDIT.

package notifications

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/notifications/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns a list of ManagedNotificationChildEvents for a specified aggregate
// ManagedNotificationEvent , ordered by creation time in reverse chronological
// order (newest first).
func (c *Client) ListManagedNotificationChildEvents(ctx context.Context, params *ListManagedNotificationChildEventsInput, optFns ...func(*Options)) (*ListManagedNotificationChildEventsOutput, error) {
	if params == nil {
		params = &ListManagedNotificationChildEventsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListManagedNotificationChildEvents", params, optFns, c.addOperationListManagedNotificationChildEventsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListManagedNotificationChildEventsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListManagedNotificationChildEventsInput struct {

	// The Amazon Resource Name (ARN) of the ManagedNotificationEvent .
	//
	// This member is required.
	AggregateManagedNotificationEventArn *string

	// Latest time of events to return from this call.
	EndTime *time.Time

	// The locale code of the language used for the retrieved NotificationEvent . The
	// default locale is English. en_US .
	Locale types.LocaleCode

	// The maximum number of results to be returned in this call. Defaults to 20.
	MaxResults *int32

	// The start token for paginated calls. Retrieved from the response of a previous
	// ListManagedNotificationChannelAssociations call. Next token uses Base64
	// encoding.
	NextToken *string

	// The identifier of the Amazon Web Services Organizations organizational unit
	// (OU) associated with the Managed Notification Child Events.
	OrganizationalUnitId *string

	// The Amazon Web Services account ID associated with the Managed Notification
	// Child Events.
	RelatedAccount *string

	// The earliest time of events to return from this call.
	StartTime *time.Time

	noSmithyDocumentSerde
}

type ListManagedNotificationChildEventsOutput struct {

	// A pagination token. If a non-null pagination token is returned in a result,
	// pass its value in another request to retrieve more entries.
	//
	// This member is required.
	ManagedNotificationChildEvents []types.ManagedNotificationChildEventOverview

	// A pagination token. If a non-null pagination token is returned in a result,
	// pass its value in another request to retrieve more entries.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListManagedNotificationChildEventsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListManagedNotificationChildEvents{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListManagedNotificationChildEvents{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListManagedNotificationChildEvents"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListManagedNotificationChildEventsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListManagedNotificationChildEvents(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListManagedNotificationChildEventsPaginatorOptions is the paginator options for
// ListManagedNotificationChildEvents
type ListManagedNotificationChildEventsPaginatorOptions struct {
	// The maximum number of results to be returned in this call. Defaults to 20.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListManagedNotificationChildEventsPaginator is a paginator for
// ListManagedNotificationChildEvents
type ListManagedNotificationChildEventsPaginator struct {
	options   ListManagedNotificationChildEventsPaginatorOptions
	client    ListManagedNotificationChildEventsAPIClient
	params    *ListManagedNotificationChildEventsInput
	nextToken *string
	firstPage bool
}

// NewListManagedNotificationChildEventsPaginator returns a new
// ListManagedNotificationChildEventsPaginator
func NewListManagedNotificationChildEventsPaginator(client ListManagedNotificationChildEventsAPIClient, params *ListManagedNotificationChildEventsInput, optFns ...func(*ListManagedNotificationChildEventsPaginatorOptions)) *ListManagedNotificationChildEventsPaginator {
	if params == nil {
		params = &ListManagedNotificationChildEventsInput{}
	}

	options := ListManagedNotificationChildEventsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListManagedNotificationChildEventsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListManagedNotificationChildEventsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListManagedNotificationChildEvents page.
func (p *ListManagedNotificationChildEventsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListManagedNotificationChildEventsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListManagedNotificationChildEvents(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListManagedNotificationChildEventsAPIClient is a client that implements the
// ListManagedNotificationChildEvents operation.
type ListManagedNotificationChildEventsAPIClient interface {
	ListManagedNotificationChildEvents(context.Context, *ListManagedNotificationChildEventsInput, ...func(*Options)) (*ListManagedNotificationChildEventsOutput, error)
}

var _ ListManagedNotificationChildEventsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListManagedNotificationChildEvents(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListManagedNotificationChildEvents",
	}
}
