// Code generated by smithy-go-codegen DO NOT EDIT.

package observabilityadmin

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/observabilityadmin/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the details of a specific organization centralization rule. This
// operation can only be called by the organization's management account or a
// delegated administrator account.
func (c *Client) GetCentralizationRuleForOrganization(ctx context.Context, params *GetCentralizationRuleForOrganizationInput, optFns ...func(*Options)) (*GetCentralizationRuleForOrganizationOutput, error) {
	if params == nil {
		params = &GetCentralizationRuleForOrganizationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCentralizationRuleForOrganization", params, optFns, c.addOperationGetCentralizationRuleForOrganizationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCentralizationRuleForOrganizationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCentralizationRuleForOrganizationInput struct {

	// The identifier (name or ARN) of the organization centralization rule to
	// retrieve.
	//
	// This member is required.
	RuleIdentifier *string

	noSmithyDocumentSerde
}

type GetCentralizationRuleForOrganizationOutput struct {

	// The configuration details for the organization centralization rule.
	CentralizationRule *types.CentralizationRule

	// The Amazon Web Services region where the organization centralization rule was
	// created.
	CreatedRegion *string

	// The timestamp when the organization centralization rule was created.
	CreatedTimeStamp *int64

	// The Amazon Web Services Account that created the organization centralization
	// rule.
	CreatorAccountId *string

	// The reason why an organization centralization rule is marked UNHEALTHY.
	FailureReason types.CentralizationFailureReason

	// The timestamp when the organization centralization rule was last updated.
	LastUpdateTimeStamp *int64

	// The Amazon Resource Name (ARN) of the organization centralization rule.
	RuleArn *string

	// The health status of the organization centralization rule.
	RuleHealth types.RuleHealth

	// The name of the organization centralization rule.
	RuleName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCentralizationRuleForOrganizationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCentralizationRuleForOrganization{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCentralizationRuleForOrganization{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCentralizationRuleForOrganization"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetCentralizationRuleForOrganizationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCentralizationRuleForOrganization(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCentralizationRuleForOrganization(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCentralizationRuleForOrganization",
	}
}
