// Code generated by smithy-go-codegen DO NOT EDIT.

package odb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/odb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all ODB peering connections or those associated with a specific ODB
// network.
func (c *Client) ListOdbPeeringConnections(ctx context.Context, params *ListOdbPeeringConnectionsInput, optFns ...func(*Options)) (*ListOdbPeeringConnectionsOutput, error) {
	if params == nil {
		params = &ListOdbPeeringConnectionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListOdbPeeringConnections", params, optFns, c.addOperationListOdbPeeringConnectionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListOdbPeeringConnectionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListOdbPeeringConnectionsInput struct {

	// The maximum number of ODB peering connections to return in the response.
	//
	// Default: 20
	//
	// Constraints:
	//
	//   - Must be between 1 and 100.
	MaxResults *int32

	// The pagination token for the next page of ODB peering connections.
	NextToken *string

	// The identifier of the ODB network to list peering connections for.
	//
	// If not specified, lists all ODB peering connections in the account.
	OdbNetworkId *string

	noSmithyDocumentSerde
}

type ListOdbPeeringConnectionsOutput struct {

	// The list of ODB peering connections.
	//
	// This member is required.
	OdbPeeringConnections []types.OdbPeeringConnectionSummary

	// The pagination token for the next page of ODB peering connections.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListOdbPeeringConnectionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListOdbPeeringConnections{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListOdbPeeringConnections{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListOdbPeeringConnections"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListOdbPeeringConnections(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListOdbPeeringConnectionsPaginatorOptions is the paginator options for
// ListOdbPeeringConnections
type ListOdbPeeringConnectionsPaginatorOptions struct {
	// The maximum number of ODB peering connections to return in the response.
	//
	// Default: 20
	//
	// Constraints:
	//
	//   - Must be between 1 and 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListOdbPeeringConnectionsPaginator is a paginator for ListOdbPeeringConnections
type ListOdbPeeringConnectionsPaginator struct {
	options   ListOdbPeeringConnectionsPaginatorOptions
	client    ListOdbPeeringConnectionsAPIClient
	params    *ListOdbPeeringConnectionsInput
	nextToken *string
	firstPage bool
}

// NewListOdbPeeringConnectionsPaginator returns a new
// ListOdbPeeringConnectionsPaginator
func NewListOdbPeeringConnectionsPaginator(client ListOdbPeeringConnectionsAPIClient, params *ListOdbPeeringConnectionsInput, optFns ...func(*ListOdbPeeringConnectionsPaginatorOptions)) *ListOdbPeeringConnectionsPaginator {
	if params == nil {
		params = &ListOdbPeeringConnectionsInput{}
	}

	options := ListOdbPeeringConnectionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListOdbPeeringConnectionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListOdbPeeringConnectionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListOdbPeeringConnections page.
func (p *ListOdbPeeringConnectionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListOdbPeeringConnectionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListOdbPeeringConnections(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListOdbPeeringConnectionsAPIClient is a client that implements the
// ListOdbPeeringConnections operation.
type ListOdbPeeringConnectionsAPIClient interface {
	ListOdbPeeringConnections(context.Context, *ListOdbPeeringConnectionsInput, ...func(*Options)) (*ListOdbPeeringConnectionsOutput, error)
}

var _ ListOdbPeeringConnectionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListOdbPeeringConnections(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListOdbPeeringConnections",
	}
}
