// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A summary of an Autonomous Virtual Machine (VM) within an Autonomous VM cluster.
type AutonomousVirtualMachineSummary struct {

	// The unique identifier of the Autonomous VM.
	AutonomousVirtualMachineId *string

	// The IP address used by clients to connect to this Autonomous VM.
	ClientIpAddress *string

	// The unique identifier of the Autonomous VM cluster containing this Autonomous
	// VM.
	CloudAutonomousVmClusterId *string

	// The number of CPU cores allocated to this Autonomous VM.
	CpuCoreCount *int32

	// The amount of storage allocated to this Autonomous Virtual Machine, in
	// gigabytes (GB).
	DbNodeStorageSizeInGBs *int32

	// The display name of the database server hosting this Autonomous VM.
	DbServerDisplayName *string

	// The unique identifier of the database server hosting this Autonomous VM.
	DbServerId *string

	// The amount of memory allocated to this Autonomous VM, in gigabytes (GB).
	MemorySizeInGBs *int32

	// The name of the Oracle Cloud Infrastructure (OCI) resource anchor associated
	// with this Autonomous VM.
	OciResourceAnchorName *string

	// The Oracle Cloud Identifier (OCID) of the Autonomous VM.
	Ocid *string

	// The current status of the Autonomous VM.
	Status ResourceStatus

	// Additional information about the current status of the Autonomous VM, if
	// applicable.
	StatusReason *string

	// The name of the Autonomous VM.
	VmName *string

	noSmithyDocumentSerde
}

// Information about an Autonomous VM cluster resource.
type CloudAutonomousVmCluster struct {

	// The unique identifier of the Autonomous VM cluster.
	//
	// This member is required.
	CloudAutonomousVmClusterId *string

	// The percentage of data storage currently in use for Autonomous Databases in the
	// Autonomous VM cluster.
	AutonomousDataStoragePercentage *float32

	// The data storage size allocated for Autonomous Databases in the Autonomous VM
	// cluster, in TB.
	AutonomousDataStorageSizeInTBs *float64

	// The available data storage space for Autonomous Databases in the Autonomous VM
	// cluster, in TB.
	AvailableAutonomousDataStorageSizeInTBs *float64

	// The number of Autonomous CDBs that you can create with the currently available
	// storage.
	AvailableContainerDatabases *int32

	// The number of CPU cores available for allocation to Autonomous Databases.
	AvailableCpus *float32

	// The Amazon Resource Name (ARN) for the Autonomous VM cluster.
	CloudAutonomousVmClusterArn *string

	// The unique identifier of the Cloud Exadata Infrastructure containing this
	// Autonomous VM cluster.
	CloudExadataInfrastructureId *string

	// The compute model of the Autonomous VM cluster: ECPU or OCPU.
	ComputeModel ComputeModel

	// The total number of CPU cores in the Autonomous VM cluster.
	CpuCoreCount *int32

	// The number of CPU cores enabled per node in the Autonomous VM cluster.
	CpuCoreCountPerNode *int32

	// The percentage of total CPU cores currently in use in the Autonomous VM cluster.
	CpuPercentage *float32

	// The date and time when the Autonomous VM cluster was created.
	CreatedAt *time.Time

	// The total data storage allocated to the Autonomous VM cluster, in GB.
	DataStorageSizeInGBs *float64

	// The total data storage allocated to the Autonomous VM cluster, in TB.
	DataStorageSizeInTBs *float64

	// The local node storage allocated to the Autonomous VM cluster, in gigabytes
	// (GB).
	DbNodeStorageSizeInGBs *int32

	// The list of database servers associated with the Autonomous VM cluster.
	DbServers []string

	// The user-provided description of the Autonomous VM cluster.
	Description *string

	// The display name of the Autonomous VM cluster.
	DisplayName *string

	// The domain name for the Autonomous VM cluster.
	Domain *string

	// The minimum value to which you can scale down the Exadata storage, in TB.
	ExadataStorageInTBsLowestScaledValue *float64

	// The hostname for the Autonomous VM cluster.
	Hostname *string

	// Indicates whether mutual TLS (mTLS) authentication is enabled for the
	// Autonomous VM cluster.
	IsMtlsEnabledVmCluster *bool

	// The Oracle license model that applies to the Autonomous VM cluster.
	LicenseModel LicenseModel

	// The scheduling details for the maintenance window. Patching and system updates
	// take place during the maintenance window.
	MaintenanceWindow *MaintenanceWindow

	// The minimum value to which you can scale down the maximum number of Autonomous
	// CDBs.
	MaxAcdsLowestScaledValue *int32

	// The amount of memory allocated per Oracle Compute Unit, in GB.
	MemoryPerOracleComputeUnitInGBs *int32

	// The total amount of memory allocated to the Autonomous VM cluster, in gigabytes
	// (GB).
	MemorySizeInGBs *int32

	// The number of database server nodes in the Autonomous VM cluster.
	NodeCount *int32

	// The number of Autonomous CDBs that can't be provisioned because of resource
	// constraints.
	NonProvisionableAutonomousContainerDatabases *int32

	// The name of the OCI resource anchor associated with this Autonomous VM cluster.
	OciResourceAnchorName *string

	// The URL for accessing the OCI console page for this Autonomous VM cluster.
	OciUrl *string

	// The Oracle Cloud Identifier (OCID) of the Autonomous VM cluster.
	Ocid *string

	// The unique identifier of the ODB network associated with this Autonomous VM
	// cluster.
	OdbNetworkId *string

	// The progress of the current operation on the Autonomous VM cluster, as a
	// percentage.
	PercentProgress *float32

	// The number of Autonomous CDBs that can be provisioned in the Autonomous VM
	// cluster.
	ProvisionableAutonomousContainerDatabases *int32

	// The number of Autonomous CDBs currently provisioned in the Autonomous VM
	// cluster.
	ProvisionedAutonomousContainerDatabases *int32

	// The number of CPU cores currently provisioned in the Autonomous VM cluster.
	ProvisionedCpus *float32

	// The number of CPU cores that can be reclaimed from terminated or scaled-down
	// Autonomous Databases.
	ReclaimableCpus *float32

	// The number of CPU cores reserved for system operations and redundancy.
	ReservedCpus *float32

	// The SCAN listener port for non-TLS (TCP) protocol. The default is 1521.
	ScanListenerPortNonTls *int32

	// The SCAN listener port for TLS (TCP) protocol. The default is 2484.
	ScanListenerPortTls *int32

	// The shape of the Exadata infrastructure for the Autonomous VM cluster.
	Shape *string

	// The current state of the Autonomous VM cluster. Possible values include CREATING
	// , AVAILABLE , UPDATING , DELETING , DELETED , FAILED .
	Status ResourceStatus

	// Additional information about the current status of the Autonomous VM cluster.
	StatusReason *string

	// The expiration date and time of the database SSL certificate.
	TimeDatabaseSslCertificateExpires *time.Time

	// The expiration date and time of the Oracle REST Data Services (ORDS)
	// certificate.
	TimeOrdsCertificateExpires *time.Time

	// The time zone of the Autonomous VM cluster.
	TimeZone *string

	// The total number of Autonomous Container Databases that can be created with the
	// allocated local storage.
	TotalContainerDatabases *int32

	noSmithyDocumentSerde
}

// Resource details of an Autonomous VM cluster.
type CloudAutonomousVmClusterResourceDetails struct {

	// The unique identifier of the Autonomous VM cluster.
	CloudAutonomousVmClusterId *string

	// The amount of unallocated Autonomous Database storage in the Autonomous VM
	// cluster, in terabytes.
	UnallocatedAdbStorageInTBs *float64

	noSmithyDocumentSerde
}

// A summary of an Autonomous VM cluster.
type CloudAutonomousVmClusterSummary struct {

	// The unique identifier of the Autonomous VM cluster.
	//
	// This member is required.
	CloudAutonomousVmClusterId *string

	// The percentage of data storage currently in use for Autonomous Databases in the
	// Autonomous VM cluster.
	AutonomousDataStoragePercentage *float32

	// The total data storage allocated for Autonomous Databases in the Autonomous VM
	// cluster, in TB.
	AutonomousDataStorageSizeInTBs *float64

	// The available data storage for Autonomous Databases in the Autonomous VM
	// cluster, in TB.
	AvailableAutonomousDataStorageSizeInTBs *float64

	// The number of Autonomous Container Databases that you can create with the
	// currently available storage.
	AvailableContainerDatabases *int32

	// The number of CPU cores available for allocation to Autonomous Databases.
	AvailableCpus *float32

	// The Amazon Resource Name (ARN) for the Autonomous VM cluster.
	CloudAutonomousVmClusterArn *string

	// The unique identifier of the Exadata infrastructure containing this Autonomous
	// VM cluster.
	CloudExadataInfrastructureId *string

	// The compute model of the Autonomous VM cluster: ECPU or OCPU.
	ComputeModel ComputeModel

	// The total number of CPU cores in the Autonomous VM cluster.
	CpuCoreCount *int32

	// The number of CPU cores per node in the Autonomous VM cluster.
	CpuCoreCountPerNode *int32

	// The percentage of total CPU cores currently in use in the Autonomous VM cluster.
	CpuPercentage *float32

	// The date and time when the Autonomous VM cluster was created.
	CreatedAt *time.Time

	// The total data storage allocated to the Autonomous VM cluster, in GB.
	DataStorageSizeInGBs *float64

	// The total data storage allocated to the Autonomous VM cluster, in TB.
	DataStorageSizeInTBs *float64

	// The local node storage allocated to the Autonomous VM cluster, in GB.
	DbNodeStorageSizeInGBs *int32

	// The list of database servers associated with the Autonomous VM cluster.
	DbServers []string

	// The user-provided description of the Autonomous VM cluster.
	Description *string

	// The user-friendly name for the Autonomous VM cluster.
	DisplayName *string

	// The domain name for the Autonomous VM cluster.
	Domain *string

	// The lowest value to which Exadata storage can be scaled down, in TB.
	ExadataStorageInTBsLowestScaledValue *float64

	// The host name for the Autonomous VM cluster.
	Hostname *string

	// Indicates if mutual TLS (mTLS) authentication is enabled for the Autonomous VM
	// cluster.
	IsMtlsEnabledVmCluster *bool

	// The Oracle license model that applies to the Autonomous VM cluster.
	LicenseModel LicenseModel

	// The scheduling details for the maintenance window. Patching and system updates
	// take place during the maintenance window.
	MaintenanceWindow *MaintenanceWindow

	// The lowest value to which you can scale down the maximum number of Autonomous
	// CDBs.
	MaxAcdsLowestScaledValue *int32

	// The amount of memory allocated per Oracle Compute Unit (OCU), in GB.
	MemoryPerOracleComputeUnitInGBs *int32

	// The total amount of memory allocated to the Autonomous VM cluster, in GB.
	MemorySizeInGBs *int32

	// The number of database server nodes in the Autonomous VM cluster.
	NodeCount *int32

	// The number of Autonomous CDBs that can't be provisioned because of resource
	// constraints.
	NonProvisionableAutonomousContainerDatabases *int32

	// The name of the OCI resource anchor associated with this Autonomous VM cluster.
	OciResourceAnchorName *string

	// The URL for accessing the OCI console page for this Autonomous VM cluster.
	OciUrl *string

	// The Oracle Cloud Identifier (OCID) of the Autonomous VM cluster.
	Ocid *string

	// The unique identifier of the ODB network associated with this Autonomous VM
	// cluster.
	OdbNetworkId *string

	// The progress of the current operation on the Autonomous VM cluster, as a
	// percentage.
	PercentProgress *float32

	// The number of Autonomous CDBs that you can provision in the Autonomous VM
	// cluster.
	ProvisionableAutonomousContainerDatabases *int32

	// The number of Autonomous Container Databases currently provisioned in the
	// Autonomous VM cluster.
	ProvisionedAutonomousContainerDatabases *int32

	// The number of CPUs currently provisioned in the Autonomous VM cluster.
	ProvisionedCpus *float32

	// The number of CPUs that can be reclaimed from terminated or scaled-down
	// Autonomous Databases.
	ReclaimableCpus *float32

	// The number of CPUs reserved for system operations and redundancy.
	ReservedCpus *float32

	// The SCAN listener port for non-TLS (TCP) protocol.
	ScanListenerPortNonTls *int32

	// The SCAN listener port for TLS (TCP) protocol.
	ScanListenerPortTls *int32

	// The shape of the Exadata infrastructure for the Autonomous VM cluster.
	Shape *string

	// The current status of the Autonomous VM cluster.
	Status ResourceStatus

	// Additional information about the current status of the Autonomous VM cluster,
	// if applicable.
	StatusReason *string

	// The expiration date and time of the database SSL certificate.
	TimeDatabaseSslCertificateExpires *time.Time

	// The expiration date and time of the Oracle REST Data Services (ORDS)
	// certificate.
	TimeOrdsCertificateExpires *time.Time

	// The time zone of the Autonomous VM cluster.
	TimeZone *string

	// The total number of Autonomous Container Databases that can be created in the
	// Autonomous VM cluster.
	TotalContainerDatabases *int32

	noSmithyDocumentSerde
}

// Information about an Exadata infrastructure.
type CloudExadataInfrastructure struct {

	// The unique identifier for the Exadata infrastructure.
	//
	// This member is required.
	CloudExadataInfrastructureId *string

	// The number of storage servers requested for the Exadata infrastructure.
	ActivatedStorageCount *int32

	// The number of storage servers requested for the Exadata infrastructure.
	AdditionalStorageCount *int32

	// The name of the Availability Zone (AZ) where the Exadata infrastructure is
	// located.
	AvailabilityZone *string

	// The AZ ID of the AZ where the Exadata infrastructure is located.
	AvailabilityZoneId *string

	// The amount of available storage, in gigabytes (GB), for the Exadata
	// infrastructure.
	AvailableStorageSizeInGBs *int32

	// The Amazon Resource Name (ARN) for the Exadata infrastructure.
	CloudExadataInfrastructureArn *string

	// The number of database servers for the Exadata infrastructure.
	ComputeCount *int32

	// The OCI model compute model used when you create or clone an instance: ECPU or
	// OCPU. An ECPU is an abstracted measure of compute resources. ECPUs are based on
	// the number of cores elastically allocated from a pool of compute and storage
	// servers. An OCPU is a legacy physical measure of compute resources. OCPUs are
	// based on the physical core of a processor with hyper-threading enabled.
	ComputeModel ComputeModel

	// The total number of CPU cores that are allocated to the Exadata infrastructure.
	CpuCount *int32

	// The date and time when the Exadata infrastructure was created.
	CreatedAt *time.Time

	// The email addresses of contacts to receive notification from Oracle about
	// maintenance updates for the Exadata infrastructure.
	CustomerContactsToSendToOCI []CustomerContact

	// The size of the Exadata infrastructure's data disk group, in terabytes (TB).
	DataStorageSizeInTBs *float64

	// The database server model type of the Exadata infrastructure. For the list of
	// valid model names, use the ListDbSystemShapes operation.
	DatabaseServerType *string

	// The size of the Exadata infrastructure's local node storage, in gigabytes (GB).
	DbNodeStorageSizeInGBs *int32

	// The software version of the database servers (dom0) in the Exadata
	// infrastructure.
	DbServerVersion *string

	// The user-friendly name for the Exadata infrastructure.
	DisplayName *string

	// The Oracle Cloud Identifier (OCID) of the last maintenance run for the Exadata
	// infrastructure.
	LastMaintenanceRunId *string

	// The scheduling details for the maintenance window. Patching and system updates
	// take place during the maintenance window.
	MaintenanceWindow *MaintenanceWindow

	// The total number of CPU cores available on the Exadata infrastructure.
	MaxCpuCount *int32

	// The total amount of data disk group storage, in terabytes (TB), that's
	// available on the Exadata infrastructure.
	MaxDataStorageInTBs *float64

	// The total amount of local node storage, in gigabytes (GB), that's available on
	// the Exadata infrastructure.
	MaxDbNodeStorageSizeInGBs *int32

	// The total amount of memory, in gigabytes (GB), that's available on the Exadata
	// infrastructure.
	MaxMemoryInGBs *int32

	// The amount of memory, in gigabytes (GB), that's allocated on the Exadata
	// infrastructure.
	MemorySizeInGBs *int32

	// The monthly software version of the database servers installed on the Exadata
	// infrastructure.
	MonthlyDbServerVersion *string

	// The monthly software version of the storage servers installed on the Exadata
	// infrastructure.
	MonthlyStorageServerVersion *string

	// The OCID of the next maintenance run for the Exadata infrastructure.
	NextMaintenanceRunId *string

	// The name of the OCI resource anchor for the Exadata infrastructure.
	OciResourceAnchorName *string

	// The HTTPS link to the Exadata infrastructure in OCI.
	OciUrl *string

	// The OCID of the Exadata infrastructure.
	Ocid *string

	// The amount of progress made on the current operation on the Exadata
	// infrastructure, expressed as a percentage.
	PercentProgress *float32

	// The model name of the Exadata infrastructure.
	Shape *string

	// The current status of the Exadata infrastructure.
	Status ResourceStatus

	// Additional information about the status of the Exadata infrastructure.
	StatusReason *string

	// The number of storage servers that are activated for the Exadata infrastructure.
	StorageCount *int32

	// The storage server model type of the Exadata infrastructure. For the list of
	// valid model names, use the ListDbSystemShapes operation.
	StorageServerType *string

	// The software version of the storage servers on the Exadata infrastructure.
	StorageServerVersion *string

	// The total amount of storage, in gigabytes (GB), on the the Exadata
	// infrastructure.
	TotalStorageSizeInGBs *int32

	noSmithyDocumentSerde
}

// Information about an Exadata infrastructure.
type CloudExadataInfrastructureSummary struct {

	// The unique identifier for the Exadata infrastructure.
	//
	// This member is required.
	CloudExadataInfrastructureId *string

	// The number of storage servers requested for the Exadata infrastructure.
	ActivatedStorageCount *int32

	// The number of storage servers requested for the Exadata infrastructure.
	AdditionalStorageCount *int32

	// The name of the Availability Zone (AZ) where the Exadata infrastructure is
	// located.
	AvailabilityZone *string

	// The AZ ID of the AZ where the Exadata infrastructure is located.
	AvailabilityZoneId *string

	// The amount of available storage, in gigabytes (GB), for the Exadata
	// infrastructure.
	AvailableStorageSizeInGBs *int32

	// The Amazon Resource Name (ARN) for the Exadata infrastructure.
	CloudExadataInfrastructureArn *string

	// The number of database servers for the Exadata infrastructure.
	ComputeCount *int32

	// The OCI model compute model used when you create or clone an instance: ECPU or
	// OCPU. An ECPU is an abstracted measure of compute resources. ECPUs are based on
	// the number of cores elastically allocated from a pool of compute and storage
	// servers. An OCPU is a legacy physical measure of compute resources. OCPUs are
	// based on the physical core of a processor with hyper-threading enabled.
	ComputeModel ComputeModel

	// The total number of CPU cores that are allocated to the Exadata infrastructure.
	CpuCount *int32

	// The date and time when the Exadata infrastructure was created.
	CreatedAt *time.Time

	// The email addresses of contacts to receive notification from Oracle about
	// maintenance updates for the Exadata infrastructure.
	CustomerContactsToSendToOCI []CustomerContact

	// The size of the Exadata infrastructure's data disk group, in terabytes (TB).
	DataStorageSizeInTBs *float64

	// The database server model type of the Exadata infrastructure. For the list of
	// valid model names, use the ListDbSystemShapes operation.
	DatabaseServerType *string

	// The size of the Exadata infrastructure's local node storage, in gigabytes (GB).
	DbNodeStorageSizeInGBs *int32

	// The software version of the database servers on the Exadata infrastructure.
	DbServerVersion *string

	// The user-friendly name for the Exadata infrastructure.
	DisplayName *string

	// The Oracle Cloud Identifier (OCID) of the last maintenance run for the Exadata
	// infrastructure.
	LastMaintenanceRunId *string

	// The scheduling details for the maintenance window. Patching and system updates
	// take place during the maintenance window.
	MaintenanceWindow *MaintenanceWindow

	// The total number of CPU cores available on the Exadata infrastructure.
	MaxCpuCount *int32

	// The total amount of data disk group storage, in terabytes (TB), that's
	// available on the Exadata infrastructure.
	MaxDataStorageInTBs *float64

	// The total amount of local node storage, in gigabytes (GB), that's available on
	// the Exadata infrastructure.
	MaxDbNodeStorageSizeInGBs *int32

	// The total amount of memory, in gigabytes (GB), that's available on the Exadata
	// infrastructure.
	MaxMemoryInGBs *int32

	// The amount of memory, in gigabytes (GB), that's allocated on the Exadata
	// infrastructure.
	MemorySizeInGBs *int32

	// The monthly software version of the database servers (dom0) installed on the
	// Exadata infrastructure.
	MonthlyDbServerVersion *string

	// The monthly software version of the storage servers installed on the Exadata
	// infrastructure.
	MonthlyStorageServerVersion *string

	// The OCID of the next maintenance run for the Exadata infrastructure.
	NextMaintenanceRunId *string

	// The name of the OCI resource anchor for the Exadata infrastructure.
	OciResourceAnchorName *string

	// The HTTPS link to the Exadata infrastructure in OCI.
	OciUrl *string

	// The OCID of the Exadata infrastructure.
	Ocid *string

	// The amount of progress made on the current operation on the Exadata
	// infrastructure, expressed as a percentage.
	PercentProgress *float32

	// The model name of the Exadata infrastructure.
	Shape *string

	// The current status of the Exadata infrastructure.
	Status ResourceStatus

	// Additional information about the status of the Exadata infrastructure.
	StatusReason *string

	// The number of storage servers that are activated for the Exadata infrastructure.
	StorageCount *int32

	// The storage server model type of the Exadata infrastructure. For the list of
	// valid model names, use the ListDbSystemShapes operation.
	StorageServerType *string

	// The software version of the storage servers on the Exadata infrastructure.
	StorageServerVersion *string

	// The total amount of storage, in gigabytes (GB), on the the Exadata
	// infrastructure.
	TotalStorageSizeInGBs *int32

	noSmithyDocumentSerde
}

// Information about unallocated resources in the Cloud Exadata infrastructure.
type CloudExadataInfrastructureUnallocatedResources struct {

	// A list of Autonomous VM clusters associated with this Cloud Exadata
	// Infrastructure.
	CloudAutonomousVmClusters []CloudAutonomousVmClusterResourceDetails

	// The display name of the Cloud Exadata infrastructure.
	CloudExadataInfrastructureDisplayName *string

	// The unique identifier of the Cloud Exadata infrastructure.
	CloudExadataInfrastructureId *string

	// The amount of unallocated Exadata storage available, in terabytes (TB).
	ExadataStorageInTBs *float64

	// The amount of unallocated local storage available, in gigabytes (GB).
	LocalStorageInGBs *int32

	// The amount of unallocated memory available, in gigabytes (GB).
	MemoryInGBs *int32

	// The number of unallocated Oracle CPU Units (OCPUs) available.
	Ocpus *int32

	noSmithyDocumentSerde
}

// Information about a VM cluster.
type CloudVmCluster struct {

	// The unique identifier of the VM cluster.
	//
	// This member is required.
	CloudVmClusterId *string

	// The unique identifier of the Exadata infrastructure that this VM cluster
	// belongs to.
	CloudExadataInfrastructureId *string

	// The Amazon Resource Name (ARN) of the VM cluster.
	CloudVmClusterArn *string

	// The name of the Grid Infrastructure (GI) cluster.
	ClusterName *string

	// The OCI model compute model used when you create or clone an instance: ECPU or
	// OCPU. An ECPU is an abstracted measure of compute resources. ECPUs are based on
	// the number of cores elastically allocated from a pool of compute and storage
	// servers. An OCPU is a legacy physical measure of compute resources. OCPUs are
	// based on the physical core of a processor with hyper-threading enabled.
	ComputeModel ComputeModel

	// The number of CPU cores enabled on the VM cluster.
	CpuCoreCount *int32

	// The date and time when the VM cluster was created.
	CreatedAt *time.Time

	// The set of diagnostic collection options enabled for the VM cluster.
	DataCollectionOptions *DataCollectionOptions

	// The size of the data disk group, in terabytes (TB), that's allocated for the VM
	// cluster.
	DataStorageSizeInTBs *float64

	// The amount of local node storage, in gigabytes (GB), that's allocated for the
	// VM cluster.
	DbNodeStorageSizeInGBs *int32

	// The list of database servers for the VM cluster.
	DbServers []string

	// The type of redundancy configured for the VM cluster. NORMAL is 2-way
	// redundancy. HIGH is 3-way redundancy.
	DiskRedundancy DiskRedundancy

	// The user-friendly name for the VM cluster.
	DisplayName *string

	// The domain of the VM cluster.
	Domain *string

	// The software version of the Oracle Grid Infrastructure (GI) for the VM cluster.
	GiVersion *string

	// The host name for the VM cluster.
	Hostname *string

	// The Amazon Web Services Identity and Access Management (IAM) service roles
	// associated with the VM cluster.
	IamRoles []IamRole

	// The ExadataIormConfig cache details for the VM cluster.
	IormConfigCache *ExadataIormConfig

	// Indicates whether database backups to local Exadata storage is enabled for the
	// VM cluster.
	IsLocalBackupEnabled *bool

	// Indicates whether the VM cluster is configured with a sparse disk group.
	IsSparseDiskgroupEnabled *bool

	// The Oracle Cloud ID (OCID) of the last maintenance update history entry.
	LastUpdateHistoryEntryId *string

	// The Oracle license model applied to the VM cluster.
	LicenseModel LicenseModel

	// The port number configured for the listener on the VM cluster.
	ListenerPort *int32

	// The amount of memory, in gigabytes (GB), that's allocated for the VM cluster.
	MemorySizeInGBs *int32

	// The number of nodes in the VM cluster.
	NodeCount *int32

	// The name of the OCI resource anchor for the VM cluster.
	OciResourceAnchorName *string

	// The HTTPS link to the VM cluster in OCI.
	OciUrl *string

	// The OCID of the VM cluster.
	Ocid *string

	// The unique identifier of the ODB network for the VM cluster.
	OdbNetworkId *string

	// The amount of progress made on the current operation on the VM cluster,
	// expressed as a percentage.
	PercentProgress *float32

	// The FQDN of the DNS record for the Single Client Access Name (SCAN) IP
	// addresses that are associated with the VM cluster.
	ScanDnsName *string

	// The OCID of the DNS record for the SCAN IP addresses that are associated with
	// the VM cluster.
	ScanDnsRecordId *string

	// The OCID of the SCAN IP addresses that are associated with the VM cluster.
	ScanIpIds []string

	// The hardware model name of the Exadata infrastructure that's running the VM
	// cluster.
	Shape *string

	// The public key portion of one or more key pairs used for SSH access to the VM
	// cluster.
	SshPublicKeys []string

	// The current status of the VM cluster.
	Status ResourceStatus

	// Additional information about the status of the VM cluster.
	StatusReason *string

	// The amount of local node storage, in gigabytes (GB), that's allocated to the VM
	// cluster.
	StorageSizeInGBs *int32

	// The operating system version of the image chosen for the VM cluster.
	SystemVersion *string

	// The time zone of the VM cluster.
	TimeZone *string

	// The virtual IP (VIP) addresses that are associated with the VM cluster.
	// Oracle's Cluster Ready Services (CRS) creates and maintains one VIP address for
	// each node in the VM cluster to enable failover. If one node fails, the VIP is
	// reassigned to another active node in the cluster.
	VipIds []string

	noSmithyDocumentSerde
}

// Information about a VM cluster.
type CloudVmClusterSummary struct {

	// The unique identifier of the VM cluster.
	//
	// This member is required.
	CloudVmClusterId *string

	// The unique identifier of the Exadata infrastructure that this VM cluster
	// belongs to.
	CloudExadataInfrastructureId *string

	// The Amazon Resource Name (ARN) of the VM cluster.
	CloudVmClusterArn *string

	// The name of the Grid Infrastructure (GI) cluster.
	ClusterName *string

	// The OCI model compute model used when you create or clone an instance: ECPU or
	// OCPU. An ECPU is an abstracted measure of compute resources. ECPUs are based on
	// the number of cores elastically allocated from a pool of compute and storage
	// servers. An OCPU is a legacy physical measure of compute resources. OCPUs are
	// based on the physical core of a processor with hyper-threading enabled.
	ComputeModel ComputeModel

	// The number of CPU cores enabled on the VM cluster.
	CpuCoreCount *int32

	// The date and time when the VM cluster was created.
	CreatedAt *time.Time

	// Information about the data collection options enabled for a VM cluster.
	DataCollectionOptions *DataCollectionOptions

	// The size of the data disk group, in terabytes (TB), that's allocated for the VM
	// cluster.
	DataStorageSizeInTBs *float64

	// The amount of local node storage, in gigabytes (GB), that's allocated for the
	// VM cluster.
	DbNodeStorageSizeInGBs *int32

	// The list of database servers for the VM cluster.
	DbServers []string

	// The type of redundancy configured for the VM cluster. NORMAL is 2-way
	// redundancy. HIGH is 3-way redundancy.
	DiskRedundancy DiskRedundancy

	// The user-friendly name for the VM cluster.
	DisplayName *string

	// The domain of the VM cluster.
	Domain *string

	// The software version of the Oracle Grid Infrastructure (GI) for the VM cluster.
	GiVersion *string

	// The host name for the VM cluster.
	Hostname *string

	// The Amazon Web Services Identity and Access Management (IAM) service roles
	// associated with the VM cluster in the summary information.
	IamRoles []IamRole

	// The IORM settings of the Exadata DB system.
	IormConfigCache *ExadataIormConfig

	// Indicates whether database backups to local Exadata storage is enabled for the
	// VM cluster.
	IsLocalBackupEnabled *bool

	// Indicates whether the VM cluster is configured with a sparse disk group.
	IsSparseDiskgroupEnabled *bool

	// The Oracle Cloud ID (OCID) of the last maintenance update history entry.
	LastUpdateHistoryEntryId *string

	// The Oracle license model applied to the VM cluster.
	LicenseModel LicenseModel

	// The port number configured for the listener on the VM cluster.
	ListenerPort *int32

	// The amount of memory, in gigabytes (GB), that's allocated for the VM cluster.
	MemorySizeInGBs *int32

	// The number of nodes in the VM cluster.
	NodeCount *int32

	// The name of the OCI resource anchor for the VM cluster.
	OciResourceAnchorName *string

	// The HTTPS link to the VM cluster in OCI.
	OciUrl *string

	// The OCID of the VM cluster.
	Ocid *string

	// The unique identifier of the ODB network for the VM cluster.
	OdbNetworkId *string

	// The amount of progress made on the current operation on the VM cluster,
	// expressed as a percentage.
	PercentProgress *float32

	// The FQDN of the DNS record for the Single Client Access Name (SCAN) IP
	// addresses that are associated with the VM cluster.
	ScanDnsName *string

	// The OCID of the DNS record for the SCAN IP addresses that are associated with
	// the VM cluster.
	ScanDnsRecordId *string

	// The OCID of the SCAN IP addresses that are associated with the VM cluster.
	ScanIpIds []string

	// The hardware model name of the Exadata infrastructure that's running the VM
	// cluster.
	Shape *string

	// The public key portion of one or more key pairs used for SSH access to the VM
	// cluster.
	SshPublicKeys []string

	// The current status of the VM cluster.
	Status ResourceStatus

	// Additional information about the status of the VM cluster.
	StatusReason *string

	// The amount of local node storage, in gigabytes (GB), that's allocated to the VM
	// cluster.
	StorageSizeInGBs *int32

	// The operating system version of the image chosen for the VM cluster.
	SystemVersion *string

	// The time zone of the VM cluster.
	TimeZone *string

	// The virtual IP (VIP) addresses that are associated with the VM cluster.
	// Oracle's Cluster Ready Services (CRS) creates and maintains one VIP address for
	// each node in the VM cluster to enable failover. If one node fails, the VIP is
	// reassigned to another active node in the cluster.
	VipIds []string

	noSmithyDocumentSerde
}

// The configuration access for the cross-Region Amazon S3 database restore source
// for the ODB network.
type CrossRegionS3RestoreSourcesAccess struct {

	// The IPv4 addresses allowed for cross-Region S3 restore access.
	Ipv4Addresses []string

	// The Amazon Web Services Region for cross-Region S3 restore access.
	Region *string

	// The current status of the cross-Region S3 restore access configuration.
	Status ManagedResourceStatus

	noSmithyDocumentSerde
}

// A contact to receive notification from Oracle about maintenance updates for a
// specific Exadata infrastructure.
type CustomerContact struct {

	// The email address of the contact.
	Email *string

	noSmithyDocumentSerde
}

// Information about the data collection options enabled for a VM cluster.
type DataCollectionOptions struct {

	// Indicates whether diagnostic collection is enabled for the VM cluster.
	IsDiagnosticsEventsEnabled *bool

	// Indicates whether health monitoring is enabled for the VM cluster.
	IsHealthMonitoringEnabled *bool

	// Indicates whether incident logs are enabled for the cloud VM cluster.
	IsIncidentLogsEnabled *bool

	noSmithyDocumentSerde
}

// An enumeration of days of the week used for scheduling maintenance windows.
type DayOfWeek struct {

	// The name of the day of the week.
	Name DayOfWeekName

	noSmithyDocumentSerde
}

// The IORM configuration settings for the database.
type DbIormConfig struct {

	// The database name. For the default DbPlan, the dbName is default .
	DbName *string

	// The flash cache limit for this database. This value is internally configured
	// based on the share value assigned to the database.
	FlashCacheLimit *string

	// The relative priority of this database.
	Share *int32

	noSmithyDocumentSerde
}

// Information about a DB node.
type DbNode struct {

	// Additional information about the planned maintenance.
	AdditionalDetails *string

	// The Oracle Cloud ID (OCID) of the backup IP address that's associated with the
	// DB node.
	BackupIpId *string

	// The OCID of the second backup VNIC.
	BackupVnic2Id *string

	// The OCID of the backup VNIC.
	BackupVnicId *string

	// Number of CPU cores enabled on the DB node.
	CpuCoreCount *int32

	// The date and time when the DB node was created.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the DB node.
	DbNodeArn *string

	// The unique identifier of the DB node.
	DbNodeId *string

	// The amount of local node storage, in gigabytes (GBs), that's allocated on the
	// DB node.
	DbNodeStorageSizeInGBs *int32

	// The unique identifier of the Db server that is associated with the DB node.
	DbServerId *string

	// The OCID of the DB system.
	DbSystemId *string

	// The name of the fault domain the instance is contained in.
	FaultDomain *string

	// The floating IP address assigned to the DB node.
	FloatingIpAddress *string

	// The OCID of the host IP address that's associated with the DB node.
	HostIpId *string

	// The host name for the DB node.
	Hostname *string

	// The type of database node maintenance. Either VMDB_REBOOT_MIGRATION or
	// EXADBXS_REBOOT_MIGRATION .
	MaintenanceType DbNodeMaintenanceType

	// The allocated memory in GBs on the DB node.
	MemorySizeInGBs *int32

	// The name of the OCI resource anchor for the DB node.
	OciResourceAnchorName *string

	// The OCID of the DB node.
	Ocid *string

	// The private IP address assigned to the DB node.
	PrivateIpAddress *string

	// The size (in GB) of the block storage volume allocation for the DB system.
	SoftwareStorageSizeInGB *int32

	// The current status of the DB node.
	Status DbNodeResourceStatus

	// Additional information about the status of the DB node.
	StatusReason *string

	// End date and time of maintenance window.
	TimeMaintenanceWindowEnd *string

	// Start date and time of maintenance window.
	TimeMaintenanceWindowStart *string

	// The total number of CPU cores reserved on the DB node.
	TotalCpuCoreCount *int32

	// The OCID of the second VNIC.
	Vnic2Id *string

	// The OCID of the VNIC.
	VnicId *string

	noSmithyDocumentSerde
}

// Information about a DB node.
type DbNodeSummary struct {

	// Additional information about the planned maintenance.
	AdditionalDetails *string

	// The Oracle Cloud ID (OCID) of the backup IP address that's associated with the
	// DB node.
	BackupIpId *string

	// The OCID of the second backup virtual network interface card (VNIC) for the DB
	// node.
	BackupVnic2Id *string

	// The OCID of the backup VNIC for the DB node.
	BackupVnicId *string

	// The number of CPU cores enabled on the DB node.
	CpuCoreCount *int32

	// The date and time when the DB node was created.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the DB node.
	DbNodeArn *string

	// The unique identifier of the DB node.
	DbNodeId *string

	// The amount of local node storage, in gigabytes (GB), that's allocated on the DB
	// node.
	DbNodeStorageSizeInGBs *int32

	// The unique identifier of the database server that's associated with the DB node.
	DbServerId *string

	// The OCID of the DB system.
	DbSystemId *string

	// The name of the fault domain where the DB node is located.
	FaultDomain *string

	// The OCID of the host IP address that's associated with the DB node.
	HostIpId *string

	// The host name for the DB node.
	Hostname *string

	// The type of maintenance the DB node.
	MaintenanceType DbNodeMaintenanceType

	// The amount of memory, in gigabytes (GB), that allocated on the DB node.
	MemorySizeInGBs *int32

	// The name of the OCI resource anchor for the DB node.
	OciResourceAnchorName *string

	// The OCID of the DB node.
	Ocid *string

	// The size of the block storage volume, in gigabytes (GB), that's allocated for
	// the DB system. This attribute applies only for virtual machine DB systems.
	SoftwareStorageSizeInGB *int32

	// The current status of the DB node.
	Status DbNodeResourceStatus

	// Additional information about the status of the DB node.
	StatusReason *string

	// The end date and time of the maintenance window.
	TimeMaintenanceWindowEnd *string

	// The start date and time of the maintenance window.
	TimeMaintenanceWindowStart *string

	// The total number of CPU cores reserved on the DB node.
	TotalCpuCoreCount *int32

	// The OCID of the second VNIC.
	Vnic2Id *string

	// The OCID of the VNIC.
	VnicId *string

	noSmithyDocumentSerde
}

// Information about a database server.
type DbServer struct {

	// The list of unique identifiers for the Autonomous VMs associated with this
	// database server.
	AutonomousVirtualMachineIds []string

	// The list of identifiers for the Autonomous VM clusters associated with this
	// database server.
	AutonomousVmClusterIds []string

	// The compute model of the database server (ECPU or OCPU).
	ComputeModel ComputeModel

	// The number of CPU cores enabled on the database server.
	CpuCoreCount *int32

	// The date and time when the database server was created.
	CreatedAt *time.Time

	// The allocated local node storage in GBs on the database server.
	DbNodeStorageSizeInGBs *int32

	// The unique identifier for the database server.
	DbServerId *string

	// The scheduling details for the quarterly maintenance window. Patching and
	// system updates take place during the maintenance window.
	DbServerPatchingDetails *DbServerPatchingDetails

	// The user-friendly name of the database server.
	DisplayName *string

	// The ID of the Exadata infrastructure the database server belongs to.
	ExadataInfrastructureId *string

	// The total number of CPU cores available.
	MaxCpuCount *int32

	// The total local node storage available in GBs.
	MaxDbNodeStorageInGBs *int32

	// The total memory available in GBs.
	MaxMemoryInGBs *int32

	// The allocated memory in GBs on the database server.
	MemorySizeInGBs *int32

	// The name of the OCI resource anchor for the database server.
	OciResourceAnchorName *string

	// The OCID of the database server.
	Ocid *string

	// The shape of the database server. The shape determines the amount of CPU,
	// storage, and memory resources available.
	Shape *string

	// The current status of the database server.
	Status ResourceStatus

	// Additional information about the current status of the database server.
	StatusReason *string

	// The OCID of the VM clusters that are associated with the database server.
	VmClusterIds []string

	noSmithyDocumentSerde
}

// The scheduling details for the quarterly maintenance window. Patching and
// system updates take place during the maintenance window.
type DbServerPatchingDetails struct {

	// Estimated time, in minutes, to patch one database server.
	EstimatedPatchDuration *int32

	// The status of the patching operation. Possible values are SCHEDULED ,
	// MAINTENANCE_IN_PROGRESS , FAILED , and COMPLETE .
	PatchingStatus DbServerPatchingStatus

	// The time when the patching operation ended.
	TimePatchingEnded *string

	// The time when the patching operation started.
	TimePatchingStarted *string

	noSmithyDocumentSerde
}

// Information about a database server.
type DbServerSummary struct {

	// A list of unique identifiers for the Autonomous VMs.
	AutonomousVirtualMachineIds []string

	// A list of identifiers for the Autonomous VM clusters.
	AutonomousVmClusterIds []string

	// The OCI model compute model used when you create or clone an instance: ECPU or
	// OCPU. An ECPU is an abstracted measure of compute resources. ECPUs are based on
	// the number of cores elastically allocated from a pool of compute and storage
	// servers. An OCPU is a legacy physical measure of compute resources. OCPUs are
	// based on the physical core of a processor with hyper-threading enabled.
	ComputeModel ComputeModel

	// The number of CPU cores enabled on the database server.
	CpuCoreCount *int32

	// The date and time when the database server was created.
	CreatedAt *time.Time

	// The amount of local node storage, in gigabytes (GB), that's allocated on the
	// database server.
	DbNodeStorageSizeInGBs *int32

	// The unique identifier of the database server.
	DbServerId *string

	// The scheduling details for the quarterly maintenance window. Patching and
	// system updates take place during the maintenance window.
	DbServerPatchingDetails *DbServerPatchingDetails

	// The user-friendly name of the database server. The name doesn't need to be
	// unique.
	DisplayName *string

	// The ID of the Exadata infrastructure that hosts the database server.
	ExadataInfrastructureId *string

	// The total number of CPU cores available on the database server.
	MaxCpuCount *int32

	// The total amount of local node storage, in gigabytes (GB), that's available on
	// the database server.
	MaxDbNodeStorageInGBs *int32

	// The total amount of memory, in gigabytes (GB), that's available on the database
	// server.
	MaxMemoryInGBs *int32

	// The amount of memory, in gigabytes (GB), that's allocated on the database
	// server.
	MemorySizeInGBs *int32

	// The name of the OCI resource anchor for the database server.
	OciResourceAnchorName *string

	// The OCID of the database server.
	Ocid *string

	// The hardware system model of the Exadata infrastructure that the database
	// server is hosted on. The shape determines the amount of CPU, storage, and memory
	// resources available.
	Shape *string

	// The current status of the database server.
	Status ResourceStatus

	// Additional information about the status of the database server.
	StatusReason *string

	// The IDs of the VM clusters that are associated with the database server.
	VmClusterIds []string

	noSmithyDocumentSerde
}

// Information about a hardware system model (shape) that's available for an
// Exadata infrastructure. The shape determines resources, such as CPU cores,
// memory, and storage, to allocate to the Exadata infrastructure.
type DbSystemShapeSummary struct {

	// Indicates whether the hardware system model supports configurable database and
	// server storage types.
	AreServerTypesSupported *bool

	// The maximum number of CPU cores that can be enabled for the shape.
	AvailableCoreCount *int32

	// The maximum number of CPU cores per DB node that can be enabled for the shape.
	AvailableCoreCountPerNode *int32

	// The maximum amount of data storage, in terabytes (TB), that can be enabled for
	// the shape.
	AvailableDataStorageInTBs *int32

	// The maximum amount of data storage, in terabytes (TB), that's available per
	// storage server for the shape.
	AvailableDataStoragePerServerInTBs *int32

	// The maximum amount of DB node storage, in gigabytes (GB), that's available per
	// DB node for the shape.
	AvailableDbNodePerNodeInGBs *int32

	// The maximum amount of DB node storage, in gigabytes (GB), that can be enabled
	// for the shape.
	AvailableDbNodeStorageInGBs *int32

	// The maximum amount of memory, in gigabytes (GB), that can be enabled for the
	// shape.
	AvailableMemoryInGBs *int32

	// The maximum amount of memory, in gigabytes (GB), that's available per DB node
	// for the shape.
	AvailableMemoryPerNodeInGBs *int32

	// The OCI model compute model used when you create or clone an instance: ECPU or
	// OCPU. An ECPU is an abstracted measure of compute resources. ECPUs are based on
	// the number of cores elastically allocated from a pool of compute and storage
	// servers. An OCPU is a legacy physical measure of compute resources. OCPUs are
	// based on the physical core of a processor with hyper-threading enabled.
	ComputeModel ComputeModel

	// The discrete number by which the CPU core count for the shape can be increased
	// or decreased.
	CoreCountIncrement *int32

	// The maximum number of Exadata storage servers that's available for the shape.
	MaxStorageCount *int32

	// The maximum number of compute servers that is available for the shape.
	MaximumNodeCount *int32

	// The minimum number of CPU cores that can be enabled per node for the shape.
	MinCoreCountPerNode *int32

	// The minimum amount of data storage, in terabytes (TB), that must be allocated
	// for the shape.
	MinDataStorageInTBs *int32

	// The minimum amount of DB node storage, in gigabytes (GB), that must be
	// allocated per DB node for the shape.
	MinDbNodeStoragePerNodeInGBs *int32

	// The minimum amount of memory, in gigabytes (GB), that must be allocated per DB
	// node for the shape.
	MinMemoryPerNodeInGBs *int32

	// The minimum number of Exadata storage servers that are available for the shape.
	MinStorageCount *int32

	// The minimum number of CPU cores that can be enabled for the shape.
	MinimumCoreCount *int32

	// The minimum number of compute servers that are available for the shape.
	MinimumNodeCount *int32

	// The name of the shape.
	Name *string

	// The runtime minimum number of CPU cores that can be enabled for the shape.
	RuntimeMinimumCoreCount *int32

	// The family of the shape.
	ShapeFamily *string

	// The shape type. This property is determined by the CPU hardware.
	ShapeType ShapeType

	noSmithyDocumentSerde
}

// The IORM settings of the Exadata DB system.
type ExadataIormConfig struct {

	// An array of IORM settings for all the database in the Exadata DB system.
	DbPlans []DbIormConfig

	// Additional information about the current lifecycleState.
	LifecycleDetails *string

	// The current state of IORM configuration for the Exadata DB system.
	LifecycleState IormLifecycleState

	// The current value for the IORM objective. The default is AUTO.
	Objective Objective

	noSmithyDocumentSerde
}

// Information about a specific version of Oracle Grid Infrastructure (GI)
// software that can be installed on a VM cluster.
type GiVersionSummary struct {

	// The GI software version.
	Version *string

	noSmithyDocumentSerde
}

// Information about an Amazon Web Services Identity and Access Management (IAM)
// service role associated with a resource.
type IamRole struct {

	// The Amazon Web Services integration configuration settings for the IAM service
	// role.
	AwsIntegration SupportedAwsIntegration

	// The Amazon Resource Name (ARN) of the IAM service role.
	IamRoleArn *string

	// The current status of the IAM service role.
	Status IamRoleStatus

	// Additional information about the current status of the IAM service role, if
	// applicable.
	StatusReason *string

	noSmithyDocumentSerde
}

// Configuration for Amazon Web Services Key Management Service (KMS) access from
// the ODB network.
type KmsAccess struct {

	// The domain name for KMS access configuration.
	DomainName *string

	// The IPv4 addresses allowed for KMS access.
	Ipv4Addresses []string

	// The KMS policy document that defines permissions for key usage.
	KmsPolicyDocument *string

	// The current status of the KMS access configuration.
	Status ManagedResourceStatus

	noSmithyDocumentSerde
}

// The scheduling details for the maintenance window. Patching and system updates
// take place during the maintenance window.
type MaintenanceWindow struct {

	// The custom action timeout in minutes for the maintenance window.
	CustomActionTimeoutInMins *int32

	// The days of the week when maintenance can be performed.
	DaysOfWeek []DayOfWeek

	// The hours of the day when maintenance can be performed.
	HoursOfDay []int32

	// Indicates whether custom action timeout is enabled for the maintenance window.
	IsCustomActionTimeoutEnabled *bool

	// The lead time in weeks before the maintenance window.
	LeadTimeInWeeks *int32

	// The months when maintenance can be performed.
	Months []Month

	// The patching mode for the maintenance window.
	PatchingMode PatchingModeType

	// The preference for the maintenance window scheduling.
	Preference PreferenceType

	// Indicates whether to skip release updates during maintenance.
	SkipRu *bool

	// The weeks of the month when maintenance can be performed.
	WeeksOfMonth []int32

	noSmithyDocumentSerde
}

// The configuration for managed Amazon S3 backup access from the ODB network.
type ManagedS3BackupAccess struct {

	// The IPv4 addresses for the managed Amazon S3 backup access.
	Ipv4Addresses []string

	// The status of the managed Amazon S3 backup access.
	Status ManagedResourceStatus

	noSmithyDocumentSerde
}

// The managed services configuration for the ODB network.
type ManagedServices struct {

	// The access configuration for the cross-Region Amazon S3 database restore source.
	CrossRegionS3RestoreSourcesAccess []CrossRegionS3RestoreSourcesAccess

	// The Amazon Web Services Key Management Service (KMS) access configuration for
	// managed services.
	KmsAccess *KmsAccess

	// The managed Amazon S3 backup access configuration.
	ManagedS3BackupAccess *ManagedS3BackupAccess

	// The IPv4 CIDR blocks for the managed services.
	ManagedServicesIpv4Cidrs []string

	// The Amazon Resource Name (ARN) of the resource gateway.
	ResourceGatewayArn *string

	// The Amazon S3 access configuration.
	S3Access *S3Access

	// The Amazon Resource Name (ARN) of the service network.
	ServiceNetworkArn *string

	// The service network endpoint configuration.
	ServiceNetworkEndpoint *ServiceNetworkEndpoint

	// The Amazon Web Services Security Token Service (STS) access configuration for
	// managed services.
	StsAccess *StsAccess

	// The Zero-ETL access configuration.
	ZeroEtlAccess *ZeroEtlAccess

	noSmithyDocumentSerde
}

// An enumeration of months used for scheduling maintenance windows.
type Month struct {

	// The name of the month.
	Name MonthName

	noSmithyDocumentSerde
}

// DNS configuration to forward DNS resolver endpoints to your OCI Private Zone.
type OciDnsForwardingConfig struct {

	// Domain name to which DNS resolver forwards to.
	DomainName *string

	// OCI DNS listener IP for custom DNS setup.
	OciDnsListenerIp *string

	noSmithyDocumentSerde
}

// Information about an Oracle Cloud Infrastructure (OCI) identity domain
// configuration.
type OciIdentityDomain struct {

	// The Amazon Web Services CloudFormation URL for setting up the account
	// integration with the OCI identity domain.
	AccountSetupCloudFormationUrl *string

	// The unique identifier of the OCI identity domain.
	OciIdentityDomainId *string

	// The resource URL for accessing the OCI identity domain.
	OciIdentityDomainResourceUrl *string

	// The URL of the OCI identity domain.
	OciIdentityDomainUrl *string

	// The current status of the OCI identity domain.
	Status ResourceStatus

	// Additional information about the current status of the OCI identity domain, if
	// applicable.
	StatusReason *string

	noSmithyDocumentSerde
}

// Information about an ODB network.
type OdbNetwork struct {

	// The unique identifier of the ODB network.
	//
	// This member is required.
	OdbNetworkId *string

	// The Amazon Web Services Availability Zone (AZ) where the ODB network is located.
	AvailabilityZone *string

	// The AZ ID of the AZ where the ODB network is located.
	AvailabilityZoneId *string

	// The CIDR range of the backup subnet in the ODB network.
	BackupSubnetCidr *string

	// The CIDR range of the client subnet in the ODB network.
	ClientSubnetCidr *string

	// The date and time when the ODB network was created.
	CreatedAt *time.Time

	// The domain name for the resources in the ODB network.
	CustomDomainName *string

	// The DNS prefix to the default DNS domain name. The default DNS domain name is
	// oraclevcn.com.
	DefaultDnsPrefix *string

	// The user-friendly name of the ODB network.
	DisplayName *string

	// The managed services configuration for the ODB network.
	ManagedServices *ManagedServices

	// The DNS resolver endpoint in OCI for forwarding DNS queries for the
	// ociPrivateZone domain.
	OciDnsForwardingConfigs []OciDnsForwardingConfig

	// The unique identifier of the OCI network anchor for the ODB network.
	OciNetworkAnchorId *string

	// The URL of the OCI network anchor for the ODB network.
	OciNetworkAnchorUrl *string

	// The name of the OCI resource anchor that's associated with the ODB network.
	OciResourceAnchorName *string

	// The Oracle Cloud ID (OCID) for the Virtual Cloud Network (VCN) that's
	// associated with the ODB network.
	OciVcnId *string

	// The URL for the VCN that's associated with the ODB network.
	OciVcnUrl *string

	// The Amazon Resource Name (ARN) of the ODB network.
	OdbNetworkArn *string

	// The list of CIDR ranges from the peered VPC that are allowed access to the ODB
	// network.
	PeeredCidrs []string

	// The amount of progress made on the current operation on the ODB network,
	// expressed as a percentage.
	PercentProgress *float32

	// The current status of the ODB network.
	Status ResourceStatus

	// Additional information about the current status of the ODB network.
	StatusReason *string

	noSmithyDocumentSerde
}

// Information about an ODB network.
type OdbNetworkSummary struct {

	// The unique identifier of the ODB network.
	//
	// This member is required.
	OdbNetworkId *string

	// The Amazon Web Services Availability Zone (AZ) where the ODB network is located.
	AvailabilityZone *string

	// The AZ ID of the AZ where the ODB network is located.
	AvailabilityZoneId *string

	// The CIDR range of the backup subnet in the ODB network.
	BackupSubnetCidr *string

	// The CIDR range of the client subnet in the ODB network.
	ClientSubnetCidr *string

	// The date and time when the ODB network was created.
	CreatedAt *time.Time

	// The domain name for the resources in the ODB network.
	CustomDomainName *string

	// The DNS prefix to the default DNS domain name. The default DNS domain name is
	// oraclevcn.com.
	DefaultDnsPrefix *string

	// The user-friendly name of the ODB network.
	DisplayName *string

	// The managed services configuration for the ODB network.
	ManagedServices *ManagedServices

	// The DNS resolver endpoint in OCI for forwarding DNS queries for the
	// ociPrivateZone domain.
	OciDnsForwardingConfigs []OciDnsForwardingConfig

	// The unique identifier of the OCI network anchor for the ODB network.
	OciNetworkAnchorId *string

	// The URL of the OCI network anchor for the ODB network.
	OciNetworkAnchorUrl *string

	// The name of the OCI resource anchor associated with the ODB network.
	OciResourceAnchorName *string

	// The Oracle Cloud ID (OCID) for the Virtual Cloud Network (VCN) associated with
	// the ODB network.
	OciVcnId *string

	// The URL for the VCN that's associated with the ODB network.
	OciVcnUrl *string

	// The Amazon Resource Name (ARN) of the ODB network.
	OdbNetworkArn *string

	// The list of CIDR ranges from the peered VPC that are allowed access to the ODB
	// network.
	PeeredCidrs []string

	// The amount of progress made on the current operation on the ODB network,
	// expressed as a percentage.
	PercentProgress *float32

	// The current status of the ODB network.
	Status ResourceStatus

	// Additional information about the current status of the ODB network.
	StatusReason *string

	noSmithyDocumentSerde
}

// A peering connection between an ODB network and either another ODB network or a
// customer-owned VPC.
type OdbPeeringConnection struct {

	// The unique identifier of the ODB peering connection. A sample ID is
	// odbpcx-abcdefgh12345678 .
	//
	// This member is required.
	OdbPeeringConnectionId *string

	// The timestamp when the ODB peering connection was created.
	CreatedAt *time.Time

	// The display name of the ODB peering connection.
	DisplayName *string

	// The Amazon Resource Name (ARN) of the ODB network that initiated the peering
	// connection.
	OdbNetworkArn *string

	// The Amazon Resource Name (ARN) of the ODB peering connection.
	//
	// Example:
	// arn:aws:odb:us-east-1:123456789012:odb-peering-connection/odbpcx-abcdefgh12345678
	OdbPeeringConnectionArn *string

	// The type of the ODB peering connection.
	//
	// Valid Values: ODB-VPC | ODB-ODB
	OdbPeeringConnectionType *string

	// The Amazon Resource Name (ARN) of the peer network.
	PeerNetworkArn *string

	// The CIDR blocks associated with the peering connection. These CIDR blocks
	// define the IP address ranges that can communicate through the peering
	// connection.
	PeerNetworkCidrs []string

	// The percentage progress of the ODB peering connection creation or deletion.
	PercentProgress *float32

	// The status of the ODB peering connection.
	Status ResourceStatus

	// The reason for the current status of the ODB peering connection.
	StatusReason *string

	noSmithyDocumentSerde
}

// A summary of an ODB peering connection.
type OdbPeeringConnectionSummary struct {

	// The unique identifier of the ODB peering connection. A sample ID is
	// odbpcx-abcdefgh12345678 .
	//
	// This member is required.
	OdbPeeringConnectionId *string

	// The timestamp when the ODB peering connection was created.
	CreatedAt *time.Time

	// The display name of the ODB peering connection.
	DisplayName *string

	// The Amazon Resource Name (ARN) of the ODB network that initiated the peering
	// connection.
	OdbNetworkArn *string

	// The Amazon Resource Name (ARN) of the ODB peering connection.
	OdbPeeringConnectionArn *string

	// The type of the ODB peering connection.
	//
	// Valid Values: ODB-VPC | ODB-ODB
	OdbPeeringConnectionType *string

	// The Amazon Resource Name (ARN) of the peer network.
	PeerNetworkArn *string

	// The CIDR blocks associated with the peering connection. These CIDR blocks
	// define the IP address ranges that can communicate through the peering
	// connection.
	PeerNetworkCidrs []string

	// The percentage progress of the ODB peering connection creation or deletion.
	PercentProgress *float32

	// The status of the ODB peering connection.
	Status ResourceStatus

	// The reason for the current status of the ODB peering connection.
	StatusReason *string

	noSmithyDocumentSerde
}

// The configuration for Amazon S3 access from the ODB network.
type S3Access struct {

	// The domain name for the Amazon S3 access.
	DomainName *string

	// The IPv4 addresses for the Amazon S3 access.
	Ipv4Addresses []string

	// The endpoint policy for the Amazon S3 access.
	S3PolicyDocument *string

	// The status of the Amazon S3 access.
	Status ManagedResourceStatus

	noSmithyDocumentSerde
}

// The configuration for a service network endpoint.
type ServiceNetworkEndpoint struct {

	// The identifier of the VPC endpoint.
	VpcEndpointId *string

	// The type of the VPC endpoint.
	VpcEndpointType VpcEndpointType

	noSmithyDocumentSerde
}

// Configuration for Amazon Web Services Security Token Service (STS) access from
// the ODB network.
type StsAccess struct {

	// The domain name for STS access configuration.
	DomainName *string

	// The IPv4 addresses allowed for STS access.
	Ipv4Addresses []string

	// The current status of the STS access configuration.
	Status ManagedResourceStatus

	// The STS policy document that defines permissions for token service usage.
	StsPolicyDocument *string

	noSmithyDocumentSerde
}

// Information about the compatible system versions that can be used with a
// specific Exadata shape and Grid Infrastructure (GI) version.
type SystemVersionSummary struct {

	// The version of GI software.
	GiVersion *string

	// The Exadata hardware model.
	Shape *string

	// The Exadata system versions that are compatible with the specified Exadata
	// shape and GI version.
	SystemVersions []string

	noSmithyDocumentSerde
}

// The input failed to meet the constraints specified by the service in a
// specified field. Make sure you provided the correct input and try again.
type ValidationExceptionField struct {

	// The description of the error.
	//
	// This member is required.
	Message *string

	// The field name for which validation failed.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The configuration for Zero-ETL access from the ODB network.
type ZeroEtlAccess struct {

	// The CIDR block for the Zero-ETL access.
	Cidr *string

	// The status of the Zero-ETL access.
	Status ManagedResourceStatus

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
