// Code generated by smithy-go-codegen DO NOT EDIT.

package omics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/omics/document"
	"github.com/aws/aws-sdk-go-v2/service/omics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts a new run and returns details about the run, or duplicates an existing
// run. A run is a single invocation of a workflow. If you provide request IDs,
// Amazon Web Services HealthOmics identifies duplicate requests and starts the run
// only once. Monitor the progress of the run by calling the GetRun API operation.
//
// To start a new run, the following inputs are required:
//
//   - A service role ARN ( roleArn ).
//
//   - The run's workflow ID ( workflowId , not the uuid or runId ).
//
//   - An Amazon S3 location ( outputUri ) where the run outputs will be saved.
//
//   - All required workflow parameters ( parameter ), which can include optional
//     parameters from the parameter template. The run cannot include any parameters
//     that are not defined in the parameter template. To see all possible parameters,
//     use the GetRun API operation.
//
//   - For runs with a STATIC (default) storage type, specify the required storage
//     capacity (in gibibytes). A storage capacity value is not required for runs that
//     use DYNAMIC storage.
//
// StartRun can also duplicate an existing run using the run's default values. You
// can modify these default values and/or add other optional inputs. To duplicate a
// run, the following inputs are required:
//
//   - A service role ARN ( roleArn ).
//
//   - The ID of the run to duplicate ( runId ).
//
//   - An Amazon S3 location where the run outputs will be saved ( outputUri ).
//
// To learn more about the optional parameters for StartRun , see [Starting a run] in the Amazon
// Web Services HealthOmics User Guide.
//
// Use the retentionMode input to control how long the metadata for each run is
// stored in CloudWatch. There are two retention modes:
//
//   - Specify REMOVE to automatically remove the oldest runs when you reach the
//     maximum service retention limit for runs. It is recommended that you use the
//     REMOVE mode to initiate major run requests so that your runs do not fail when
//     you reach the limit.
//
//   - The retentionMode is set to the RETAIN mode by default, which allows you to
//     manually remove runs after reaching the maximum service retention limit. Under
//     this setting, you cannot create additional runs until you remove the excess
//     runs.
//
// To learn more about the retention modes, see [Run retention mode] in the Amazon Web Services
// HealthOmics User Guide.
//
// You can use Amazon Q CLI to analyze run logs and make performance optimization
// recommendations. To get started, see the [Amazon Web Services HealthOmics MCP server]on GitHub.
//
// [Starting a run]: https://docs.aws.amazon.com/omics/latest/dev/starting-a-run.html
// [Amazon Web Services HealthOmics MCP server]: https://github.com/awslabs/mcp/tree/main/src/aws-healthomics-mcp-server
// [Run retention mode]: https://docs.aws.amazon.com/omics/latest/dev/run-retention.html
func (c *Client) StartRun(ctx context.Context, params *StartRunInput, optFns ...func(*Options)) (*StartRunOutput, error) {
	if params == nil {
		params = &StartRunInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartRun", params, optFns, c.addOperationStartRunMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartRunOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartRunInput struct {

	// An output S3 URI for the run. The S3 bucket must be in the same region as the
	// workflow. The role ARN must have permission to write to this S3 bucket.
	//
	// This member is required.
	OutputUri *string

	// An idempotency token used to dedupe retry requests so that duplicate runs are
	// not created.
	//
	// This member is required.
	RequestId *string

	// A service role for the run. The roleArn requires access to Amazon Web Services
	// HealthOmics, S3, Cloudwatch logs, and EC2. An example roleArn is
	// arn:aws:iam::123456789012:role/omics-service-role-serviceRole-W8O1XMPL7QZ . In
	// this example, the AWS account ID is 123456789012 and the role name is
	// omics-service-role-serviceRole-W8O1XMPL7QZ .
	//
	// This member is required.
	RoleArn *string

	// The cache behavior for the run. You specify this value if you want to override
	// the default behavior for the cache. You had set the default value when you
	// created the cache. For more information, see [Run cache behavior]in the Amazon Web Services
	// HealthOmics User Guide.
	//
	// [Run cache behavior]: https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior
	CacheBehavior types.CacheBehavior

	// Identifier of the cache associated with this run. If you don't specify a cache
	// ID, no task outputs are cached for this run.
	CacheId *string

	// A log level for the run.
	LogLevel types.RunLogLevel

	// A name for the run. This is recommended to view and organize runs in the Amazon
	// Web Services HealthOmics console and CloudWatch logs.
	Name *string

	// Parameters for the run. The run needs all required parameters and can include
	// optional parameters. The run cannot include any parameters that are not defined
	// in the parameter template. To retrieve parameters from the run, use the GetRun
	// API operation.
	Parameters document.Interface

	// Use the run priority (highest: 1) to establish the order of runs in a run group
	// when you start a run. If multiple runs share the same priority, the run that was
	// initiated first will have the higher priority. Runs that do not belong to a run
	// group can be assigned a priority. The priorities of these runs are ranked among
	// other runs that are not in a run group. For more information, see [Run priority]in the Amazon
	// Web Services HealthOmics User Guide.
	//
	// [Run priority]: https://docs.aws.amazon.com/omics/latest/dev/creating-run-groups.html#run-priority
	Priority *int32

	// The retention mode for the run. The default value is RETAIN .
	//
	// Amazon Web Services HealthOmics stores a fixed number of runs that are
	// available to the console and API. In the default mode ( RETAIN ), you need to
	// remove runs manually when the number of run exceeds the maximum. If you set the
	// retention mode to REMOVE , Amazon Web Services HealthOmics automatically removes
	// runs (that have mode set to REMOVE ) when the number of run exceeds the maximum.
	// All run logs are available in CloudWatch logs, if you need information about a
	// run that is no longer available to the API.
	//
	// For more information about retention mode, see [Specifying run retention mode] in the Amazon Web Services
	// HealthOmics User Guide.
	//
	// [Specifying run retention mode]: https://docs.aws.amazon.com/omics/latest/dev/starting-a-run.html
	RetentionMode types.RunRetentionMode

	// The run's group ID. Use a run group to cap the compute resources (and number of
	// concurrent runs) for the runs that you add to the run group.
	RunGroupId *string

	// The ID of a run to duplicate.
	RunId *string

	// The STATIC storage capacity (in gibibytes, GiB) for this run. The default run
	// storage capacity is 1200 GiB. If your requested storage capacity is unavailable,
	// the system rounds up the value to the nearest 1200 GiB multiple. If the
	// requested storage capacity is still unavailable, the system rounds up the value
	// to the nearest 2400 GiB multiple. This field is not required if the storage type
	// is DYNAMIC (the system ignores any value that you enter).
	StorageCapacity *int32

	// The storage type for the run. If you set the storage type to DYNAMIC , Amazon
	// Web Services HealthOmics dynamically scales the storage up or down, based on
	// file system utilization. By default, the run uses STATIC storage type, which
	// allocates a fixed amount of storage. For more information about DYNAMIC and
	// STATIC storage, see [Run storage types] in the Amazon Web Services HealthOmics User Guide.
	//
	// [Run storage types]: https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html
	StorageType types.StorageType

	// Tags for the run. You can add up to 50 tags per run. For more information, see [Adding a tag]
	// in the Amazon Web Services HealthOmics User Guide.
	//
	// [Adding a tag]: https://docs.aws.amazon.com/omics/latest/dev/add-a-tag.html
	Tags map[string]string

	// The run's workflow ID. The workflowId is not the UUID.
	WorkflowId *string

	// The 12-digit account ID of the workflow owner that is used for running a shared
	// workflow. The workflow owner ID can be retrieved using the GetShare API
	// operation. If you are the workflow owner, you do not need to include this ID.
	WorkflowOwnerId *string

	// The run's workflow type. The workflowType must be specified if you are running
	// a READY2RUN workflow. If you are running a PRIVATE workflow (default), you do
	// not need to include the workflow type.
	WorkflowType types.WorkflowType

	// The name of the workflow version. Use workflow versions to track and organize
	// changes to the workflow. If your workflow has multiple versions, the run uses
	// the default version unless you specify a version name. To learn more, see [Workflow versioning]in
	// the Amazon Web Services HealthOmics User Guide.
	//
	// [Workflow versioning]: https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html
	WorkflowVersionName *string

	noSmithyDocumentSerde
}

type StartRunOutput struct {

	// Unique resource identifier for the run.
	Arn *string

	// The run's ID.
	Id *string

	// The destination for workflow outputs.
	RunOutputUri *string

	// The run's status.
	Status types.RunStatus

	// The run's tags.
	Tags map[string]string

	// The universally unique identifier for a run.
	Uuid *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartRunMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartRun{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartRun{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartRun"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opStartRunMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartRunMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartRunValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartRun(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opStartRunMiddleware struct {
}

func (*endpointPrefix_opStartRunMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opStartRunMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "workflows-" + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opStartRunMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opStartRunMiddleware{}, "ResolveEndpointV2", middleware.After)
}

type idempotencyToken_initializeOpStartRun struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartRun) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartRun) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartRunInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartRunInput ")
	}

	if input.RequestId == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.RequestId = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartRunMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartRun{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartRun(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartRun",
	}
}
