// Code generated by smithy-go-codegen DO NOT EDIT.

package organizations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/organizations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists all the validation errors on an [effective policy] for a specified account and policy type.
//
// You can only call this operation from the management account or a member
// account that is a delegated administrator.
//
// [effective policy]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_effective.html
func (c *Client) ListEffectivePolicyValidationErrors(ctx context.Context, params *ListEffectivePolicyValidationErrorsInput, optFns ...func(*Options)) (*ListEffectivePolicyValidationErrorsOutput, error) {
	if params == nil {
		params = &ListEffectivePolicyValidationErrorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEffectivePolicyValidationErrors", params, optFns, c.addOperationListEffectivePolicyValidationErrorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEffectivePolicyValidationErrorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEffectivePolicyValidationErrorsInput struct {

	// The ID of the account that you want details about. Specifying an organization
	// root or organizational unit (OU) as the target is not supported.
	//
	// This member is required.
	AccountId *string

	// The type of policy that you want information about. You can specify one of the
	// following values:
	//
	// [DECLARATIVE_POLICY_EC2]
	//
	// [BACKUP_POLICY]
	//
	// [TAG_POLICY]
	//
	// [CHATBOT_POLICY]
	//
	// [AISERVICES_OPT_OUT_POLICY]
	//
	// [SECURITYHUB_POLICY]
	//
	// [UPGRADE_ROLLOUT_POLICY]
	//
	// [INSPECTOR_POLICY]
	//
	// [BEDROCK_POLICY]
	//
	// [S3_POLICY]
	//
	// [AISERVICES_OPT_OUT_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html
	// [BEDROCK_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_bedrock.html
	// [UPGRADE_ROLLOUT_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_upgrade_rollout.html
	// [SECURITYHUB_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html
	// [BACKUP_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html
	// [CHATBOT_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html
	// [TAG_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html
	// [DECLARATIVE_POLICY_EC2]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html
	// [INSPECTOR_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_inspector.html
	// [S3_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_S3.html
	//
	// This member is required.
	PolicyType types.EffectivePolicyType

	// The maximum number of items to return in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response so
	// that you can retrieve the remaining results.
	MaxResults *int32

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more output
	// is available. Set this parameter to the value of the previous call's NextToken
	// response to indicate where the output should continue from.
	NextToken *string

	noSmithyDocumentSerde
}

type ListEffectivePolicyValidationErrorsOutput struct {

	// The ID of the specified account.
	AccountId *string

	// The EffectivePolicyValidationError object contains details about the validation
	// errors that occurred when generating or enforcing an effective policy, such as
	// which policies contributed to the error and location of the error.
	EffectivePolicyValidationErrors []types.EffectivePolicyValidationError

	// The time when the latest effective policy was generated for the specified
	// account.
	EvaluationTimestamp *time.Time

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You should
	// repeat this until the NextToken response element comes back as null .
	NextToken *string

	// The path in the organization where the specified account exists.
	Path *string

	// The specified policy type. One of the following values:
	//
	// [DECLARATIVE_POLICY_EC2]
	//
	// [BACKUP_POLICY]
	//
	// [TAG_POLICY]
	//
	// [CHATBOT_POLICY]
	//
	// [AISERVICES_OPT_OUT_POLICY]
	//
	// [SECURITYHUB_POLICY]
	//
	// [UPGRADE_ROLLOUT_POLICY]
	//
	// [INSPECTOR_POLICY]
	//
	// [BEDROCK_POLICY]
	//
	// [S3_POLICY]
	//
	// [AISERVICES_OPT_OUT_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html
	// [BEDROCK_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_bedrock.html
	// [UPGRADE_ROLLOUT_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_upgrade_rollout.html
	// [SECURITYHUB_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html
	// [BACKUP_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html
	// [CHATBOT_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html
	// [TAG_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html
	// [DECLARATIVE_POLICY_EC2]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html
	// [INSPECTOR_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_inspector.html
	// [S3_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_S3.html
	PolicyType types.EffectivePolicyType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEffectivePolicyValidationErrorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListEffectivePolicyValidationErrors{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListEffectivePolicyValidationErrors{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEffectivePolicyValidationErrors"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListEffectivePolicyValidationErrorsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEffectivePolicyValidationErrors(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListEffectivePolicyValidationErrorsPaginatorOptions is the paginator options
// for ListEffectivePolicyValidationErrors
type ListEffectivePolicyValidationErrorsPaginatorOptions struct {
	// The maximum number of items to return in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response so
	// that you can retrieve the remaining results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEffectivePolicyValidationErrorsPaginator is a paginator for
// ListEffectivePolicyValidationErrors
type ListEffectivePolicyValidationErrorsPaginator struct {
	options   ListEffectivePolicyValidationErrorsPaginatorOptions
	client    ListEffectivePolicyValidationErrorsAPIClient
	params    *ListEffectivePolicyValidationErrorsInput
	nextToken *string
	firstPage bool
}

// NewListEffectivePolicyValidationErrorsPaginator returns a new
// ListEffectivePolicyValidationErrorsPaginator
func NewListEffectivePolicyValidationErrorsPaginator(client ListEffectivePolicyValidationErrorsAPIClient, params *ListEffectivePolicyValidationErrorsInput, optFns ...func(*ListEffectivePolicyValidationErrorsPaginatorOptions)) *ListEffectivePolicyValidationErrorsPaginator {
	if params == nil {
		params = &ListEffectivePolicyValidationErrorsInput{}
	}

	options := ListEffectivePolicyValidationErrorsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEffectivePolicyValidationErrorsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEffectivePolicyValidationErrorsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEffectivePolicyValidationErrors page.
func (p *ListEffectivePolicyValidationErrorsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEffectivePolicyValidationErrorsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEffectivePolicyValidationErrors(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEffectivePolicyValidationErrorsAPIClient is a client that implements the
// ListEffectivePolicyValidationErrors operation.
type ListEffectivePolicyValidationErrorsAPIClient interface {
	ListEffectivePolicyValidationErrors(context.Context, *ListEffectivePolicyValidationErrorsInput, ...func(*Options)) (*ListEffectivePolicyValidationErrorsOutput, error)
}

var _ ListEffectivePolicyValidationErrorsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEffectivePolicyValidationErrors(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEffectivePolicyValidationErrors",
	}
}
