// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralaccount

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralaccount/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Cancels a pending connection invitation before it has been accepted or rejected.
func (c *Client) CancelConnectionInvitation(ctx context.Context, params *CancelConnectionInvitationInput, optFns ...func(*Options)) (*CancelConnectionInvitationOutput, error) {
	if params == nil {
		params = &CancelConnectionInvitationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CancelConnectionInvitation", params, optFns, c.addOperationCancelConnectionInvitationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CancelConnectionInvitationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CancelConnectionInvitationInput struct {

	// The catalog identifier where the connection invitation exists.
	//
	// This member is required.
	Catalog *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	//
	// This member is required.
	ClientToken *string

	// The unique identifier of the connection invitation to cancel.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type CancelConnectionInvitationOutput struct {

	// The Amazon Resource Name (ARN) of the canceled connection invitation.
	//
	// This member is required.
	Arn *string

	// The catalog identifier where the connection invitation was canceled.
	//
	// This member is required.
	Catalog *string

	// The type of connection that was being invited for.
	//
	// This member is required.
	ConnectionType types.ConnectionType

	// The timestamp when the connection invitation was originally created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the canceled connection invitation.
	//
	// This member is required.
	Id *string

	// The message that was included with the original connection invitation.
	//
	// This member is required.
	InvitationMessage *string

	// The email address of the person who sent the connection invitation.
	//
	// This member is required.
	InviterEmail *string

	// The name of the person who sent the connection invitation.
	//
	// This member is required.
	InviterName *string

	// The identifier of the other participant who was invited to connect.
	//
	// This member is required.
	OtherParticipantIdentifier *string

	// The type of participant (inviter or invitee) in the connection invitation.
	//
	// This member is required.
	ParticipantType types.ParticipantType

	// The current status of the connection invitation (canceled).
	//
	// This member is required.
	Status types.InvitationStatus

	// The timestamp when the connection invitation was last updated (canceled).
	//
	// This member is required.
	UpdatedAt *time.Time

	// The identifier of the connection associated with the canceled invitation.
	ConnectionId *string

	// The timestamp when the connection invitation would have expired if not canceled.
	ExpiresAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCancelConnectionInvitationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCancelConnectionInvitation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCancelConnectionInvitation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CancelConnectionInvitation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCancelConnectionInvitationMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCancelConnectionInvitationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCancelConnectionInvitation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCancelConnectionInvitation struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCancelConnectionInvitation) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCancelConnectionInvitation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CancelConnectionInvitationInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CancelConnectionInvitationInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCancelConnectionInvitationMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCancelConnectionInvitation{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCancelConnectionInvitation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CancelConnectionInvitation",
	}
}
