// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralaccount

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralaccount/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a new connection invitation to establish a partnership with another
// organization.
func (c *Client) CreateConnectionInvitation(ctx context.Context, params *CreateConnectionInvitationInput, optFns ...func(*Options)) (*CreateConnectionInvitationOutput, error) {
	if params == nil {
		params = &CreateConnectionInvitationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateConnectionInvitation", params, optFns, c.addOperationCreateConnectionInvitationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateConnectionInvitationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateConnectionInvitationInput struct {

	// The catalog identifier where the connection invitation will be created.
	//
	// This member is required.
	Catalog *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	//
	// This member is required.
	ClientToken *string

	// The type of connection being requested (e.g., reseller, distributor, technology
	// partner).
	//
	// This member is required.
	ConnectionType types.ConnectionType

	// The email address of the person to send the connection invitation to.
	//
	// This member is required.
	Email *string

	// A custom message to include with the connection invitation.
	//
	// This member is required.
	Message *string

	// The name of the person sending the connection invitation.
	//
	// This member is required.
	Name *string

	// The identifier of the organization or partner to invite for connection.
	//
	// This member is required.
	ReceiverIdentifier *string

	noSmithyDocumentSerde
}

type CreateConnectionInvitationOutput struct {

	// The Amazon Resource Name (ARN) of the created connection invitation.
	//
	// This member is required.
	Arn *string

	// The catalog identifier where the connection invitation was created.
	//
	// This member is required.
	Catalog *string

	// The type of connection being requested in the invitation.
	//
	// This member is required.
	ConnectionType types.ConnectionType

	// The timestamp when the connection invitation was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the created connection invitation.
	//
	// This member is required.
	Id *string

	// The custom message included with the connection invitation.
	//
	// This member is required.
	InvitationMessage *string

	// The email address of the person who sent the connection invitation.
	//
	// This member is required.
	InviterEmail *string

	// The name of the person who sent the connection invitation.
	//
	// This member is required.
	InviterName *string

	// The identifier of the organization or partner being invited.
	//
	// This member is required.
	OtherParticipantIdentifier *string

	// The type of participant (inviter or invitee) in the connection invitation.
	//
	// This member is required.
	ParticipantType types.ParticipantType

	// The current status of the connection invitation (pending, accepted, rejected,
	// etc.).
	//
	// This member is required.
	Status types.InvitationStatus

	// The timestamp when the connection invitation was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The identifier of the connection associated with this invitation.
	ConnectionId *string

	// The timestamp when the connection invitation will expire if not responded to.
	ExpiresAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateConnectionInvitationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateConnectionInvitation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateConnectionInvitation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateConnectionInvitation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateConnectionInvitationMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateConnectionInvitationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateConnectionInvitation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateConnectionInvitation struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateConnectionInvitation) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateConnectionInvitation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateConnectionInvitationInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateConnectionInvitationInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateConnectionInvitationMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateConnectionInvitation{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateConnectionInvitation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateConnectionInvitation",
	}
}
