// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralaccount

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralaccount/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a new partner account in the AWS Partner Network with the specified
// details and configuration.
func (c *Client) CreatePartner(ctx context.Context, params *CreatePartnerInput, optFns ...func(*Options)) (*CreatePartnerOutput, error) {
	if params == nil {
		params = &CreatePartnerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreatePartner", params, optFns, c.addOperationCreatePartnerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreatePartnerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreatePartnerInput struct {

	// The primary contact person for alliance and partnership matters.
	//
	// This member is required.
	AllianceLeadContact *types.AllianceLeadContact

	// The catalog identifier where the partner account will be created.
	//
	// This member is required.
	Catalog *string

	// The verification code sent to the alliance lead contact's email to confirm
	// account creation.
	//
	// This member is required.
	EmailVerificationCode *string

	// The legal name of the organization becoming a partner.
	//
	// This member is required.
	LegalName *string

	// The primary type of solution or service the partner provides (e.g., consulting,
	// software, managed services).
	//
	// This member is required.
	PrimarySolutionType types.PrimarySolutionType

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string

	// A list of tags to associate with the partner account for organization and
	// billing purposes.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreatePartnerOutput struct {

	// The alliance lead contact information for the partner account.
	//
	// This member is required.
	AllianceLeadContact *types.AllianceLeadContact

	// The Amazon Resource Name (ARN) of the created partner account.
	//
	// This member is required.
	Arn *string

	// The catalog identifier where the partner account was created.
	//
	// This member is required.
	Catalog *string

	// The timestamp when the partner account was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the created partner account.
	//
	// This member is required.
	Id *string

	// The legal name of the partner organization.
	//
	// This member is required.
	LegalName *string

	// The partner profile information including display name, description, and other
	// public details.
	//
	// This member is required.
	Profile *types.PartnerProfile

	// The list of verified email domains associated with AWS training and
	// certification credentials for the partner organization.
	AwsTrainingCertificationEmailDomains []types.PartnerDomain

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreatePartnerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreatePartner{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreatePartner{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreatePartner"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreatePartnerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreatePartnerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreatePartner(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreatePartner struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreatePartner) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreatePartner) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreatePartnerInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreatePartnerInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreatePartnerMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreatePartner{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreatePartner(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreatePartner",
	}
}
