// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralaccount

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralaccount/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about a specific profile update task.
func (c *Client) GetProfileUpdateTask(ctx context.Context, params *GetProfileUpdateTaskInput, optFns ...func(*Options)) (*GetProfileUpdateTaskOutput, error) {
	if params == nil {
		params = &GetProfileUpdateTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetProfileUpdateTask", params, optFns, c.addOperationGetProfileUpdateTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetProfileUpdateTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetProfileUpdateTaskInput struct {

	// The catalog identifier for the partner account.
	//
	// This member is required.
	Catalog *string

	// The unique identifier of the partner account.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetProfileUpdateTaskOutput struct {

	// The Amazon Resource Name (ARN) of the profile update task.
	//
	// This member is required.
	Arn *string

	// The catalog identifier for the partner account.
	//
	// This member is required.
	Catalog *string

	// The unique identifier of the partner account.
	//
	// This member is required.
	Id *string

	// The timestamp when the profile update task was started.
	//
	// This member is required.
	StartedAt *time.Time

	// The current status of the profile update task (in progress, completed, failed,
	// etc.).
	//
	// This member is required.
	Status types.ProfileTaskStatus

	// The details of the profile update task including what changes are being made.
	//
	// This member is required.
	TaskDetails *types.TaskDetails

	// The unique identifier of the profile update task.
	//
	// This member is required.
	TaskId *string

	// The timestamp when the profile update task was completed or failed.
	EndedAt *time.Time

	// A list of error details if any errors occurred during the profile update task.
	ErrorDetailList []types.ErrorDetail

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetProfileUpdateTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetProfileUpdateTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetProfileUpdateTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetProfileUpdateTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetProfileUpdateTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetProfileUpdateTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetProfileUpdateTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetProfileUpdateTask",
	}
}
